/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.featuregroup.cached;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.cached.CachedFeaturegroup;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.cached.HivePartitions;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.cached.HiveTbls;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import javax.validation.ConstraintViolationException;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.REQUIRED)
public class CachedFeaturegroupFacade
extends AbstractFacade<CachedFeaturegroup> {
    private static final Logger LOGGER = Logger.getLogger(CachedFeaturegroupFacade.class.getName());
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    public CachedFeaturegroupFacade() {
        super(CachedFeaturegroup.class);
    }

    public void persist(CachedFeaturegroup cachedFeaturegroup) {
        try {
            this.em.persist((Object)cachedFeaturegroup);
            this.em.flush();
        }
        catch (ConstraintViolationException cve) {
            LOGGER.log(Level.WARNING, "Could not persist the new cached feature group", cve);
            throw cve;
        }
    }

    public Optional<HiveTbls> getHiveTableByNameAndDB(String hiveTableName, Long hiveDbId) {
        try {
            return Optional.of(this.em.createNamedQuery("HiveTable.findByNameAndDbId", HiveTbls.class).setParameter("name", (Object)hiveTableName.toLowerCase()).setParameter("dbId", (Object)hiveDbId).getSingleResult());
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }

    public Optional<HiveTbls> getHiveTable(Long hiveTableId) {
        try {
            return Optional.of(this.em.createNamedQuery("HiveTable.findById", HiveTbls.class).setParameter("id", (Object)hiveTableId).getSingleResult());
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }

    @Override
    protected EntityManager getEntityManager() {
        return this.em;
    }

    public CachedFeaturegroup updateMetadata(CachedFeaturegroup cachedFeaturegroup) {
        this.em.merge((Object)cachedFeaturegroup);
        return cachedFeaturegroup;
    }

    public List<HivePartitions> getHiveTablePartitions(HiveTbls hiveTbls, Integer limit, Integer offset) {
        TypedQuery q = this.em.createNamedQuery("Partitions.findByTbl", HivePartitions.class).setParameter("tbls", (Object)hiveTbls);
        if (offset != null && offset > 0) {
            q.setFirstResult(offset.intValue());
        }
        if (limit != null && limit > 0) {
            q.setMaxResults(limit.intValue());
        }
        return q.getResultList();
    }
}

