/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.activity;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.persistence.entity.featurestore.activity.ActivityType;
import io.hops.hopsworks.persistence.entity.featurestore.activity.FeaturestoreActivity;
import io.hops.hopsworks.persistence.entity.featurestore.activity.FeaturestoreActivityMeta;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.Featuregroup;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.cached.FeatureGroupCommit;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.datavalidation.FeatureGroupValidation;
import io.hops.hopsworks.persistence.entity.featurestore.statistics.FeaturestoreStatistic;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.TrainingDataset;
import io.hops.hopsworks.persistence.entity.jobs.history.Execution;
import io.hops.hopsworks.persistence.entity.user.Users;
import java.util.Date;
import java.util.Optional;
import java.util.Set;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;

@Stateless
public class FeaturestoreActivityFacade
extends AbstractFacade<FeaturestoreActivity> {
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    public FeaturestoreActivityFacade() {
        super(FeaturestoreActivity.class);
    }

    @Override
    protected EntityManager getEntityManager() {
        return this.em;
    }

    public void logMetadataActivity(Users user, Featuregroup featuregroup, FeaturestoreActivityMeta metadataType, String additionalMsg) {
        FeaturestoreActivity fsActivity = new FeaturestoreActivity();
        fsActivity.setType(ActivityType.METADATA);
        fsActivity.setFeatureGroup(featuregroup);
        fsActivity.setUser(user);
        fsActivity.setEventTime(new Date());
        fsActivity.setActivityMeta(metadataType);
        fsActivity.setActivityMetaMsg(additionalMsg);
        this.em.persist((Object)fsActivity);
    }

    public void logMetadataActivity(Users user, TrainingDataset trainingDataset, FeaturestoreActivityMeta metadataType) {
        FeaturestoreActivity fsActivity = new FeaturestoreActivity();
        fsActivity.setType(ActivityType.METADATA);
        fsActivity.setTrainingDataset(trainingDataset);
        fsActivity.setUser(user);
        fsActivity.setEventTime(new Date());
        fsActivity.setActivityMeta(metadataType);
        this.em.persist((Object)fsActivity);
    }

    public void logStatisticsActivity(Users user, Featuregroup featuregroup, Date eventTime, FeaturestoreStatistic statistics) {
        FeaturestoreActivity fsActivity = new FeaturestoreActivity();
        fsActivity.setType(ActivityType.STATISTICS);
        fsActivity.setFeatureGroup(featuregroup);
        fsActivity.setUser(user);
        fsActivity.setEventTime(eventTime);
        fsActivity.setStatistics(statistics);
        this.em.persist((Object)fsActivity);
    }

    public void logStatisticsActivity(Users user, TrainingDataset trainingDataset, Date eventTime, FeaturestoreStatistic statistics) {
        FeaturestoreActivity fsActivity = new FeaturestoreActivity();
        fsActivity.setType(ActivityType.STATISTICS);
        fsActivity.setTrainingDataset(trainingDataset);
        fsActivity.setUser(user);
        fsActivity.setEventTime(eventTime);
        fsActivity.setStatistics(statistics);
        this.em.persist((Object)fsActivity);
    }

    public void logCommitActivity(Users user, Featuregroup featuregroup, FeatureGroupCommit commit) {
        FeaturestoreActivity fsActivity = new FeaturestoreActivity();
        fsActivity.setType(ActivityType.COMMIT);
        fsActivity.setFeatureGroup(featuregroup);
        fsActivity.setUser(user);
        fsActivity.setEventTime(new Date(commit.getCommittedOn()));
        fsActivity.setCommit(commit);
        this.em.persist((Object)fsActivity);
    }

    public void logExecutionActivity(Featuregroup featuregroup, Execution execution, Long executionLastEventTime) {
        FeaturestoreActivity fsActivity = null;
        try {
            fsActivity = (FeaturestoreActivity)this.em.createNamedQuery("FeaturestoreActivity.findByFgExecution", FeaturestoreActivity.class).setParameter("featureGroup", (Object)featuregroup).setParameter("execution", (Object)execution).getSingleResult();
        }
        catch (NoResultException e) {
            fsActivity = new FeaturestoreActivity();
            fsActivity.setType(ActivityType.JOB);
            fsActivity.setFeatureGroup(featuregroup);
            fsActivity.setUser(execution.getUser());
            fsActivity.setEventTime(execution.getSubmissionTime());
            fsActivity.setExecution(execution);
        }
        fsActivity.setExecutionLastEventTime(executionLastEventTime);
        this.em.merge((Object)fsActivity);
    }

    public void logExecutionActivity(TrainingDataset trainingDataset, Execution execution, Long executionLastEventTime) {
        FeaturestoreActivity fsActivity = null;
        try {
            fsActivity = (FeaturestoreActivity)this.em.createNamedQuery("FeaturestoreActivity.findByTdExecution", FeaturestoreActivity.class).setParameter("trainingDataset", (Object)trainingDataset).setParameter("execution", (Object)execution).getSingleResult();
        }
        catch (NoResultException e) {
            fsActivity = new FeaturestoreActivity();
            fsActivity.setType(ActivityType.JOB);
            fsActivity.setTrainingDataset(trainingDataset);
            fsActivity.setUser(execution.getUser());
            fsActivity.setEventTime(execution.getSubmissionTime());
            fsActivity.setExecution(execution);
        }
        fsActivity.setExecutionLastEventTime(executionLastEventTime);
        this.em.merge((Object)fsActivity);
    }

    public void logValidationActivity(Featuregroup featureGroup, Users user, FeatureGroupValidation validation) {
        FeaturestoreActivity fsActivity = new FeaturestoreActivity();
        fsActivity.setType(ActivityType.VALIDATIONS);
        fsActivity.setFeatureGroup(featureGroup);
        fsActivity.setUser(user);
        fsActivity.setEventTime(validation.getValidationTime());
        fsActivity.setValidation(validation);
        this.em.persist((Object)fsActivity);
    }

    public Optional<FeaturestoreActivity> getMostRecentExecution(Featuregroup featuregroup) {
        try {
            return Optional.of(this.em.createNamedQuery("FeaturestoreActivity.lastFgExecution", FeaturestoreActivity.class).setParameter("featureGroup", (Object)featuregroup).setParameter("type", (Object)ActivityType.JOB).setMaxResults(1).getSingleResult());
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }

    public Optional<FeaturestoreActivity> getMostRecentExecution(TrainingDataset trainingDataset) {
        try {
            return Optional.of(this.em.createNamedQuery("FeaturestoreActivity.lastTdExecution", FeaturestoreActivity.class).setParameter("trainingDataset", (Object)trainingDataset).setParameter("type", (Object)ActivityType.JOB).setMaxResults(1).getSingleResult());
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }

    public AbstractFacade.CollectionInfo<FeaturestoreActivity> findByFeaturegroup(Featuregroup featuregroup, Integer offset, Integer limit, Set<? extends AbstractFacade.FilterBy> filters, Set<? extends AbstractFacade.SortBy> sorts) {
        String queryStr = this.buildQuery("SELECT a FROM FeaturestoreActivity a ", filters, sorts, "a.featureGroup = :featureGroup");
        String queryCountStr = this.buildQuery("SELECT COUNT(DISTINCT a.id) FROM FeaturestoreActivity a ", filters, sorts, "a.featureGroup = :featureGroup");
        TypedQuery query = this.em.createQuery(queryStr, FeaturestoreActivity.class).setParameter("featureGroup", (Object)featuregroup);
        this.setFilters(filters, (Query)query);
        this.setOffsetAndLim(offset, limit, (Query)query);
        TypedQuery queryCount = this.em.createQuery(queryCountStr, FeaturestoreActivity.class).setParameter("featureGroup", (Object)featuregroup);
        this.setFilters(filters, (Query)queryCount);
        return new AbstractFacade.CollectionInfo<FeaturestoreActivity>((Long)queryCount.getSingleResult(), query.getResultList());
    }

    public AbstractFacade.CollectionInfo<FeaturestoreActivity> findByTrainingDataset(TrainingDataset trainingDataset, Integer offset, Integer limit, Set<? extends AbstractFacade.FilterBy> filters, Set<? extends AbstractFacade.SortBy> sorts) {
        String queryStr = this.buildQuery("SELECT a FROM FeaturestoreActivity a ", filters, sorts, "a.trainingDataset = :trainingDataset");
        String queryCountStr = this.buildQuery("SELECT COUNT(DISTINCT a.id) FROM FeaturestoreActivity a ", filters, sorts, "a.trainingDataset = :trainingDataset");
        TypedQuery query = this.em.createQuery(queryStr, FeaturestoreActivity.class).setParameter("trainingDataset", (Object)trainingDataset);
        this.setFilters(filters, (Query)query);
        this.setOffsetAndLim(offset, limit, (Query)query);
        TypedQuery queryCount = this.em.createQuery(queryCountStr, FeaturestoreActivity.class).setParameter("trainingDataset", (Object)trainingDataset);
        this.setFilters(filters, (Query)queryCount);
        return new AbstractFacade.CollectionInfo<FeaturestoreActivity>((Long)queryCount.getSingleResult(), query.getResultList());
    }

    private void setFilters(Set<? extends AbstractFacade.FilterBy> filters, Query query) {
        if (filters == null || filters.isEmpty()) {
            return;
        }
        for (AbstractFacade.FilterBy filterBy : filters) {
            this.setFilterQuery(filterBy, query);
        }
    }

    private void setFilterQuery(AbstractFacade.FilterBy filterBy, Query query) {
        switch (Filters.valueOf(filterBy.getValue())) {
            case TYPE: {
                query.setParameter(filterBy.getField(), (Object)ActivityType.valueOf((String)filterBy.getParam().toUpperCase()));
                break;
            }
            case TIMESTAMP_GT: 
            case TIMESTAMP_LT: {
                query.setParameter(filterBy.getField(), (Object)new Date(Long.parseLong(filterBy.getParam())));
            }
        }
    }

    public static enum Filters {
        TYPE("TYPE", "a.type = :type ", "type", ""),
        TIMESTAMP_LT("TIMESTAMP_LT", "a.eventTime < :eventTimeLt ", "eventTimeLt", ""),
        TIMESTAMP_GT("TIMESTAMP_GT", "a.eventTime > :eventTimeGt ", "eventTimeGt", "");

        private final String value;
        private final String sql;
        private final String field;
        private final String defaultParam;

        private Filters(String value, String sql, String field, String defaultParam) {
            this.value = value;
            this.sql = sql;
            this.field = field;
            this.defaultParam = defaultParam;
        }

        public String getValue() {
            return this.value;
        }

        public String getDefaultParam() {
            return this.defaultParam;
        }

        public String getSql() {
            return this.sql;
        }

        public String getField() {
            return this.field;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Sorts {
        TIMESTAMP("TIMESTAMP", "a.eventTime", "DESC");

        private final String value;
        private final String sql;
        private final String defaultParam;

        private Sorts(String value, String sql, String defaultParam) {
            this.value = value;
            this.sql = sql;
            this.defaultParam = defaultParam;
        }

        public String getValue() {
            return this.value;
        }

        public String getSql() {
            return this.sql;
        }

        public String getDefaultParam() {
            return this.defaultParam;
        }
    }
}

