/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.trainingdatasets;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.common.featurestore.trainingdatasets.external.ExternalTrainingDatasetFacade;
import io.hops.hopsworks.common.featurestore.trainingdatasets.hopsfs.HopsfsTrainingDatasetFacade;
import io.hops.hopsworks.persistence.entity.featurestore.Featurestore;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.TrainingDataset;
import java.util.List;
import java.util.Optional;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;

@Stateless
public class TrainingDatasetFacade
extends AbstractFacade<TrainingDataset> {
    private static final Logger LOGGER = Logger.getLogger(TrainingDatasetFacade.class.getName());
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;
    @EJB
    private HopsfsTrainingDatasetFacade hopsfsTrainingDatasetFacade;
    @EJB
    private ExternalTrainingDatasetFacade externalTrainingDatasetFacade;

    public TrainingDatasetFacade() {
        super(TrainingDataset.class);
    }

    public TrainingDataset findById(Integer id) {
        try {
            return (TrainingDataset)this.em.createNamedQuery("TrainingDataset.findById", TrainingDataset.class).setParameter("id", (Object)id).getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public Optional<TrainingDataset> findByIdAndFeaturestore(Integer id, Featurestore featurestore) {
        try {
            return Optional.of(this.em.createNamedQuery("TrainingDataset.findByFeaturestoreAndId", TrainingDataset.class).setParameter("featurestore", (Object)featurestore).setParameter("id", (Object)id).getSingleResult());
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }

    public List<TrainingDataset> findByNameAndFeaturestore(String name, Featurestore featurestore) {
        return this.em.createNamedQuery("TrainingDataset.findByFeaturestoreAndName", TrainingDataset.class).setParameter("featurestore", (Object)featurestore).setParameter("name", (Object)name).getResultList();
    }

    public List<TrainingDataset> findByNameAndFeaturestoreOrderedDescVersion(String name, Featurestore featurestore) {
        return this.em.createNamedQuery("TrainingDataset.findByFeaturestoreAndNameOrderedByDescVersion", TrainingDataset.class).setParameter("featurestore", (Object)featurestore).setParameter("name", (Object)name).getResultList();
    }

    public Optional<TrainingDataset> findByNameVersionAndFeaturestore(String name, Integer version, Featurestore featurestore) {
        try {
            return Optional.of(this.em.createNamedQuery("TrainingDataset.findByFeaturestoreAndNameVersion", TrainingDataset.class).setParameter("featurestore", (Object)featurestore).setParameter("name", (Object)name).setParameter("version", (Object)version).getSingleResult());
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }

    @Override
    public List<TrainingDataset> findAll() {
        TypedQuery q = this.em.createNamedQuery("TrainingDataset.findAll", TrainingDataset.class);
        return q.getResultList();
    }

    public List<TrainingDataset> findByFeaturestore(Featurestore featurestore) {
        TypedQuery q = this.em.createNamedQuery("TrainingDataset.findByFeaturestore", TrainingDataset.class).setParameter("featurestore", (Object)featurestore);
        return q.getResultList();
    }

    public Long countByFeaturestore(Featurestore featurestore) {
        return (Long)this.em.createNamedQuery("TrainingDataset.countByFeaturestore", Long.class).setParameter("featurestore", (Object)featurestore).getSingleResult();
    }

    @Override
    protected EntityManager getEntityManager() {
        return this.em;
    }

    public void removeTrainingDataset(TrainingDataset trainingDataset) {
        switch (trainingDataset.getTrainingDatasetType()) {
            case HOPSFS_TRAINING_DATASET: {
                this.hopsfsTrainingDatasetFacade.remove(trainingDataset.getHopsfsTrainingDataset());
                break;
            }
            case EXTERNAL_TRAINING_DATASET: {
                this.externalTrainingDatasetFacade.remove(trainingDataset.getExternalTrainingDataset());
            }
        }
        this.remove(trainingDataset);
    }
}

