/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.security;

import com.auth0.jwt.interfaces.DecodedJWT;
import com.google.common.base.Strings;
import io.hops.hopsworks.common.util.DateUtils;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.jwt.JWTController;
import io.hops.hopsworks.jwt.exception.JWTException;
import java.io.Serializable;
import java.security.NoSuchAlgorithmException;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.DependsOn;
import javax.ejb.EJB;
import javax.ejb.Lock;
import javax.ejb.LockType;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.Timeout;
import javax.ejb.TimerConfig;
import javax.ejb.TimerService;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.util.BackOff;
import org.apache.hadoop.util.ExponentialBackOff;

@Singleton
@Startup
@DependsOn(value={"Settings"})
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class ServiceJWTKeepAlive {
    private static final Logger LOGGER = Logger.getLogger(ServiceJWTKeepAlive.class.getName());
    private static final List<String> SERVICE_RENEW_JWT_AUDIENCE = new ArrayList<String>(1);
    @EJB
    private Settings settings;
    @EJB
    private JWTController jwtController;
    @Resource
    private TimerService timerService;
    private String hostname;
    private BackOff backOff;

    @PostConstruct
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void init() {
        this.hostname = "hopsworks";
        this.backOff = new ExponentialBackOff.Builder().setInitialIntervalMillis(100L).setMaximumIntervalMillis(2000L).setMultiplier(2.0).setMaximumRetries(4).build();
        long interval = Math.min(10000L, Math.max(500L, this.settings.getServiceJWTLifetimeMS() / 2L));
        this.timerService.createIntervalTimer(5000L, interval, new TimerConfig((Serializable)((Object)"Service JWT renewer"), false));
    }

    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    @Timeout
    @Lock(value=LockType.WRITE)
    public void renewServiceToken() {
        try {
            this.doRenew(false);
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Error renewing service JWT", ex);
        }
    }

    @Lock(value=LockType.WRITE)
    public void forceRenewServiceToken() throws JWTException {
        try {
            this.doRenew(true);
        }
        catch (InterruptedException ex) {
            LOGGER.log(Level.SEVERE, "Could not renew service JWT", ex);
            throw new JWTException(ex.getMessage(), (Throwable)ex);
        }
    }

    private void doRenew(boolean force) throws JWTException, InterruptedException {
        String masterToken = this.settings.getServiceMasterJWT();
        if (Strings.isNullOrEmpty((String)masterToken)) {
            throw new JWTException("Master token is empty!");
        }
        LocalDateTime now = DateUtils.getNow();
        DecodedJWT masterJWT = this.jwtController.decodeToken(masterToken);
        if (force || this.maybeRenewMasterToken(masterJWT, now)) {
            String[] renewalTokens = this.settings.getServiceRenewJWTs();
            List<String> masterJWTRoles = this.getJWTRoles(masterJWT);
            String user = masterJWT.getSubject();
            this.backOff.reset();
            for (int renewIdx = 0; renewIdx < renewalTokens.length; ++renewIdx) {
                String oneTimeToken = renewalTokens[renewIdx];
                Date notBefore = DateUtils.localDateTime2Date(now);
                LocalDateTime expiresAt = now.plus(this.settings.getServiceJWTLifetimeMS(), ChronoUnit.MILLIS);
                try {
                    Pair renewedTokens = this.jwtController.renewServiceToken(oneTimeToken, masterToken, DateUtils.localDateTime2Date(expiresAt), notBefore, Long.valueOf(this.settings.getServiceJWTLifetimeMS()), user, masterJWTRoles, SERVICE_RENEW_JWT_AUDIENCE, this.hostname, this.settings.getJWTIssuer(), this.settings.getJWTSigningKeyName(), force);
                    LOGGER.log(Level.FINEST, "New master JWT: " + (String)renewedTokens.getLeft());
                    this.updateTokens((Pair<String, String[]>)renewedTokens);
                    LOGGER.log(Level.FINEST, "Invalidating JWT: " + masterToken);
                    this.jwtController.invalidateServiceToken(masterToken, this.settings.getJWTSigningKeyName());
                    break;
                }
                catch (JWTException | NoSuchAlgorithmException ex) {
                    Long backoffTimeout = this.backOff.getBackOffInMillis();
                    if (backoffTimeout != -1L) {
                        LOGGER.log(Level.WARNING, "Failed to renew service JWT, retrying in " + backoffTimeout + " ms");
                        TimeUnit.MILLISECONDS.sleep(backoffTimeout);
                        continue;
                    }
                    this.backOff.reset();
                    throw new JWTException("Cannot renew service JWT");
                }
            }
            LOGGER.log(Level.FINE, "Successfully renewed service JWT");
        }
    }

    private void updateTokens(Pair<String, String[]> tokens) {
        this.settings.setServiceMasterJWT((String)tokens.getLeft());
        this.settings.setServiceRenewJWTs((String[])tokens.getRight());
    }

    private List<String> getJWTRoles(DecodedJWT jwt) {
        String[] rolesArray = this.jwtController.getRolesClaim(jwt);
        return Arrays.asList(rolesArray);
    }

    private boolean maybeRenewMasterToken(DecodedJWT jwt, LocalDateTime now) {
        LocalDateTime expiresAt = DateUtils.date2LocalDateTime(jwt.getExpiresAt());
        return expiresAt.isBefore(now) || expiresAt.isEqual(now);
    }

    static {
        SERVICE_RENEW_JWT_AUDIENCE.add("services");
    }
}

