/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.trainingdatasets.external;

import com.google.common.base.Strings;
import io.hops.hopsworks.common.featurestore.storageconnectors.FeaturestoreStorageConnectorController;
import io.hops.hopsworks.common.featurestore.trainingdatasets.TrainingDatasetDTO;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.persistence.entity.featurestore.storageconnector.adls.FeaturestoreADLSConnector;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.TrainingDataset;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.external.ExternalTrainingDataset;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.restutils.RESTCodes;
import java.nio.file.Paths;
import java.util.logging.Level;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class ExternalTrainingDatasetController {
    @EJB
    private FeaturestoreStorageConnectorController storageConnectorController;
    private static final String ABFSS_SCHEME = "abfss://";
    private static final String ABFSS_URI_SUFFIX = ".dfs.core.windows.net";
    private static final String ADL_SCHEME = "adl://";
    private static final String ADL_URI_SUFFIX = ".azuredatalakestore.net";

    public TrainingDatasetDTO convertExternalTrainingDatasetToDTO(Users user, Project project, TrainingDatasetDTO trainingDatasetDTO, TrainingDataset trainingDataset) throws FeaturestoreException {
        ExternalTrainingDataset externalTrainingDataset = trainingDataset.getExternalTrainingDataset();
        trainingDatasetDTO.setStorageConnector(this.storageConnectorController.convertToConnectorDTO(user, project, externalTrainingDataset.getFeaturestoreConnector()));
        trainingDatasetDTO.setLocation(this.buildDatasetPath(trainingDataset));
        return trainingDatasetDTO;
    }

    private String buildDatasetPath(TrainingDataset trainingDataset) throws FeaturestoreException {
        switch (trainingDataset.getExternalTrainingDataset().getFeaturestoreConnector().getConnectorType()) {
            case S3: {
                return this.buildDatasetPathS3(trainingDataset);
            }
            case ADLS: {
                return this.buildDatasetPathADL(trainingDataset);
            }
        }
        throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STORAGE_CONNECTOR_TYPE, Level.SEVERE, "External training dataset type not supported");
    }

    private String buildDatasetPathS3(TrainingDataset trainingDataset) {
        String bucketFolder = "TRAINING_DATASETS";
        if (!Strings.isNullOrEmpty((String)trainingDataset.getExternalTrainingDataset().getPath())) {
            bucketFolder = trainingDataset.getExternalTrainingDataset().getPath();
        }
        return "s3://" + Paths.get(trainingDataset.getExternalTrainingDataset().getFeaturestoreConnector().getS3Connector().getBucket(), bucketFolder, trainingDataset.getName() + "_" + trainingDataset.getVersion()).toString();
    }

    private String buildDatasetPathADL(TrainingDataset trainingDataset) {
        FeaturestoreADLSConnector adlsConnector = trainingDataset.getExternalTrainingDataset().getFeaturestoreConnector().getAdlsConnector();
        String directory = Strings.isNullOrEmpty((String)trainingDataset.getExternalTrainingDataset().getPath()) ? "" : trainingDataset.getExternalTrainingDataset().getPath();
        String scheme = adlsConnector.getGeneration() == 1 ? ADL_SCHEME : ABFSS_SCHEME;
        String hostname = adlsConnector.getGeneration() == 1 ? adlsConnector.getAccountName() + ADL_URI_SUFFIX : adlsConnector.getContainerName() + "@" + adlsConnector.getAccountName() + ABFSS_URI_SUFFIX;
        return scheme + hostname + "/" + directory + trainingDataset.getName() + "_" + trainingDataset.getVersion();
    }
}

