/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.project.jobconfig;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.common.dao.jobs.description.JobFacade;
import io.hops.hopsworks.persistence.entity.jobs.configuration.DefaultJobConfigurationPK;
import io.hops.hopsworks.persistence.entity.jobs.configuration.JobConfiguration;
import io.hops.hopsworks.persistence.entity.jobs.configuration.JobType;
import io.hops.hopsworks.persistence.entity.jobs.configuration.spark.SparkJobConfiguration;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.project.jobs.DefaultJobConfiguration;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;

@Stateless
public class DefaultJobConfigurationFacade
extends AbstractFacade<DefaultJobConfiguration> {
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    @Override
    protected EntityManager getEntityManager() {
        return this.em;
    }

    public DefaultJobConfigurationFacade() {
        super(DefaultJobConfiguration.class);
    }

    @Override
    public List<DefaultJobConfiguration> findAll() {
        TypedQuery query = this.em.createNamedQuery("Project.findAll", DefaultJobConfiguration.class);
        return query.getResultList();
    }

    public DefaultJobConfiguration createOrUpdateDefaultJobConfig(Project project, JobConfiguration jobConfiguration, JobType jobType, DefaultJobConfiguration currentConfig) {
        if (jobConfiguration instanceof SparkJobConfiguration) {
            ((SparkJobConfiguration)jobConfiguration).setMainClass("org.apache.spark.deploy.PythonRunner");
            jobType = JobType.PYSPARK;
        }
        if (currentConfig == null) {
            currentConfig = new DefaultJobConfiguration();
            DefaultJobConfigurationPK pk = new DefaultJobConfigurationPK();
            pk.setProjectId(project.getId().intValue());
            pk.setType(jobType);
            currentConfig.setDefaultJobConfigurationPK(pk);
            currentConfig.setJobConfig(jobConfiguration);
            project.getDefaultJobConfigurationCollection().add(currentConfig);
        } else {
            currentConfig.setJobConfig(jobConfiguration);
        }
        this.em.merge((Object)project);
        return currentConfig;
    }

    public void removeDefaultJobConfig(Project project, JobType type) {
        Collection defaultJobConfigurationCollection = project.getDefaultJobConfigurationCollection();
        if (type.equals((Object)JobType.PYSPARK) || type.equals((Object)JobType.SPARK)) {
            defaultJobConfigurationCollection.removeIf(conf -> conf.getJobConfig().getJobType().equals((Object)JobType.PYSPARK));
        } else {
            defaultJobConfigurationCollection.removeIf(conf -> conf.getJobConfig().getJobType().equals((Object)type));
        }
        this.em.merge((Object)project);
    }

    public AbstractFacade.CollectionInfo findByProject(Integer offset, Integer limit, Set<? extends AbstractFacade.FilterBy> filter, Set<? extends AbstractFacade.SortBy> sort, Project project) {
        String queryStr = this.buildQuery("SELECT c FROM DefaultJobConfiguration c ", filter, sort, "c.project = :project");
        String queryCountStr = this.buildQuery("SELECT COUNT(DISTINCT c.defaultJobConfigurationPK.type) FROM DefaultJobConfiguration c ", filter, sort, "c.project = :project ");
        TypedQuery query = this.em.createQuery(queryStr, DefaultJobConfiguration.class).setParameter("project", (Object)project);
        TypedQuery queryCount = this.em.createQuery(queryCountStr, DefaultJobConfiguration.class).setParameter("project", (Object)project);
        return this.findAll(offset, limit, filter, (Query)query, (Query)queryCount);
    }

    private AbstractFacade.CollectionInfo findAll(Integer offset, Integer limit, Set<? extends AbstractFacade.FilterBy> filter, Query query, Query queryCount) {
        this.setFilter(filter, query);
        this.setFilter(filter, queryCount);
        this.setOffsetAndLim(offset, limit, query);
        return new AbstractFacade.CollectionInfo((Long)queryCount.getSingleResult(), query.getResultList());
    }

    private void setFilter(Set<? extends AbstractFacade.FilterBy> filter, Query q) {
        if (filter == null || filter.isEmpty()) {
            return;
        }
        for (AbstractFacade.FilterBy filterBy : filter) {
            this.setFilterQuery(filterBy, q);
        }
    }

    private void setFilterQuery(AbstractFacade.FilterBy filterBy, Query q) {
        switch (Filters.valueOf(filterBy.getValue())) {
            case JOBTYPE: {
                HashSet<JobType> jobTypes = new HashSet<JobType>(JobFacade.getJobTypes(filterBy.getField(), filterBy.getParam()));
                q.setParameter(filterBy.getField(), jobTypes);
                break;
            }
        }
    }

    public static enum Sorts {
        JOBTYPE("JOBTYPE", "c.defaultJobConfigurationPK.type ", "ASC");

        private final String value;
        private final String sql;
        private final String defaultParam;

        private Sorts(String value, String sql, String defaultParam) {
            this.value = value;
            this.sql = sql;
            this.defaultParam = defaultParam;
        }

        public String getValue() {
            return this.value;
        }

        public String getDefaultParam() {
            return this.defaultParam;
        }

        public String getSql() {
            return this.sql;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Filters {
        JOBTYPE("JOBTYPE", "c.defaultJobConfigurationPK.type IN :types ", "types", "");

        private final String value;
        private final String sql;
        private final String field;
        private final String defaultParam;

        private Filters(String value, String sql, String field, String defaultParam) {
            this.value = value;
            this.sql = sql;
            this.field = field;
            this.defaultParam = defaultParam;
        }

        public String getDefaultParam() {
            return this.defaultParam;
        }

        public String getValue() {
            return this.value;
        }

        public String getSql() {
            return this.sql;
        }

        public String getField() {
            return this.field;
        }

        public String toString() {
            return this.value;
        }
    }
}

