/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.storageconnectors.adls;

import com.google.common.base.Strings;
import io.hops.hopsworks.common.dao.user.UserFacade;
import io.hops.hopsworks.common.featurestore.OptionDTO;
import io.hops.hopsworks.common.featurestore.storageconnectors.adls.FeaturestoreADLSConnectorDTO;
import io.hops.hopsworks.common.security.secrets.SecretsController;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.exceptions.ProjectException;
import io.hops.hopsworks.exceptions.ServiceException;
import io.hops.hopsworks.exceptions.UserException;
import io.hops.hopsworks.persistence.entity.featurestore.Featurestore;
import io.hops.hopsworks.persistence.entity.featurestore.storageconnector.FeaturestoreConnector;
import io.hops.hopsworks.persistence.entity.featurestore.storageconnector.adls.FeaturestoreADLSConnector;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.persistence.entity.user.security.secrets.Secret;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.transaction.Transactional;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class FeaturestoreADLSConnectorController {
    @EJB
    private SecretsController secretsController;
    @EJB
    private UserFacade userFacade;

    public FeaturestoreADLSConnector createADLConnector(Users user, Project project, Featurestore featurestore, FeaturestoreADLSConnectorDTO adlConnectorDTO) throws FeaturestoreException, ProjectException, UserException {
        this.verifyConnectorDTO(adlConnectorDTO);
        String secretName = this.createSecretName(featurestore.getId(), adlConnectorDTO.getName());
        Secret secret = this.secretsController.createSecretForProject(user, secretName, adlConnectorDTO.getServiceCredential(), project.getId());
        FeaturestoreADLSConnector adlConnector = new FeaturestoreADLSConnector();
        adlConnector.setGeneration(adlConnectorDTO.getGeneration().intValue());
        adlConnector.setDirectoryId(adlConnectorDTO.getDirectoryId());
        adlConnector.setApplicationId(adlConnectorDTO.getApplicationId());
        adlConnector.setServiceCredentialSecret(secret);
        adlConnector.setAccountName(adlConnectorDTO.getAccountName());
        adlConnector.setContainerName(adlConnectorDTO.getContainerName());
        return adlConnector;
    }

    private String createSecretName(Integer featurestoreId, String connectorName) {
        return "adls_" + connectorName.replaceAll(" ", "_").toLowerCase() + "_" + featurestoreId;
    }

    public FeaturestoreADLSConnectorDTO getADLConnectorDTO(Users user, FeaturestoreConnector featurestoreConnector) {
        FeaturestoreADLSConnectorDTO adlsConnectorDTO = new FeaturestoreADLSConnectorDTO(featurestoreConnector);
        String serviceCredential = this.getServiceCredential(user, featurestoreConnector.getAdlsConnector());
        adlsConnectorDTO.setServiceCredential(serviceCredential);
        FeaturestoreADLSConnector adlsConnector = featurestoreConnector.getAdlsConnector();
        if (adlsConnector.getGeneration() == 1) {
            adlsConnectorDTO.setSparkOptions(this.getSparkOptionsGen1(adlsConnector, serviceCredential));
        } else if (adlsConnector.getGeneration() == 2) {
            adlsConnectorDTO.setSparkOptions(this.getSparkOptionsGen2(adlsConnector, serviceCredential));
        }
        return adlsConnectorDTO;
    }

    private String getServiceCredential(Users user, FeaturestoreADLSConnector adlsConnector) {
        Secret secret = adlsConnector.getServiceCredentialSecret();
        if (secret != null) {
            try {
                Users owner = (Users)this.userFacade.find(secret.getId().getUid());
                return this.secretsController.getShared(user, owner, secret.getId().getName()).getPlaintext();
            }
            catch (ProjectException | ServiceException | UserException throwable) {
                // empty catch block
            }
        }
        return null;
    }

    private List<OptionDTO> getSparkOptionsGen2(FeaturestoreADLSConnector adlsConnector, String serviceCredential) {
        ArrayList<OptionDTO> sparkOptions = new ArrayList<OptionDTO>();
        sparkOptions.add(new OptionDTO("fs.azure.account.auth.type." + adlsConnector.getAccountName() + ".dfs.core.windows.net", "OAuth"));
        sparkOptions.add(new OptionDTO("fs.azure.account.oauth.provider.type." + adlsConnector.getAccountName() + ".dfs.core.windows.net", "org.apache.hadoop.fs.azurebfs.oauth2.ClientCredsTokenProvider"));
        sparkOptions.add(new OptionDTO("fs.azure.account.oauth2.client.id." + adlsConnector.getAccountName() + ".dfs.core.windows.net", adlsConnector.getApplicationId()));
        sparkOptions.add(new OptionDTO("fs.azure.account.oauth2.client.secret." + adlsConnector.getAccountName() + ".dfs.core.windows.net", serviceCredential));
        sparkOptions.add(new OptionDTO("fs.azure.account.oauth2.client.endpoint." + adlsConnector.getAccountName() + ".dfs.core.windows.net", "https://login.microsoftonline.com/" + adlsConnector.getDirectoryId() + "/oauth2/token"));
        return sparkOptions;
    }

    private List<OptionDTO> getSparkOptionsGen1(FeaturestoreADLSConnector adlsConnector, String serviceCredential) {
        ArrayList<OptionDTO> sparkOptions = new ArrayList<OptionDTO>();
        sparkOptions.add(new OptionDTO("fs.adl.oauth2.access.token.provider.type", "ClientCredential"));
        sparkOptions.add(new OptionDTO("fs.adl.account." + adlsConnector.getAccountName() + ".oauth2.client.id", adlsConnector.getApplicationId()));
        sparkOptions.add(new OptionDTO("fs.adl.account." + adlsConnector.getAccountName() + ".oauth2.credential", serviceCredential));
        sparkOptions.add(new OptionDTO("fs.adl.account." + adlsConnector.getAccountName() + ".oauth2.refresh.url", "https://login.microsoftonline.com/" + adlsConnector.getDirectoryId() + "/oauth2/token"));
        return sparkOptions;
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    @Transactional(rollbackOn={FeaturestoreException.class})
    public FeaturestoreADLSConnector updateAdlConnector(Users user, FeaturestoreADLSConnectorDTO adlConnectorDTO, FeaturestoreADLSConnector adlConnector) throws FeaturestoreException, ProjectException, UserException {
        this.verifyConnectorDTO(adlConnectorDTO);
        this.secretsController.checkCanAccessSecret(adlConnector.getServiceCredentialSecret(), user);
        adlConnector.setGeneration(adlConnectorDTO.getGeneration().intValue());
        adlConnector.setDirectoryId(adlConnectorDTO.getDirectoryId());
        adlConnector.setApplicationId(adlConnectorDTO.getApplicationId());
        adlConnector.setAccountName(adlConnectorDTO.getAccountName());
        adlConnector.setContainerName(adlConnectorDTO.getContainerName());
        Secret secret = adlConnector.getServiceCredentialSecret();
        try {
            secret.setSecret(this.secretsController.encryptSecret(adlConnectorDTO.getServiceCredential()));
        }
        catch (IOException | GeneralSecurityException e) {
            throw new UserException(RESTCodes.UserErrorCode.SECRET_ENCRYPTION_ERROR, Level.SEVERE, "Error encrypting secret", "Could not encrypt Secret " + secret.getId().getName(), (Throwable)e);
        }
        return adlConnector;
    }

    private void verifyConnectorDTO(FeaturestoreADLSConnectorDTO adlConnectorDTO) throws FeaturestoreException {
        int generation;
        if (adlConnectorDTO.getGeneration() == null) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STORAGE_CONNECTOR_ARG, Level.FINE, "Generation is empty");
        }
        int n = generation = adlConnectorDTO.getGeneration() != null ? adlConnectorDTO.getGeneration() : 2;
        if (generation != 1 && generation != 2) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STORAGE_CONNECTOR_ARG, Level.FINE, "Invalid ADLS generation - Only generation 1 and 2 supported");
        }
        if (Strings.isNullOrEmpty((String)adlConnectorDTO.getDirectoryId())) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STORAGE_CONNECTOR_ARG, Level.FINE, "DirectoryId is empty");
        }
        if (Strings.isNullOrEmpty((String)adlConnectorDTO.getApplicationId())) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STORAGE_CONNECTOR_ARG, Level.FINE, "ApplicationId is empty");
        }
        if (Strings.isNullOrEmpty((String)adlConnectorDTO.getServiceCredential())) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STORAGE_CONNECTOR_ARG, Level.FINE, "ServiceCredentials is empty");
        }
        if (Strings.isNullOrEmpty((String)adlConnectorDTO.getAccountName())) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STORAGE_CONNECTOR_ARG, Level.FINE, "AccountName is empty");
        }
        if (generation == 2 && Strings.isNullOrEmpty((String)adlConnectorDTO.getContainerName())) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STORAGE_CONNECTOR_ARG, Level.FINE, "ContainerName is empty");
        }
    }
}

