/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.jobs.description;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.exceptions.InvalidQueryException;
import io.hops.hopsworks.persistence.entity.jobs.configuration.JobConfiguration;
import io.hops.hopsworks.persistence.entity.jobs.configuration.JobType;
import io.hops.hopsworks.persistence.entity.jobs.configuration.ScheduleDTO;
import io.hops.hopsworks.persistence.entity.jobs.configuration.history.JobState;
import io.hops.hopsworks.persistence.entity.jobs.description.Jobs;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.user.Users;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;

@Stateless
public class JobFacade
extends AbstractFacade<Jobs> {
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;
    private static final Logger LOGGER = Logger.getLogger(JobFacade.class.getName());
    private static final String JPQL_EXECUTIONS = "LEFT JOIN FETCH j.executions e on e.id = (select max(e.id) from Execution e where e.job = j group by e.job) ";

    public JobFacade() {
        super(Jobs.class);
    }

    @Override
    protected EntityManager getEntityManager() {
        return this.em;
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public Jobs put(Users creator, Project project, JobConfiguration config, Jobs job) {
        if (creator == null || project == null || config == null) {
            throw new IllegalArgumentException("Owner, project and config must be non-null.");
        }
        if (job == null) {
            job = new Jobs(config, project, creator, config.getAppName());
        } else {
            job.setJobConfig(config);
        }
        job = (Jobs)this.em.merge((Object)job);
        this.em.flush();
        return job;
    }

    public Jobs findByProjectAndName(Project project, String name) {
        TypedQuery query = this.em.createNamedQuery("Jobs.findByProjectAndName", Jobs.class);
        query.setParameter("name", (Object)name).setParameter("project", (Object)project);
        try {
            return (Jobs)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public Jobs findByProjectAndId(Project project, int id) {
        TypedQuery query = this.em.createNamedQuery("Jobs.findByProjectAndId", Jobs.class);
        query.setParameter("id", (Object)id).setParameter("project", (Object)project);
        try {
            return (Jobs)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void removeJob(Jobs job) {
        try {
            Jobs managedJob = (Jobs)this.em.find(Jobs.class, (Object)job.getId());
            this.em.remove(this.em.merge((Object)managedJob));
            this.em.flush();
        }
        catch (IllegalStateException | SecurityException ex) {
            LOGGER.log(Level.SEVERE, "Could not delete job:" + job.getId());
            throw ex;
        }
    }

    public boolean updateJobSchedule(int jobId, ScheduleDTO schedule) {
        boolean status = false;
        try {
            Jobs managedJob = (Jobs)this.em.find(Jobs.class, (Object)jobId);
            JobConfiguration config = managedJob.getJobConfig();
            config.setSchedule(schedule);
            TypedQuery q = this.em.createNamedQuery("Jobs.updateConfig", Jobs.class);
            q.setParameter("id", (Object)jobId);
            q.setParameter("jobconfig", (Object)config);
            int result = q.executeUpdate();
            LOGGER.log(Level.INFO, "Updated entity count = {0}", result);
            if (result == 1) {
                status = true;
            }
        }
        catch (IllegalArgumentException | SecurityException ex) {
            LOGGER.log(Level.SEVERE, "Could not update job with id:" + jobId);
            throw ex;
        }
        return status;
    }

    public List<Jobs> getRunningJobs(Project project) {
        TypedQuery q = this.em.createNamedQuery("Execution.findJobsForExecutionInState", Jobs.class);
        q.setParameter("project", (Object)project);
        q.setParameter("stateCollection", (Object)JobState.getRunningStates());
        return q.getResultList();
    }

    public List<Jobs> getRunningJobs(Project project, String hdfsUser) {
        TypedQuery q = this.em.createNamedQuery("Execution.findUserJobsForExecutionInState", Jobs.class);
        q.setParameter("project", (Object)project);
        q.setParameter("hdfsUser", (Object)hdfsUser);
        q.setParameter("stateCollection", (Object)JobState.getRunningStates());
        return q.getResultList();
    }

    public List<Jobs> getRunningJobs(Project project, String hdfsUser, List<Integer> jobIds) {
        TypedQuery q = this.em.createNamedQuery("Execution.findUserJobsIdsForExecutionInState", Jobs.class);
        q.setParameter("jobids", jobIds);
        q.setParameter("project", (Object)project);
        q.setParameter("hdfsUser", (Object)hdfsUser);
        q.setParameter("stateCollection", (Object)JobState.getRunningStates());
        return q.getResultList();
    }

    public AbstractFacade.CollectionInfo findByProject(Integer offset, Integer limit, Set<? extends AbstractFacade.FilterBy> filters, Set<? extends AbstractFacade.SortBy> sorts, Project project) {
        String join = "";
        if (sorts != null) {
            for (AbstractFacade.SortBy sortBy : sorts) {
                if (!sortBy.getValue().equals(Sorts.FINALSTATUS.getValue()) && !sortBy.getValue().equals(Sorts.PROGRESS.getValue()) && !sortBy.getValue().equals(Sorts.STATE.getValue()) && !sortBy.getValue().equals(Sorts.SUBMISSIONTIME.getValue()) && !sortBy.getValue().equals(Sorts.DURATION.getValue())) continue;
                join = JPQL_EXECUTIONS;
                break;
            }
        }
        if (filters != null) {
            for (AbstractFacade.FilterBy filterBy : filters) {
                if (!filterBy.getValue().equals(Filters.LATEST_EXECUTION.getValue())) continue;
                join = JPQL_EXECUTIONS;
                break;
            }
        }
        String queryStr = this.buildQuery("SELECT j FROM Jobs j " + join, filters, sorts, "j.project = :project ");
        String string = this.buildQuery("SELECT COUNT(DISTINCT j.id) FROM Jobs j " + join, filters, sorts, "j.project = :project ");
        TypedQuery query = this.em.createQuery(queryStr, Jobs.class).setParameter("project", (Object)project);
        TypedQuery queryCount = this.em.createQuery(string, Jobs.class).setParameter("project", (Object)project);
        this.setFilter(filters, (Query)query);
        this.setFilter(filters, (Query)queryCount);
        this.setOffsetAndLim(offset, limit, (Query)query);
        return new AbstractFacade.CollectionInfo((Long)queryCount.getSingleResult(), query.getResultList());
    }

    private void setFilter(Set<? extends AbstractFacade.FilterBy> filter, Query q) {
        if (filter == null || filter.isEmpty()) {
            return;
        }
        for (AbstractFacade.FilterBy filterBy : filter) {
            this.setFilterQuery(filterBy, q);
        }
    }

    private void setFilterQuery(AbstractFacade.FilterBy filterBy, Query q) {
        switch (Filters.valueOf(filterBy.getValue())) {
            case JOBTYPE: 
            case JOBTYPE_NEQ: {
                HashSet<JobType> jobTypes = new HashSet<JobType>(JobFacade.getJobTypes(filterBy.getField(), filterBy.getParam()));
                q.setParameter(filterBy.getField(), jobTypes);
                break;
            }
            case DATE_CREATED: 
            case DATE_CREATED_GT: 
            case DATE_CREATED_LT: {
                Date date = this.getDate(filterBy.getField(), filterBy.getParam());
                q.setParameter(filterBy.getField(), (Object)date);
                break;
            }
            case NAME: {
                q.setParameter(filterBy.getField(), (Object)filterBy.getParam());
                break;
            }
            case CREATOR: 
            case LATEST_EXECUTION: {
                q.setParameter(filterBy.getField(), (Object)filterBy.getParam());
                q.setParameter("searchUpper", (Object)filterBy.getParam().toUpperCase());
                break;
            }
        }
    }

    public static Set<JobType> getJobTypes(String field, String values) {
        String[] jobTypesArr = values.split(",");
        HashSet<JobType> jobTypes = new HashSet<JobType>();
        for (String jobType : jobTypesArr) {
            try {
                jobTypes.add(JobType.valueOf((String)jobType.trim().toUpperCase()));
            }
            catch (IllegalArgumentException ie) {
                throw new InvalidQueryException("Filter value for " + field + " needs to set a valid " + field + ", but found: " + jobType);
            }
        }
        if (jobTypes.isEmpty()) {
            throw new InvalidQueryException("Filter value for " + field + " needs to set valid job types, but found: " + values);
        }
        return jobTypes;
    }

    public static enum Filters {
        JOBTYPE("JOBTYPE", "j.type IN :types ", "types", JobType.SPARK.toString().toUpperCase() + "," + JobType.PYSPARK.toString().toUpperCase()),
        JOBTYPE_NEQ("JOBTYPE_NEQ", "j.type NOT IN :types_neq ", "types_neq", JobType.FLINK.toString().toUpperCase() + "," + JobType.YARN.toString().toUpperCase() + "," + JobType.ERASURE_CODING.toString().toUpperCase()),
        DATE_CREATED("DATE_CREATED", "j.creationTime = :creationTime ", "creationTime", ""),
        DATE_CREATED_GT("DATE_CREATED_GT", "j.creationTime > :creationTimeFrom ", "creationTimeFrom", ""),
        DATE_CREATED_LT("DATE_CREATED_LT", "j.creationTime < :creationTimeTo ", "creationTimeTo", ""),
        NAME("NAME", "j.name LIKE CONCAT(:name, '%') ", "name", " "),
        CREATOR("CREATOR", "(j.creator.username LIKE CONCAT(:user, '%') OR j.creator.fname LIKE CONCAT(:user, '%') OR j.creator.lname LIKE CONCAT(:user, '%') ", "user", " "),
        LATEST_EXECUTION("LATEST_EXECUTION", "(j.creator.fname LIKE CONCAT(:search, '%') OR j.creator.lname LIKE CONCAT(:search, '%') OR j.name LIKE CONCAT(:search, '%') OR j.type LIKE CONCAT(:searchUpper, '%') OR e.state LIKE CONCAT(:searchUpper, '%') OR e.finalStatus LIKE CONCAT(:searchUpper, '%')) ", "search", " ");

        private final String value;
        private final String sql;
        private final String field;
        private final String defaultParam;

        private Filters(String value, String sql, String field, String defaultParam) {
            this.value = value;
            this.sql = sql;
            this.field = field;
            this.defaultParam = defaultParam;
        }

        public String getValue() {
            return this.value;
        }

        public String getDefaultParam() {
            return this.defaultParam;
        }

        public String getSql() {
            return this.sql;
        }

        public String getField() {
            return this.field;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Sorts {
        ID("ID", "j.id ", "ASC"),
        NAME("NAME", "j.name ", "ASC"),
        DATE_CREATED("DATE_CREATED", "j.creationTime ", "DESC"),
        JOBTYPE("JOBTYPE", "j.type ", "ASC"),
        CREATOR("CREATOR", "LOWER(CONCAT (j.creator.fname, j.creator.lname)) ", "ASC"),
        CREATOR_FIRST_NAME("CREATOR_FIRSTNAME", "j.creator.fname ", "ASC"),
        CREATOR_LAST_NAME("CREATOR_LASTNAME", "j.creator.lname ", "ASC"),
        STATE("STATE", "e.state ", "ASC"),
        FINALSTATUS("FINALSTATUS", "e.finalStatus ", "ASC"),
        PROGRESS("PROGRESS", "e.progress ", "ASC"),
        SUBMISSIONTIME("SUBMISSIONTIME", "e.submissionTime ", "DESC"),
        DURATION("DURATION", " e.executionStop-e.executionStart ", "ASC");

        private final String value;
        private final String sql;
        private final String defaultParam;

        private Sorts(String value, String sql, String defaultParam) {
            this.value = value;
            this.sql = sql;
            this.defaultParam = defaultParam;
        }

        public String getValue() {
            return this.value;
        }

        public String getDefaultParam() {
            return this.defaultParam;
        }

        public String getSql() {
            return this.sql;
        }

        public String toString() {
            return this.value;
        }
    }
}

