/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.alert;

import io.hops.hopsworks.alert.AlertManager;
import io.hops.hopsworks.alert.exception.AlertManagerAccessControlException;
import io.hops.hopsworks.alert.exception.AlertManagerUnreachableException;
import io.hops.hopsworks.alert.util.Constants;
import io.hops.hopsworks.alert.util.PostableAlertBuilder;
import io.hops.hopsworks.alerting.api.alert.dto.Alert;
import io.hops.hopsworks.alerting.api.alert.dto.PostableAlert;
import io.hops.hopsworks.alerting.exceptions.AlertManagerClientCreateException;
import io.hops.hopsworks.alerting.exceptions.AlertManagerResponseException;
import io.hops.hopsworks.common.featurestore.FeaturestoreFacade;
import io.hops.hopsworks.common.featurestore.featuregroup.ExpectationResult;
import io.hops.hopsworks.persistence.entity.alertmanager.AlertSeverity;
import io.hops.hopsworks.persistence.entity.alertmanager.AlertType;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.Featuregroup;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.datavalidation.FeatureGroupValidation;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.datavalidation.alert.FeatureGroupAlert;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.datavalidation.alert.ValidationRuleAlertStatus;
import io.hops.hopsworks.persistence.entity.jobs.configuration.history.JobState;
import io.hops.hopsworks.persistence.entity.jobs.description.JobAlert;
import io.hops.hopsworks.persistence.entity.jobs.description.JobAlertStatus;
import io.hops.hopsworks.persistence.entity.jobs.history.Execution;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.project.alert.ProjectServiceAlert;
import io.hops.hopsworks.persistence.entity.project.alert.ProjectServiceAlertStatus;
import io.hops.hopsworks.persistence.entity.project.service.ProjectServiceEnum;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class AlertController {
    private static final Logger LOGGER = Logger.getLogger(AlertController.class.getName());
    @EJB
    private AlertManager alertManager;
    @EJB
    private FeaturestoreFacade featurestoreFacade;

    public void sendAlert(Featuregroup featuregroup, List<ExpectationResult> results, FeatureGroupValidation.Status status) {
        List<PostableAlert> postableAlerts = this.getPostableAlerts(featuregroup, results, status);
        this.sendFgAlert(postableAlerts, featuregroup.getFeaturestore().getProject(), featuregroup.getName());
    }

    public void sendAlert(JobState newState, Execution execution) {
        List<PostableAlert> postableAlerts = this.getAlerts(newState, execution);
        this.sendJobAlert(postableAlerts, execution.getJob().getProject(), execution.getJob().getName(), execution.getId());
    }

    public List<Alert> testAlert(Project project, FeatureGroupAlert alert) throws AlertManagerUnreachableException, AlertManagerAccessControlException, AlertManagerResponseException, AlertManagerClientCreateException {
        return this.sendFgTestAlert(project, alert.getAlertType(), alert.getSeverity(), FeatureGroupValidation.Status.fromString((String)alert.getStatus().toString()));
    }

    public List<Alert> testAlert(Project project, JobAlert alert) throws AlertManagerUnreachableException, AlertManagerAccessControlException, AlertManagerResponseException, AlertManagerClientCreateException {
        return this.sendJobTestAlert(project, alert.getAlertType(), alert.getSeverity(), alert.getStatus().getName());
    }

    public List<Alert> testAlert(Project project, ProjectServiceAlert alert) throws AlertManagerUnreachableException, AlertManagerAccessControlException, AlertManagerResponseException, AlertManagerClientCreateException {
        List<Alert> alerts = null;
        if (ProjectServiceEnum.FEATURESTORE.equals((Object)alert.getService())) {
            alerts = this.sendFgTestAlert(project, alert.getAlertType(), alert.getSeverity(), FeatureGroupValidation.Status.fromString((String)alert.getStatus().toString()));
        } else if (ProjectServiceEnum.JOBS.equals((Object)alert.getService())) {
            alerts = this.sendJobTestAlert(project, alert.getAlertType(), alert.getSeverity(), alert.getStatus().getName());
        }
        return alerts;
    }

    private void sendAlert(List<PostableAlert> postableAlerts, Project project) throws AlertManagerUnreachableException, AlertManagerAccessControlException, AlertManagerResponseException, AlertManagerClientCreateException {
        if (!postableAlerts.isEmpty()) {
            this.alertManager.postAlerts(postableAlerts, project);
        }
    }

    private void sendFgAlert(List<PostableAlert> postableAlerts, Project project, String name) {
        try {
            this.sendAlert(postableAlerts, project);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to send alert. Featuregroup={0}. Exception: {1}", new Object[]{name, e.getMessage()});
        }
    }

    private void sendJobAlert(List<PostableAlert> postableAlerts, Project project, String name, Integer id) {
        try {
            this.sendAlert(postableAlerts, project);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to send alert. Job={0} executionId={1}. Exception: {2}", new Object[]{name, id, e.getMessage()});
        }
    }

    private List<Alert> sendFgTestAlert(Project project, AlertType alertType, AlertSeverity severity, FeatureGroupValidation.Status status) throws AlertManagerUnreachableException, AlertManagerAccessControlException, AlertManagerResponseException, AlertManagerClientCreateException {
        ArrayList<PostableAlert> postableAlerts = new ArrayList<PostableAlert>();
        PostableAlert postableAlert = this.getPostableAlert(project.getName(), alertType, severity, status.getName(), this.getExpectationResult(status, new ArrayList<ExpectationResult>()), Constants.TEST_ALERT_FG_ID, "AlertTestFeatureStore", "AlertTestFeatureGroup", Constants.TEST_ALERT_FG_VERSION);
        postableAlerts.add(postableAlert);
        this.sendAlert(postableAlerts, project);
        String fgFilter = "featureGroup=\"%%fg%%\"".replace("%%fg%%", "AlertTestFeatureGroup") + "featureGroupId=\"%%fgId%%\"".replace("%%fgId%%", Constants.TEST_ALERT_FG_ID.toString());
        return this.getAlerts(project, fgFilter);
    }

    private List<Alert> sendJobTestAlert(Project project, AlertType alertType, AlertSeverity severity, String status) throws AlertManagerUnreachableException, AlertManagerAccessControlException, AlertManagerResponseException, AlertManagerClientCreateException {
        ArrayList<PostableAlert> postableAlerts = new ArrayList<PostableAlert>();
        PostableAlert postableAlert = this.getPostableAlert(project, alertType, severity, status, "AlertTestJob", Constants.TEST_ALERT_EXECUTION_ID);
        postableAlerts.add(postableAlert);
        this.sendAlert(postableAlerts, project);
        String jobFilter = "job=\"%%job%%\"".replace("%%job%%", "AlertTestJob") + "executionId=\"%%executionId%%\"".replace("%%executionId%%", Constants.TEST_ALERT_EXECUTION_ID.toString());
        return this.getAlerts(project, jobFilter);
    }

    private List<Alert> getAlerts(Project project, String filter) throws AlertManagerUnreachableException, AlertManagerAccessControlException, AlertManagerResponseException, AlertManagerClientCreateException {
        HashSet<String> filters = new HashSet<String>();
        String projectFilter = "project=\"%%project%%\"".replace("%%project%%", project.getName());
        filters.add(projectFilter);
        filters.add(filter);
        List alerts = this.alertManager.getAlerts(Boolean.valueOf(true), null, null, null, filters, null, project);
        return alerts;
    }

    private List<PostableAlert> getPostableAlerts(Featuregroup featuregroup, List<ExpectationResult> results, FeatureGroupValidation.Status status) {
        ArrayList<PostableAlert> postableAlerts;
        block4: {
            block3: {
                postableAlerts = new ArrayList<PostableAlert>();
                if (FeatureGroupValidation.Status.NONE.equals((Object)status)) {
                    return postableAlerts;
                }
                if (featuregroup.getFeatureGroupAlerts() == null || featuregroup.getFeatureGroupAlerts().isEmpty()) break block3;
                for (FeatureGroupAlert alert : featuregroup.getFeatureGroupAlerts()) {
                    if (!alert.getStatus().equals((Object)ValidationRuleAlertStatus.getStatus((FeatureGroupValidation.Status)status))) continue;
                    String name = this.featurestoreFacade.getHiveDbName(featuregroup.getFeaturestore().getHiveDbId());
                    PostableAlert postableAlert = this.getPostableAlert(featuregroup.getFeaturestore().getProject().getName(), alert.getAlertType(), alert.getSeverity(), alert.getStatus().getName(), this.getExpectationResult(status, results), featuregroup.getId(), name, featuregroup.getName(), featuregroup.getVersion());
                    postableAlerts.add(postableAlert);
                }
                break block4;
            }
            if (featuregroup.getFeaturestore().getProject().getProjectServiceAlerts() == null || featuregroup.getFeaturestore().getProject().getProjectServiceAlerts().isEmpty()) break block4;
            for (ProjectServiceAlert alert : featuregroup.getFeaturestore().getProject().getProjectServiceAlerts()) {
                if (!ProjectServiceEnum.FEATURESTORE.equals((Object)alert.getService()) || !alert.getStatus().equals((Object)ProjectServiceAlertStatus.getStatus((FeatureGroupValidation.Status)status))) continue;
                String name = this.featurestoreFacade.getHiveDbName(featuregroup.getFeaturestore().getHiveDbId());
                PostableAlert postableAlert = this.getPostableAlert(featuregroup.getFeaturestore().getProject().getName(), alert.getAlertType(), alert.getSeverity(), alert.getStatus().getName(), this.getExpectationResult(status, results), featuregroup.getId(), name, featuregroup.getName(), featuregroup.getVersion());
                postableAlerts.add(postableAlert);
            }
        }
        return postableAlerts;
    }

    private PostableAlert getPostableAlert(String projectName, AlertType alertType, AlertSeverity severity, String status, String results, Integer id, String featureStoreName, String featureGroupName, int version) {
        return new PostableAlertBuilder.Builder(projectName, alertType, severity, status).withFeatureGroupId(id).withFeatureStoreName(featureStoreName).withFeatureGroupName(featureGroupName).withFeatureGroupVersion(Integer.valueOf(version)).withSummary("Feature group validation " + status.toLowerCase()).withDescription("Feature group name=" + featureGroupName + results).build();
    }

    private String getExpectationResult(FeatureGroupValidation.Status status, List<ExpectationResult> results) {
        if (FeatureGroupValidation.Status.SUCCESS.equals((Object)status)) {
            return " validation succeeded with warning=0, error=0.";
        }
        StringBuilder resultStr = new StringBuilder();
        resultStr.append(" validation ended with ").append(status.getName().toLowerCase()).append(".");
        ArrayList<String> detailedResults = new ArrayList<String>();
        for (ExpectationResult result : results) {
            if (!FeatureGroupValidation.Status.WARNING.equals((Object)result.getStatus()) && !FeatureGroupValidation.Status.FAILURE.equals((Object)result.getStatus())) continue;
            detailedResults.add("[expectation=" + result.getExpectation().getName() + ", status=" + result.getStatus().getName() + "]");
        }
        if (!detailedResults.isEmpty()) {
            resultStr.append(" Detail: ").append(String.join((CharSequence)", ", detailedResults)).append(".");
        }
        return resultStr.toString();
    }

    private PostableAlert getPostableAlert(Project project, AlertType alertType, AlertSeverity severity, String status, String jobName, Integer id) {
        return new PostableAlertBuilder.Builder(project.getName(), alertType, severity, status).withJobName(jobName).withExecutionId(id).withSummary("Job " + status).withDescription("Job=" + jobName + " with executionId=" + id + " " + status.toLowerCase()).build();
    }

    private List<PostableAlert> getAlerts(JobState jobState, Execution execution) {
        ArrayList<PostableAlert> postableAlerts;
        block2: {
            block3: {
                postableAlerts = new ArrayList<PostableAlert>();
                if (!jobState.isFinalState()) break block2;
                if (execution.getJob().getJobAlertCollection() == null || execution.getJob().getJobAlertCollection().isEmpty()) break block3;
                for (JobAlert alert : execution.getJob().getJobAlertCollection()) {
                    if (!alert.getStatus().equals((Object)JobAlertStatus.getJobAlertStatus((JobState)jobState))) continue;
                    PostableAlert postableAlert = this.getPostableAlert(execution.getJob().getProject(), alert.getAlertType(), alert.getSeverity(), alert.getStatus().getName(), execution.getJob().getName(), execution.getId());
                    postableAlerts.add(postableAlert);
                }
                break block2;
            }
            if (execution.getJob().getProject().getProjectServiceAlerts() == null || execution.getJob().getProject().getProjectServiceAlerts().isEmpty()) break block2;
            for (ProjectServiceAlert alert : execution.getJob().getProject().getProjectServiceAlerts()) {
                if (!ProjectServiceEnum.JOBS.equals((Object)alert.getService()) || !alert.getStatus().equals((Object)ProjectServiceAlertStatus.getJobAlertStatus((JobState)jobState))) continue;
                PostableAlert postableAlert = this.getPostableAlert(execution.getJob().getProject(), alert.getAlertType(), alert.getSeverity(), alert.getStatus().getName(), execution.getJob().getName(), execution.getId());
                postableAlerts.add(postableAlert);
            }
        }
        return postableAlerts;
    }
}

