/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.statistics.columns;

import io.hops.hopsworks.common.featurestore.feature.FeatureGroupFeatureDTO;
import io.hops.hopsworks.common.featurestore.feature.TrainingDatasetFeatureDTO;
import io.hops.hopsworks.common.featurestore.featuregroup.FeaturegroupDTO;
import io.hops.hopsworks.common.featurestore.query.Feature;
import io.hops.hopsworks.common.featurestore.query.Query;
import io.hops.hopsworks.common.featurestore.statistics.columns.StatisticColumnFacade;
import io.hops.hopsworks.common.featurestore.trainingdatasets.TrainingDatasetDTO;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.Featuregroup;
import io.hops.hopsworks.persistence.entity.featurestore.statistics.StatisticColumn;
import io.hops.hopsworks.persistence.entity.featurestore.statistics.StatisticsConfig;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.TrainingDataset;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.TrainingDatasetFeature;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.ejb.EJB;
import javax.ejb.Stateless;

@Stateless
public class StatisticColumnController {
    @EJB
    private StatisticColumnFacade statisticColumnFacade;

    public void persistStatisticColumns(Featuregroup featureGroup, List<String> statisticColumns) {
        this.persistStatisticColumns(featureGroup.getStatisticsConfig(), statisticColumns);
    }

    public void persistStatisticColumns(TrainingDataset trainingDataset, List<String> statisticColumns) {
        this.persistStatisticColumns(trainingDataset.getStatisticsConfig(), statisticColumns);
    }

    public void persistStatisticColumns(StatisticsConfig statisticsConfig, List<String> statisticColumns) {
        if (statisticColumns != null) {
            statisticColumns.forEach(statisticColumn -> {
                if (!this.isColumnExists((List)statisticsConfig.getStatisticColumns(), (String)statisticColumn)) {
                    StatisticColumn sc = new StatisticColumn();
                    sc.setStatisticsConfig(statisticsConfig);
                    sc.setName(statisticColumn);
                    this.statisticColumnFacade.persist(sc);
                }
            });
            List columnEntities = (List)statisticsConfig.getStatisticColumns();
            columnEntities.forEach(scEntity -> {
                if (this.isEntityToBeDropped((StatisticColumn)scEntity, statisticColumns)) {
                    this.statisticColumnFacade.remove(scEntity);
                }
            });
        }
    }

    public boolean isColumnExists(List<StatisticColumn> statisticColumns, String column) {
        return statisticColumns.stream().anyMatch(statisticColumn -> statisticColumn.getName().equals(column));
    }

    public boolean isEntityToBeDropped(StatisticColumn entity, List<String> statisticColumns) {
        return statisticColumns.stream().noneMatch(statisticColumn -> statisticColumn.equals(entity.getName()));
    }

    public void verifyStatisticColumnsExist(FeaturegroupDTO featureGroupDTO) throws FeaturestoreException {
        this.verifyStatisticColumnsExist(featureGroupDTO.getStatisticsConfig().getColumns(), featureGroupDTO.getFeatures().stream().map(FeatureGroupFeatureDTO::getName).collect(Collectors.toList()), "feature group " + featureGroupDTO.getName(), featureGroupDTO.getVersion());
    }

    public void verifyStatisticColumnsExist(FeaturegroupDTO featureGroupDTO, Featuregroup dbFeatureGroup, List<FeatureGroupFeatureDTO> dbFeatures) throws FeaturestoreException {
        this.verifyStatisticColumnsExist(featureGroupDTO.getStatisticsConfig().getColumns(), dbFeatures.stream().map(FeatureGroupFeatureDTO::getName).collect(Collectors.toList()), "feature group " + dbFeatureGroup.getName(), dbFeatureGroup.getVersion());
    }

    public void verifyStatisticColumnsExist(TrainingDatasetDTO trainingDatasetDTO, TrainingDataset trainingDataset) throws FeaturestoreException {
        this.verifyStatisticColumnsExist(trainingDatasetDTO.getStatisticsConfig().getColumns(), trainingDataset.getFeatures().stream().map(TrainingDatasetFeature::getName).collect(Collectors.toList()), "training dataset " + trainingDatasetDTO.getName(), trainingDatasetDTO.getVersion());
    }

    public void verifyStatisticColumnsExist(TrainingDatasetDTO trainingDatasetDTO, Query query) throws FeaturestoreException {
        if (query != null) {
            this.verifyStatisticColumnsExist(trainingDatasetDTO.getStatisticsConfig().getColumns(), query.getFeatures().stream().map(Feature::getName).collect(Collectors.toList()), "training dataset " + trainingDatasetDTO.getName(), trainingDatasetDTO.getVersion());
        } else {
            this.verifyStatisticColumnsExist(trainingDatasetDTO.getStatisticsConfig().getColumns(), trainingDatasetDTO.getFeatures().stream().map(TrainingDatasetFeatureDTO::getName).collect(Collectors.toList()), "training dataset " + trainingDatasetDTO.getName(), trainingDatasetDTO.getVersion());
        }
    }

    public void verifyStatisticColumnsExist(List<String> statisticColumns, List<String> featureNames, String entityName, Integer entityVersion) throws FeaturestoreException {
        Optional<String> nonExistingStatColumn;
        if (statisticColumns != null && (nonExistingStatColumn = statisticColumns.stream().filter(statCol -> !featureNames.contains(statCol)).findAny()).isPresent()) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STATISTICS_CONFIG, Level.FINE, "statistic column: " + nonExistingStatColumn.get() + " is not part of " + entityName + " with version " + entityVersion);
        }
    }
}

