/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.serving.inference;

import io.hops.common.Pair;
import io.hops.hopsworks.common.integrations.LocalhostStereotype;
import io.hops.hopsworks.common.serving.inference.InferenceHttpClient;
import io.hops.hopsworks.common.serving.inference.LocalhostSkLearnInferenceUtils;
import io.hops.hopsworks.common.serving.inference.LocalhostTfInferenceUtils;
import io.hops.hopsworks.common.serving.inference.ServingInferenceController;
import io.hops.hopsworks.exceptions.InferenceException;
import io.hops.hopsworks.persistence.entity.serving.ModelServer;
import io.hops.hopsworks.persistence.entity.serving.Serving;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import javax.ejb.ConcurrencyManagement;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.EJB;
import javax.ejb.Singleton;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.protocol.HttpContext;

@LocalhostStereotype
@Singleton
@TransactionAttribute(value=TransactionAttributeType.NEVER)
@ConcurrencyManagement(value=ConcurrencyManagementType.BEAN)
public class LocalhostInferenceController
implements ServingInferenceController {
    @EJB
    private InferenceHttpClient inferenceHttpClient;
    @EJB
    private LocalhostTfInferenceUtils localhostTfInferenceUtils;
    @EJB
    private LocalhostSkLearnInferenceUtils localhostSkLearnInferenceUtils;

    @Override
    public Pair<Integer, String> infer(Serving serving, Integer modelVersion, String verb, String inferenceRequestJson) throws InferenceException {
        String path;
        if (serving.getCid().equals("stopped")) {
            throw new InferenceException(RESTCodes.InferenceErrorCode.SERVING_NOT_RUNNING, Level.FINE);
        }
        if (serving.getModelServer() == ModelServer.TENSORFLOW_SERVING) {
            path = this.localhostTfInferenceUtils.getPath(serving.getName(), modelVersion, verb);
        } else if (serving.getModelServer() == ModelServer.FLASK) {
            path = this.localhostSkLearnInferenceUtils.getPath(verb);
        } else {
            throw new UnsupportedOperationException("Model server not supported as local serving");
        }
        try {
            URI uri = new URIBuilder().setScheme("http").setHost("localhost").setPort(serving.getLocalPort().intValue()).setPath(path).build();
            HttpPost request = new HttpPost(uri);
            request.addHeader("content-type", "application/json; charset=utf-8");
            request.setEntity((HttpEntity)new StringEntity(inferenceRequestJson));
            HttpClientContext context = HttpClientContext.create();
            CloseableHttpResponse response = this.inferenceHttpClient.execute(request, (HttpContext)context);
            return this.inferenceHttpClient.handleInferenceResponse(response);
        }
        catch (URISyntaxException e) {
            throw new InferenceException(RESTCodes.InferenceErrorCode.REQUEST_ERROR, Level.SEVERE, null, e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new InferenceException(RESTCodes.InferenceErrorCode.REQUEST_ERROR, Level.INFO, null, e.getMessage(), (Throwable)e);
        }
    }
}

