/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.statistics;

import io.hops.hopsworks.common.dataset.DatasetController;
import io.hops.hopsworks.common.featurestore.activity.FeaturestoreActivityFacade;
import io.hops.hopsworks.common.featurestore.featuregroup.cached.FeatureGroupCommitController;
import io.hops.hopsworks.common.featurestore.statistics.FeaturestoreStatisticFacade;
import io.hops.hopsworks.common.hdfs.DistributedFileSystemOps;
import io.hops.hopsworks.common.hdfs.DistributedFsService;
import io.hops.hopsworks.common.hdfs.HdfsUsersController;
import io.hops.hopsworks.common.hdfs.inode.InodeController;
import io.hops.hopsworks.common.provenance.core.Provenance;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.DatasetException;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.exceptions.HopsSecurityException;
import io.hops.hopsworks.persistence.entity.dataset.Dataset;
import io.hops.hopsworks.persistence.entity.dataset.DatasetAccessPermission;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.Featuregroup;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.FeaturegroupType;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.cached.FeatureGroupCommit;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.cached.TimeTravelFormat;
import io.hops.hopsworks.persistence.entity.featurestore.statistics.FeaturestoreStatistic;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.TrainingDataset;
import io.hops.hopsworks.persistence.entity.hdfs.inode.Inode;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Optional;
import java.util.logging.Level;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.hadoop.fs.Path;
import org.json.JSONException;
import org.json.JSONObject;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class StatisticsController {
    @EJB
    private InodeController inodeController;
    @EJB
    private DistributedFsService dfs;
    @EJB
    private DatasetController datasetController;
    @EJB
    private HdfsUsersController hdfsUsersController;
    @EJB
    private FeaturestoreStatisticFacade featurestoreStatisticFacade;
    @EJB
    private FeatureGroupCommitController featureGroupCommitCommitController;
    @EJB
    private FeaturestoreActivityFacade fsActivityFacade;

    public String readStatisticsContent(Project project, Users user, FeaturestoreStatistic statistic) throws FeaturestoreException {
        String path = this.inodeController.getPath(statistic.getInode());
        DistributedFileSystemOps udfso = null;
        try {
            udfso = this.dfs.getDfsOps(this.hdfsUsersController.getHdfsUserName(project, user));
            String string = udfso.cat(path);
            this.dfs.closeDfsClient(udfso);
            return string;
        }
        catch (IOException e) {
            try {
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.STATISTICS_READ_ERROR, Level.WARNING, e.getMessage(), e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.dfs.closeDfsClient(udfso);
                throw throwable;
            }
        }
    }

    public FeaturestoreStatistic registerStatistics(Project project, Users user, Long statisticsCommitTimeStamp, Long fgCommitId, String content, Featuregroup featuregroup) throws FeaturestoreException, DatasetException, HopsSecurityException, IOException {
        JSONObject statisticsJson = null;
        try {
            statisticsJson = new JSONObject(content);
        }
        catch (JSONException jex) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ERROR_SAVING_STATISTICS, Level.WARNING, "Not a valid JSON", jex.getMessage(), (Throwable)jex);
        }
        FeatureGroupCommit featureGroupCommit = null;
        if (featuregroup.getFeaturegroupType() == FeaturegroupType.CACHED_FEATURE_GROUP && featuregroup.getCachedFeaturegroup().getTimeTravelFormat() == TimeTravelFormat.HUDI) {
            featureGroupCommit = this.featureGroupCommitCommitController.findCommitByDate(featuregroup, fgCommitId);
            FeaturestoreStatistic statisticsFgCommit = this.featurestoreStatisticFacade.findFGStatisticsByCommitTime(featuregroup, featureGroupCommit.getCommittedOn()).orElse(null);
            statisticsCommitTimeStamp = statisticsFgCommit == null ? featureGroupCommit.getCommittedOn() : statisticsCommitTimeStamp;
        }
        Inode statisticsInode = this.registerStatistics(project, user, statisticsCommitTimeStamp, statisticsJson.toString(), featuregroup.getName(), "FeatureGroups", featuregroup.getVersion());
        Timestamp commitTime = new Timestamp(statisticsCommitTimeStamp);
        FeaturestoreStatistic featurestoreStatistic = new FeaturestoreStatistic((Date)commitTime, statisticsInode, featuregroup);
        if (featuregroup.getFeaturegroupType() == FeaturegroupType.CACHED_FEATURE_GROUP && featuregroup.getCachedFeaturegroup().getTimeTravelFormat() == TimeTravelFormat.HUDI) {
            featurestoreStatistic.setFeatureGroupCommit(featureGroupCommit);
        }
        featurestoreStatistic = this.featurestoreStatisticFacade.update(featurestoreStatistic);
        this.fsActivityFacade.logStatisticsActivity(user, featuregroup, new Date(commitTime.getTime()), featurestoreStatistic);
        return featurestoreStatistic;
    }

    public FeaturestoreStatistic registerStatistics(Project project, Users user, Long commitTimeStamp, String content, TrainingDataset trainingDataset) throws FeaturestoreException, DatasetException, HopsSecurityException, IOException {
        JSONObject statisticsJson = null;
        try {
            statisticsJson = new JSONObject(content);
        }
        catch (JSONException jex) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ERROR_SAVING_STATISTICS, Level.WARNING, "Not a valid JSON", jex.getMessage(), (Throwable)jex);
        }
        Inode statisticsInode = this.registerStatistics(project, user, commitTimeStamp, statisticsJson.toString(), trainingDataset.getName(), "TrainingDatasets", trainingDataset.getVersion());
        Timestamp commitTime = new Timestamp(commitTimeStamp);
        FeaturestoreStatistic featurestoreStatistic = new FeaturestoreStatistic((Date)commitTime, statisticsInode, trainingDataset);
        featurestoreStatistic = this.featurestoreStatisticFacade.update(featurestoreStatistic);
        this.fsActivityFacade.logStatisticsActivity(user, trainingDataset, new Date(commitTime.getTime()), featurestoreStatistic);
        return featurestoreStatistic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Inode registerStatistics(Project project, Users user, Long commitTime, String content, String entityName, String entitySubDir, Integer version) throws DatasetException, HopsSecurityException, IOException {
        DistributedFileSystemOps udfso = null;
        try {
            Path dirPath;
            udfso = this.dfs.getDfsOps(this.hdfsUsersController.getHdfsUserName(project, user));
            String dirName = entityName + "_" + version;
            Dataset statistics = this.getOrCreateStatisticsDataset(project, user);
            Path subDir = new Path(this.datasetController.getDatasetPath(statistics), entitySubDir);
            if (!udfso.isDir(subDir.toString())) {
                udfso.mkdir(subDir.toString());
            }
            if (!udfso.isDir((dirPath = new Path(subDir, dirName)).toString())) {
                udfso.mkdir(dirPath.toString());
            }
            Path filePath = new Path(dirPath, commitTime + ".json");
            udfso.create(filePath, content);
            Inode inode = this.inodeController.getInodeAtPath(filePath.toString());
            this.dfs.closeDfsClient(udfso);
            return inode;
        }
        catch (Throwable throwable) {
            this.dfs.closeDfsClient(udfso);
            throw throwable;
        }
    }

    public void deleteStatistics(Project project, Users user, Featuregroup featuregroup) throws FeaturestoreException {
        this.deleteStatistics(project, user, featuregroup.getName(), "FeatureGroups", featuregroup.getVersion());
    }

    public void deleteStatistics(Project project, Users user, TrainingDataset trainingDataset) throws FeaturestoreException {
        this.deleteStatistics(project, user, trainingDataset.getName(), "TrainingDatasets", trainingDataset.getVersion());
    }

    private void deleteStatistics(Project project, Users user, String entityName, String entitySubDir, Integer version) throws FeaturestoreException {
        DistributedFileSystemOps udfso = null;
        try {
            udfso = this.dfs.getDfsOps(this.hdfsUsersController.getHdfsUserName(project, user));
            String dirName = entityName + "_" + version;
            Dataset statistics = this.getOrCreateStatisticsDataset(project, user);
            Path subDir = new Path(this.datasetController.getDatasetPath(statistics), entitySubDir);
            Path dirPath = new Path(subDir, dirName);
            udfso.rm(dirPath, true);
            this.dfs.closeDfsClient(udfso);
        }
        catch (DatasetException | HopsSecurityException | IOException e) {
            try {
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ERROR_DELETING_STATISTICS, Level.WARNING, "", e.getMessage(), e);
            }
            catch (Throwable throwable) {
                this.dfs.closeDfsClient(udfso);
                throw throwable;
            }
        }
    }

    private Dataset getOrCreateStatisticsDataset(Project project, Users user) throws DatasetException, HopsSecurityException {
        Optional<Dataset> statsDataset = project.getDatasetCollection().stream().filter(d -> d.getName().equals(Settings.ServiceDataset.STATISTICS.getName())).findFirst();
        if (statsDataset.isPresent()) {
            return statsDataset.get();
        }
        return this.createStatisticsDataset(project, user);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dataset createStatisticsDataset(Project project, Users user) throws DatasetException, HopsSecurityException {
        DistributedFileSystemOps dfso = null;
        try {
            dfso = this.dfs.getDfsOps();
            Dataset dataset = this.datasetController.createDataset(user, project, Settings.ServiceDataset.STATISTICS.getName(), Settings.ServiceDataset.STATISTICS.getDescription(), Provenance.Type.DISABLED.dto, false, DatasetAccessPermission.EDITABLE, dfso);
            return dataset;
        }
        finally {
            this.dfs.closeDfsClient(dfso);
        }
    }
}

