/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.provenance.core;

import io.hops.hopsworks.common.provenance.core.Provenance;
import io.hops.hopsworks.common.provenance.core.elastic.ElasticHelper;
import io.hops.hopsworks.common.provenance.util.functional.CheckedFunction;
import io.hops.hopsworks.exceptions.ProvenanceException;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.logging.Level;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.javatuples.Pair;

public class ProvParser {
    public static FilterVal filterValInstance(FilterType filterType) {
        FilterVal filterVal = filterType == FilterType.RANGE_GT || filterType == FilterType.RANGE_GTE || filterType == FilterType.RANGE_LT || filterType == FilterType.RANGE_LTE ? new FilterValRange() : new FilterValInList();
        return filterVal;
    }

    public static SortOrder extractSortOrder(String val) throws ProvenanceException {
        try {
            return SortOrder.valueOf((String)val.toUpperCase());
        }
        catch (IllegalArgumentException | NullPointerException e) {
            throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.BAD_REQUEST, Level.INFO, "sort order " + val + " not supported - supported order:" + EnumSet.allOf(SortOrder.class), "exception extracting FilterBy param", (Throwable)e);
        }
    }

    public static Pair<String, String> extractXAttrParam(String param) throws ProvenanceException {
        String[] xattrParts = param.split(":");
        if (xattrParts.length != 2 || xattrParts[0].isEmpty()) {
            throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.BAD_REQUEST, Level.INFO, "malformed xattr:" + param);
        }
        return Pair.with((Object)ProvParser.processXAttrKey(xattrParts[0]), (Object)xattrParts[1]);
    }

    public static String processXAttrKey(String key) {
        String[] keyParts = key.split("\\.");
        StringJoiner keyj = new StringJoiner(".");
        keyj.add("xattr_prov").add(keyParts[0]).add("value");
        for (int i = 1; i < keyParts.length; ++i) {
            keyj.add(keyParts[i]);
        }
        return keyj.toString();
    }

    public static void addToFilters(Map<Field, FilterVal> filters, Pair<Field, Object> fieldVal) throws ProvenanceException {
        ProvParser.addToFilters(filters, (Field)fieldVal.getValue0(), fieldVal.getValue1());
    }

    public static void addToFilters(Map<Field, FilterVal> filters, Field field, Object val) throws ProvenanceException {
        FilterVal fieldFilters = filters.get(field);
        if (fieldFilters == null) {
            fieldFilters = ProvParser.filterValInstance(field.filterType());
            filters.put(field, fieldFilters);
        }
        if (val instanceof Collection) {
            for (Object v : (Collection)val) {
                fieldFilters.add((Pair<Field, Object>)Pair.with((Object)field, v));
            }
        } else {
            fieldFilters.add((Pair<Field, Object>)Pair.with((Object)field, (Object)val));
        }
    }

    public static void withExpansions(Set<ElasticExpansions> expansions, Set<String> params) throws ProvenanceException {
        for (String param : params) {
            try {
                expansions.add(ElasticExpansions.valueOf(param));
            }
            catch (IllegalArgumentException | NullPointerException e) {
                throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.BAD_REQUEST, Level.INFO, "param " + param + " not supported - supported params:" + EnumSet.allOf(ElasticExpansions.class), "exception extracting FilterBy param", (Throwable)e);
            }
        }
    }

    public static enum ElasticExpansions {
        APP("APP");

        public final String queryParamName;

        private ElasticExpansions(String queryParamName) {
            this.queryParamName = queryParamName;
        }

        public String toString() {
            return this.queryParamName;
        }
    }

    public static class MLTypeValParser
    implements ValParser<Provenance.MLType> {
        @Override
        public Provenance.MLType apply(Object o) throws ProvenanceException {
            try {
                if (o instanceof String) {
                    return Provenance.MLType.valueOf((String)o);
                }
                String msg = "expected string-ified version of MLType found " + o.getClass();
                throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.BAD_REQUEST, Level.INFO, msg);
            }
            catch (IllegalArgumentException | NullPointerException e) {
                String msg = "expected string-ified version of MLType found " + o.getClass();
                throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.BAD_REQUEST, Level.INFO, msg, msg, (Throwable)e);
            }
        }
    }

    public static class LongValParser
    implements ValParser<Long> {
        @Override
        public Long apply(Object o) throws ProvenanceException {
            try {
                if (o instanceof String) {
                    return Long.valueOf((String)o);
                }
                if (o instanceof Number) {
                    return ((Number)o).longValue();
                }
                String msg = "expected long - found " + o.getClass();
                throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.BAD_REQUEST, Level.INFO, msg);
            }
            catch (NumberFormatException e) {
                String msg = "expected long - found " + o.getClass();
                throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.BAD_REQUEST, Level.INFO, msg, msg, (Throwable)e);
            }
        }
    }

    public static class StringValParser
    implements ValParser<String> {
        @Override
        public String apply(Object o) throws ProvenanceException {
            if (o instanceof String) {
                return (String)o;
            }
            String msg = "expected string - found " + o.getClass();
            throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.BAD_REQUEST, Level.INFO, msg);
        }
    }

    public static class IntValParser
    implements ValParser<Integer> {
        @Override
        public Integer apply(Object o) throws ProvenanceException {
            try {
                if (o instanceof String) {
                    return Integer.valueOf((String)o);
                }
                if (o instanceof Number) {
                    return ((Number)o).intValue();
                }
                String msg = "expected int - found " + o.getClass();
                throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.BAD_REQUEST, Level.INFO, msg);
            }
            catch (NumberFormatException e) {
                String msg = "expected int - found " + o.getClass();
                throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.BAD_REQUEST, Level.INFO, msg, msg, (Throwable)e);
            }
        }
    }

    public static class FilterValRange
    implements FilterVal {
        String elasticFieldName;
        Pair<Field, Object> lower = null;
        Pair<Field, Object> upper = null;

        @Override
        public void add(Pair<Field, Object> filter) throws ProvenanceException {
            this.elasticFieldName = ((Field)filter.getValue0()).elasticFieldName();
            if (this.lower == null && (((Field)filter.getValue0()).filterType() == FilterType.RANGE_GT || ((Field)filter.getValue0()).filterType() == FilterType.RANGE_GTE)) {
                this.lower = filter;
            } else if (this.upper == null && (((Field)filter.getValue0()).filterType() == FilterType.RANGE_LT || ((Field)filter.getValue0()).filterType() == FilterType.RANGE_LTE)) {
                this.upper = filter;
            } else {
                throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.BAD_REQUEST, Level.INFO, "cannot combine range and not range filters on the same field or more than one lower or upper");
            }
        }

        @Override
        public QueryBuilder query() {
            RangeQueryBuilder fieldQuery = QueryBuilders.rangeQuery((String)this.elasticFieldName);
            if (this.upper != null) {
                switch (((Field)this.upper.getValue0()).filterType()) {
                    case RANGE_LT: {
                        fieldQuery.lt(this.upper.getValue1());
                        break;
                    }
                    case RANGE_LTE: {
                        fieldQuery.lte(this.upper.getValue1());
                        break;
                    }
                }
            }
            if (this.lower != null) {
                switch (((Field)this.lower.getValue0()).filterType()) {
                    case RANGE_GT: {
                        fieldQuery.gt(this.lower.getValue1());
                        break;
                    }
                    case RANGE_GTE: {
                        fieldQuery.gte(this.lower.getValue1());
                        break;
                    }
                }
            }
            return fieldQuery;
        }
    }

    public static class FilterValInList
    implements FilterVal {
        List<Pair<Field, Object>> inList = new LinkedList<Pair<Field, Object>>();

        @Override
        public void add(Pair<Field, Object> filter) throws ProvenanceException {
            if (((Field)filter.getValue0()).filterType() == FilterType.RANGE_GT || ((Field)filter.getValue0()).filterType() == FilterType.RANGE_GTE || ((Field)filter.getValue0()).filterType() == FilterType.RANGE_LT || ((Field)filter.getValue0()).filterType() == FilterType.RANGE_LTE) {
                throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.UNSUPPORTED, Level.INFO, "cannot combine range and not range filters on the same field");
            }
            this.inList.add(filter);
        }

        @Override
        public QueryBuilder query() throws ProvenanceException {
            BoolQueryBuilder fieldQuery = QueryBuilders.boolQuery();
            block5: for (Pair<Field, Object> fieldFilter : this.inList) {
                switch (((Field)fieldFilter.getValue0()).filterType()) {
                    case EXACT: {
                        String sVal = fieldFilter.getValue1().toString();
                        fieldQuery.should((QueryBuilder)QueryBuilders.termQuery((String)((Field)fieldFilter.getValue0()).elasticFieldName(), (String)sVal));
                        continue block5;
                    }
                    case NOT: {
                        String sVal = fieldFilter.getValue1().toString();
                        fieldQuery.mustNot((QueryBuilder)QueryBuilders.termQuery((String)((Field)fieldFilter.getValue0()).elasticFieldName(), (String)sVal));
                        continue block5;
                    }
                    case LIKE: {
                        String sVal;
                        if (fieldFilter.getValue1() instanceof String) {
                            sVal = fieldFilter.getValue1().toString();
                            fieldQuery.should(ElasticHelper.fullTextSearch(((Field)fieldFilter.getValue0()).elasticFieldName(), sVal));
                            continue block5;
                        }
                        throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.BAD_REQUEST, Level.INFO, "like queries only work on string values");
                    }
                }
                throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.BAD_REQUEST, Level.INFO, "in list filters do not allow: " + (Object)((Object)((Field)fieldFilter.getValue0()).filterType()));
            }
            return fieldQuery;
        }
    }

    public static interface FilterVal {
        public void add(Pair<Field, Object> var1) throws ProvenanceException;

        public QueryBuilder query() throws ProvenanceException;
    }

    public static enum FilterType {
        EXACT,
        NOT,
        LIKE,
        RANGE_LT,
        RANGE_LTE,
        RANGE_GT,
        RANGE_GTE;

    }

    public static interface Field {
        public String elasticFieldName();

        public String queryFieldName();

        public FilterType filterType();

        public ValParser<?> filterValParser();
    }

    public static interface ValParser<V>
    extends CheckedFunction<Object, V, ProvenanceException> {
    }

    public static enum EntryType {
        STATE,
        OPERATION,
        ARCHIVE;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    public static enum DocSubType {
        FEATURE,
        TRAINING_DATASET,
        EXPERIMENT,
        MODEL,
        HIVE,
        DATASET,
        NONE,
        FEATURE_PART,
        TRAINING_DATASET_PART,
        EXPERIMENT_PART,
        MODEL_PART,
        HIVE_PART,
        DATASET_PART;


        public String toString() {
            return this.name().toUpperCase();
        }

        public DocSubType getPart() {
            switch (this) {
                case FEATURE: {
                    return FEATURE_PART;
                }
                case TRAINING_DATASET: {
                    return TRAINING_DATASET_PART;
                }
                case MODEL: {
                    return MODEL_PART;
                }
                case EXPERIMENT: {
                    return EXPERIMENT_PART;
                }
                case DATASET: {
                    return DATASET_PART;
                }
                case HIVE: {
                    return HIVE_PART;
                }
            }
            return this;
        }

        public DocSubType upgradeIfPart() {
            switch (this) {
                case FEATURE_PART: {
                    return FEATURE;
                }
                case TRAINING_DATASET_PART: {
                    return TRAINING_DATASET;
                }
                case MODEL_PART: {
                    return MODEL;
                }
                case EXPERIMENT_PART: {
                    return EXPERIMENT;
                }
                case DATASET_PART: {
                    return DATASET;
                }
                case HIVE_PART: {
                    return HIVE;
                }
            }
            return this;
        }
    }

    public static enum XAttrField implements ElasticField
    {
        XATTR_PROV;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    public static enum AuxField implements ElasticField
    {
        PARTITION_ID,
        PROJECT_NAME;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    public static enum Fields implements ElasticField
    {
        PROJECT_I_ID,
        DATASET_I_ID,
        PARENT_I_ID,
        INODE_ID,
        INODE_NAME,
        USER_ID,
        APP_ID,
        ML_TYPE,
        ML_ID,
        ENTRY_TYPE;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    public static interface ElasticField {
    }
}

