/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.api;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.hops.hopsworks.common.api.ResourceRequest;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement
public abstract class RestDTO<D> {
    private URI href;
    protected Boolean expand;
    protected List<D> items;
    protected Long count = null;

    public RestDTO(URI href) {
        this.href = href;
    }

    public RestDTO(URI href, ResourceRequest resourceRequest) {
        this.href = href;
        if (resourceRequest != null) {
            this.expand = true;
        }
    }

    public RestDTO() {
    }

    public URI getHref() {
        return this.href;
    }

    public void setHref(URI href) {
        this.href = href;
    }

    @XmlTransient
    @JsonIgnore
    public Boolean isExpand() {
        return this.expand != null ? this.expand : false;
    }

    public void setExpand(Boolean expand) {
        this.expand = expand;
    }

    public List<D> getItems() {
        return this.items;
    }

    public void setItems(List<D> items) {
        this.items = items;
    }

    public void addItems(List<D> items) {
        if (this.items == null) {
            this.items = new ArrayList<D>();
        }
        this.items.addAll(items);
    }

    public void addItem(D item) {
        if (this.items == null) {
            this.items = new ArrayList<D>();
        }
        this.items.add(item);
    }

    public Long getCount() {
        return this.count;
    }

    public void setCount(Long count) {
        this.count = count;
    }
}

