/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.elastic;

import io.hops.hopsworks.exceptions.ElasticException;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.Comparator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.annotation.XmlRootElement;
import org.elasticsearch.search.SearchHit;

@XmlRootElement
public class ElasticFeaturestoreHit
implements Comparator<ElasticFeaturestoreHit> {
    private static final Logger LOG = Logger.getLogger(ElasticFeaturestoreHit.class.getName());
    private String id;
    private float score;
    private String docType;
    private String name;
    private Integer version;
    private Integer projectId;
    private String projectName;
    private Long datasetIId;
    private Map<String, Object> xattrs;

    public static ElasticFeaturestoreHit instance(SearchHit hit) throws ElasticException {
        ElasticFeaturestoreHit feHit = new ElasticFeaturestoreHit();
        feHit.id = hit.getId();
        feHit.score = hit.getScore();
        try {
            for (Map.Entry entry : hit.getSourceAsMap().entrySet()) {
                if (((String)entry.getKey()).equals("doc_type")) {
                    feHit.docType = entry.getValue().toString();
                    continue;
                }
                if (((String)entry.getKey()).equals("name")) {
                    feHit.name = entry.getValue().toString();
                    continue;
                }
                if (((String)entry.getKey()).equals("version")) {
                    feHit.version = Integer.parseInt(entry.getValue().toString());
                    continue;
                }
                if (((String)entry.getKey()).equals("project_id")) {
                    feHit.projectId = Integer.parseInt(entry.getValue().toString());
                    continue;
                }
                if (((String)entry.getKey()).equals("project_name")) {
                    feHit.projectName = entry.getValue().toString();
                    continue;
                }
                if (((String)entry.getKey()).equals("dataset_iid")) {
                    feHit.datasetIId = Long.parseLong(entry.getValue().toString());
                    continue;
                }
                if (!((String)entry.getKey()).equals("xattr")) continue;
                feHit.xattrs = (Map)entry.getValue();
            }
        }
        catch (NumberFormatException e) {
            String userMsg = "Internal error during query";
            String devMsg = "Hopsworks and Elastic types do not match - parsing problem";
            throw new ElasticException(RESTCodes.ElasticErrorCode.ELASTIC_INTERNAL_REQ_ERROR, Level.WARNING, userMsg, devMsg, (Throwable)e);
        }
        return feHit;
    }

    @Override
    public int compare(ElasticFeaturestoreHit o1, ElasticFeaturestoreHit o2) {
        return Float.compare(o2.getScore(), o1.getScore());
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public float getScore() {
        return this.score;
    }

    public void setScore(float score) {
        this.score = score;
    }

    public String getDocType() {
        return this.docType;
    }

    public void setDocType(String docType) {
        this.docType = docType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public Integer getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Integer projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Long getDatasetIId() {
        return this.datasetIId;
    }

    public void setDatasetIId(Long datasetIId) {
        this.datasetIId = datasetIId;
    }

    public Map<String, Object> getXattrs() {
        return this.xattrs;
    }

    public void setXattrs(Map<String, Object> xattrs) {
        this.xattrs = xattrs;
    }

    public String toString() {
        return "FeaturestoreElasticHit{id='" + this.id + '\'' + ", score=" + this.score + ", docType='" + this.docType + '\'' + ", name='" + this.name + '\'' + ", version=" + this.version + ", projectId=" + this.projectId + ", projectName='" + this.projectName + '\'' + ", datasetIId=" + this.datasetIId + ", features=" + this.xattrs + '}';
    }
}

