/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.security;

import java.nio.charset.Charset;

public class SymmetricEncryptionDescriptor {
    private final byte[] input;
    private char[] password;
    private final byte[] salt;
    private final byte[] iv;
    private final byte[] output;

    private SymmetricEncryptionDescriptor(Builder builder) {
        this.input = builder.input;
        this.password = builder.password;
        this.salt = builder.salt;
        this.iv = builder.iv;
        this.output = builder.output;
    }

    public byte[] getInput() {
        return this.input;
    }

    public char[] getPassword() {
        return this.password;
    }

    public byte[] getSalt() {
        return this.salt;
    }

    public byte[] getIv() {
        return this.iv;
    }

    public byte[] getOutput() {
        return this.output;
    }

    public void clearPassword() {
        if (this.password != null) {
            for (int i = 0; i < this.password.length; ++i) {
                this.password[i] = 32;
            }
            this.password = null;
        }
    }

    public static class Builder {
        private byte[] input;
        private char[] password;
        private byte[] salt;
        private byte[] iv;
        private byte[] output;

        public Builder setInput(byte[] input) {
            this.input = input;
            return this;
        }

        public Builder setInput(String input) {
            this.input = input.getBytes(Charset.defaultCharset());
            return this;
        }

        public Builder setPassword(char[] password) {
            this.password = password;
            return this;
        }

        public Builder setPassword(String password) {
            this.password = password.toCharArray();
            return this;
        }

        public Builder setSalt(byte[] salt) {
            this.salt = salt;
            return this;
        }

        public Builder setIV(byte[] iv) {
            this.iv = iv;
            return this;
        }

        public Builder setOutput(byte[] output) {
            this.output = output;
            return this;
        }

        public SymmetricEncryptionDescriptor build() {
            return new SymmetricEncryptionDescriptor(this);
        }
    }
}

