/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.python.updates;

import com.google.common.base.Strings;
import io.hops.hopsworks.common.python.library.LibraryController;
import io.hops.hopsworks.common.python.library.LibraryVersionDTO;
import io.hops.hopsworks.common.python.updates.analyzer.HopsLatestVersionAnalyzer;
import io.hops.hopsworks.common.python.updates.analyzer.HsfsLatestVersionAnalyzer;
import io.hops.hopsworks.common.python.updates.analyzer.LatestVersionAnalyzer;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.ServiceException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.DependsOn;
import javax.ejb.EJB;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.Timeout;
import javax.ejb.Timer;
import javax.ejb.TimerConfig;
import javax.ejb.TimerService;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

@Singleton
@Startup
@DependsOn(value={"Settings"})
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class PythonLibraryUpdatesMonitor {
    @EJB
    private Settings settings;
    @Resource
    private TimerService timerService;
    @EJB
    private LibraryController libraryController;
    private final Map<String, LatestVersionAnalyzer> latestVersionAnalyzerMap = new ConcurrentHashMap<String, LatestVersionAnalyzer>();
    private String hopsworksVersion;
    private static final Logger LOGGER = Logger.getLogger(PythonLibraryUpdatesMonitor.class.getName());

    @PostConstruct
    public void init() {
        String hopsworksVersion = this.settings.getHopsworksVersion();
        if (hopsworksVersion.contains("-SNAPSHOT")) {
            LOGGER.log(Level.SEVERE, "Python Library Updates monitor is disabled for snapshot versions, not scheduling timer");
            return;
        }
        this.hopsworksVersion = hopsworksVersion;
        HopsLatestVersionAnalyzer hopsAnalyzer = new HopsLatestVersionAnalyzer();
        this.latestVersionAnalyzerMap.put(hopsAnalyzer.getLibrary(), hopsAnalyzer);
        HsfsLatestVersionAnalyzer hsfsAnalyzer = new HsfsLatestVersionAnalyzer();
        this.latestVersionAnalyzerMap.put(hsfsAnalyzer.getLibrary(), hsfsAnalyzer);
        String rawInterval = this.settings.getPythonLibraryUpdatesMonitorInterval();
        Long intervalValue = this.settings.getConfTimeValue(rawInterval);
        TimeUnit intervalTimeunit = this.settings.getConfTimeTimeUnit(rawInterval);
        this.timerService.createIntervalTimer(600000L, intervalTimeunit.toMillis(intervalValue), new TimerConfig((Serializable)((Object)"Python Library Updates Monitor"), false));
    }

    @Timeout
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void execute(Timer timer) throws ServiceException {
        LOGGER.log(Level.INFO, "Running Python Library Updates Monitor");
        if (!this.libraryController.isPyPiIndexed()) {
            LOGGER.log(Level.WARNING, "PyPi search not indexed, skipping timer for now");
            return;
        }
        for (String library : this.latestVersionAnalyzerMap.keySet()) {
            HashMap<String, List<LibraryVersionDTO>> versions = this.libraryController.pipSearch(library);
            this.latestVersionAnalyzerMap.get(library).setLatestVersion(this.hopsworksVersion, versions);
        }
    }

    public String getLatestVersion(String libraryName) {
        String latestVersion = this.latestVersionAnalyzerMap.get(libraryName).getLatestVersion();
        if (!Strings.isNullOrEmpty((String)latestVersion)) {
            return latestVersion;
        }
        return "Latest version for this library is not available right now.";
    }

    public Set<String> getMonitoredLibraries() {
        return this.latestVersionAnalyzerMap.keySet();
    }
}

