/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.user;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.common.dao.user.BbcGroupFacade;
import io.hops.hopsworks.exceptions.InvalidQueryException;
import io.hops.hopsworks.persistence.entity.user.BbcGroup;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.persistence.entity.user.security.UserGroup;
import io.hops.hopsworks.persistence.entity.user.security.UserGroupPK;
import io.hops.hopsworks.persistence.entity.user.security.ua.UserAccountStatus;
import io.hops.hopsworks.persistence.entity.user.security.ua.UserAccountType;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;

@Stateless
public class UserFacade
extends AbstractFacade<Users> {
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;
    @EJB
    private BbcGroupFacade groupFacade;

    @Override
    protected EntityManager getEntityManager() {
        return this.em;
    }

    public UserFacade() {
        super(Users.class);
    }

    @Override
    public List<Users> findAll() {
        TypedQuery query = this.em.createNamedQuery("Users.findAll", Users.class);
        return query.getResultList();
    }

    public AbstractFacade.CollectionInfo findAll(Integer offset, Integer limit, Set<? extends AbstractFacade.FilterBy> filter, Set<? extends AbstractFacade.SortBy> sort) {
        String queryStr = this.buildQuery("SELECT DISTINCT u FROM Users u ", filter, sort, "");
        String queryCountStr = this.buildQuery("SELECT COUNT(DISTINCT u.uid) FROM Users u ", filter, sort, "");
        TypedQuery query = this.em.createQuery(queryStr, Users.class);
        TypedQuery queryCount = this.em.createQuery(queryCountStr, Users.class);
        this.setFilter(filter, (Query)query);
        this.setFilter(filter, (Query)queryCount);
        this.setOffsetAndLim(offset, limit, (Query)query);
        return new AbstractFacade.CollectionInfo((Long)queryCount.getSingleResult(), query.getResultList());
    }

    public long countWithFilter(Set<? extends AbstractFacade.FilterBy> filter) {
        String queryCountStr = this.buildQuery("SELECT COUNT(DISTINCT u.uid) FROM Users u ", filter, null, "");
        TypedQuery queryCount = this.em.createQuery(queryCountStr, Users.class);
        this.setFilter(filter, (Query)queryCount);
        return (Long)queryCount.getSingleResult();
    }

    private List<BbcGroup> getGroups(String field, String values) {
        String[] groups = values.split(",");
        ArrayList<BbcGroup> roles = new ArrayList<BbcGroup>();
        for (String group : groups) {
            BbcGroup role = this.groupFacade.findByGroupName(group.trim());
            if (role == null) continue;
            roles.add(role);
        }
        if (roles.isEmpty()) {
            throw new InvalidQueryException("Filter value for " + field + " needs to set valid roles, but found: " + values);
        }
        return roles;
    }

    private UserAccountType getTypeValue(String field, String value) {
        UserAccountType val;
        if (value == null || value.isEmpty()) {
            throw new InvalidQueryException("Filter value for " + field + " needs to set an Integer or a valid " + field + ", but found: " + value);
        }
        try {
            int v = Integer.parseInt(value);
            val = UserAccountType.fromValue((int)v);
        }
        catch (IllegalArgumentException e) {
            try {
                val = UserAccountType.valueOf((String)value);
            }
            catch (IllegalArgumentException ie) {
                throw new InvalidQueryException("Filter value for " + field + " needs to set an Integer or a valid " + field + ", but found: " + value);
            }
        }
        return val;
    }

    private UserAccountStatus getStatusValue(String field, String value) {
        UserAccountStatus val;
        if (value == null || value.isEmpty()) {
            throw new InvalidQueryException("Filter value for " + field + " needs to set an Integer or a valid " + field + ", but found: " + value);
        }
        try {
            int v = Integer.parseInt(value);
            val = UserAccountStatus.fromValue((int)v);
        }
        catch (IllegalArgumentException e) {
            try {
                val = UserAccountStatus.valueOf((String)value);
            }
            catch (IllegalArgumentException ie) {
                throw new InvalidQueryException("Filter value for " + field + " needs to set an Integer or a valid " + field + ", but found: " + value);
            }
        }
        return val;
    }

    private void setFilter(Set<? extends AbstractFacade.FilterBy> filter, Query q) {
        if (filter == null || filter.isEmpty()) {
            return;
        }
        for (AbstractFacade.FilterBy filterBy : filter) {
            this.setFilterQuery(filterBy, q);
        }
    }

    private void setFilterQuery(AbstractFacade.FilterBy filterBy, Query q) {
        switch (Filters.valueOf(filterBy.getValue())) {
            case ROLE: 
            case ROLE_NEQ: {
                List<BbcGroup> roles = this.getGroups(filterBy.getField(), filterBy.getParam());
                q.setParameter(filterBy.getField(), roles);
                break;
            }
            case TYPE: {
                q.setParameter(filterBy.getField(), (Object)this.getTypeValue(filterBy.getField(), filterBy.getParam()));
                break;
            }
            case STATUS: 
            case STATUS_GT: 
            case STATUS_LT: {
                q.setParameter(filterBy.getField(), (Object)this.getStatusValue(filterBy.getField(), filterBy.getParam()));
                break;
            }
            case IS_ONLINE: 
            case FALSE_LOGIN: 
            case FALSE_LOGIN_GT: 
            case FALSE_LOGIN_LT: {
                q.setParameter(filterBy.getField(), (Object)this.getIntValue(filterBy.getField(), filterBy.getParam()));
                break;
            }
            case USER_NAME: 
            case USER_FIRST_NAME: 
            case USER_LAST_NAME: 
            case USER_EMAIL: 
            case USER_LIKE: {
                q.setParameter(filterBy.getField(), (Object)filterBy.getParam());
                break;
            }
        }
    }

    public List findAllUsers() {
        Query query = this.em.createNativeQuery("SELECT * FROM hopsworks.users", Users.class);
        return query.getResultList();
    }

    public List<Users> findAllMobileRequests() {
        TypedQuery query = this.em.createNamedQuery("Users.findByStatusAndMode", Users.class);
        query.setParameter("status", (Object)UserAccountStatus.VERIFIED_ACCOUNT);
        query.setParameter("mode", (Object)UserAccountType.M_ACCOUNT_TYPE);
        List res = query.getResultList();
        query = this.em.createNamedQuery("Users.findByStatusAndMode", Users.class);
        query.setParameter("status", (Object)UserAccountStatus.NEW_MOBILE_ACCOUNT);
        query.setParameter("mode", (Object)UserAccountType.M_ACCOUNT_TYPE);
        res.addAll(query.getResultList());
        return res;
    }

    public Users findByUsername(String username) {
        try {
            return (Users)this.em.createNamedQuery("Users.findByUsername", Users.class).setParameter("username", (Object)username).getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public void persist(Users user) {
        this.em.persist((Object)user);
    }

    @Override
    public Users update(Users user) {
        return (Users)this.em.merge((Object)user);
    }

    public void removeByEmail(String email) {
        Users user = this.findByEmail(email);
        if (user != null) {
            this.em.remove((Object)user);
        }
    }

    @Override
    public void remove(Users user) {
        if (user != null && user.getEmail() != null && this.em.contains((Object)user)) {
            this.em.remove((Object)user);
        }
    }

    public Users findByEmail(String email) {
        if (email == null || email.isEmpty()) {
            return null;
        }
        try {
            return (Users)this.em.createNamedQuery("Users.findByEmail", Users.class).setParameter("email", (Object)email.toLowerCase()).getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public void detach(Users user) {
        this.em.detach((Object)user);
    }

    public List<Users> findAllByStatus(UserAccountStatus status) {
        TypedQuery query = this.em.createNamedQuery("Users.findByStatus", Users.class);
        query.setParameter("status", (Object)status);
        return query.getResultList();
    }

    public List<Integer> findAllInGroup(int gid) {
        BbcGroup role = (BbcGroup)this.groupFacade.find(gid);
        ArrayList<Integer> uIds = new ArrayList<Integer>();
        if (role == null) {
            return uIds;
        }
        ArrayList<BbcGroup> roles = new ArrayList<BbcGroup>();
        roles.add(role);
        TypedQuery query = this.em.createNamedQuery("Users.findAllInGroup", Integer.class);
        query.setParameter("roles", roles);
        uIds.addAll(query.getResultList());
        return uIds;
    }

    public void addGroup(String userMail, int gidNumber) {
        BbcGroup bbcGroup = (BbcGroup)this.em.find(BbcGroup.class, (Object)gidNumber);
        Users user = this.findByEmail(userMail);
        user.getBbcGroupCollection().add(bbcGroup);
        this.em.merge((Object)user);
    }

    public void removeGroup(String userMail, int gid) {
        Users user = this.findByEmail(userMail);
        UserGroup p = (UserGroup)this.em.find(UserGroup.class, (Object)new UserGroup(new UserGroupPK(user.getUid().intValue(), gid)).getUserGroupPK());
        this.em.remove((Object)p);
    }

    public void updateStatus(String userMail, UserAccountStatus newStatus) {
        Users user = this.findByEmail(userMail);
        user.setStatus(newStatus);
        this.em.merge((Object)user);
    }

    public static enum Filters {
        ROLE("ROLE", "u.bbcGroupCollection IN :roles ", "roles", "HOPS_ADMIN,HOPS_USER"),
        ROLE_NEQ("ROLE_NEQ", "u.bbcGroupCollection NOT IN :roles_neq ", "roles_neq", "AGENT"),
        TYPE("TYPE", "u.mode = :mode ", "mode", "0"),
        STATUS("STATUS", "u.status = :status ", "status", "2"),
        STATUS_LT("STATUS_LT", "u.status < :status_lt ", "status_lt", "2"),
        STATUS_GT("STATUS_GT", "u.status > :status_gt ", "status_gt", "2"),
        IS_ONLINE("IS_ONLINE", "u.isonline = :isonline ", "isonline", "1"),
        FALSE_LOGIN("FALSE_LOGIN", "u.falseLogin = :falseLogin ", "falseLogin", "20"),
        FALSE_LOGIN_GT("FALSE_LOGIN_GT", "u.falseLogin > :falseLogin_gt ", "falseLogin_gt", "20"),
        FALSE_LOGIN_LT("FALSE_LOGIN_LT", "u.falseLogin < :falseLogin_lt ", "falseLogin_lt", "20"),
        USER_NAME("USER_NAME", "UPPER(u.username) LIKE CONCAT(:username, '%') ", "username", " "),
        USER_FIRST_NAME("USER_FIRST_NAME", "UPPER(u.fname) LIKE CONCAT(:fname, '%') ", "fname", " "),
        USER_LAST_NAME("USER_LAST_NAME", "UPPER(u.lname) LIKE CONCAT(:lname, '%') ", "lname", " "),
        USER_EMAIL("USER_EMAIL", "UPPER(u.email) LIKE CONCAT(:email, '%') ", "email", " "),
        USER_LIKE("USER_LIKE", "(UPPER(u.username) LIKE CONCAT(:user, '%') OR UPPER(u.fname) LIKE CONCAT(:user, '%') OR UPPER(u.lname) LIKE CONCAT(:user, '%') OR UPPER(u.email) LIKE CONCAT(:user, '%')) ", "user", " ");

        private final String value;
        private final String sql;
        private final String field;
        private final String defaultParam;

        private Filters(String value, String sql, String field, String defaultParam) {
            this.value = value;
            this.sql = sql;
            this.field = field;
            this.defaultParam = defaultParam;
        }

        public String getValue() {
            return this.value;
        }

        public String getDefaultParam() {
            return this.defaultParam;
        }

        public String getSql() {
            return this.sql;
        }

        public String getField() {
            return this.field;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Sorts {
        FIRST_NAME("FIRST_NAME", "LOWER(u.fname) ", "ASC"),
        LAST_NAME("LAST_NAME", "LOWER(u.lname) ", "ASC"),
        EMAIL("EMAIL", "LOWER(u.email) ", "ASC"),
        DATE_CREATED("DATE_CREATED", "u.activated ", "ASC");

        private final String value;
        private final String sql;
        private final String defaultParam;

        private Sorts(String value, String sql, String defaultParam) {
            this.value = value;
            this.sql = sql;
            this.defaultParam = defaultParam;
        }

        public String getValue() {
            return this.value;
        }

        public String getSql() {
            return this.sql;
        }

        public String getDefaultParam() {
            return this.defaultParam;
        }

        public String getJoin() {
            return null;
        }

        public String toString() {
            return this.value;
        }
    }
}

