/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.utils;

import com.google.common.base.Strings;
import io.hops.hopsworks.common.featurestore.FeaturestoreConstants;
import io.hops.hopsworks.common.featurestore.FeaturestoreEntityDTO;
import io.hops.hopsworks.common.featurestore.feature.FeatureGroupFeatureDTO;
import io.hops.hopsworks.common.featurestore.feature.TrainingDatasetFeatureDTO;
import io.hops.hopsworks.common.featurestore.featuregroup.FeaturegroupDTO;
import io.hops.hopsworks.common.featurestore.trainingdatasets.TrainingDatasetDTO;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Pattern;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class FeaturestoreInputValidation {
    public void verifyUserInput(FeaturestoreEntityDTO featurestoreEntityDTO) throws FeaturestoreException {
        TrainingDatasetDTO trainingDatasetDTO;
        Pattern namePattern = FeaturestoreConstants.FEATURESTORE_REGEX;
        if (!namePattern.matcher(featurestoreEntityDTO.getName()).matches()) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_ENTITY_NAME, Level.FINE, ", the provided name " + featurestoreEntityDTO.getName() + " is invalid. Entity names can only contain lower case characters, numbers and underscores, have to start with a letter and cannot be longer than " + 63 + " characters or empty.");
        }
        this.verifyDescription(featurestoreEntityDTO);
        if (featurestoreEntityDTO instanceof FeaturegroupDTO) {
            this.verifyFeatureGroupFeatureList(((FeaturegroupDTO)featurestoreEntityDTO).getFeatures());
        } else if (featurestoreEntityDTO instanceof TrainingDatasetDTO && (trainingDatasetDTO = (TrainingDatasetDTO)featurestoreEntityDTO).getQueryDTO() == null && trainingDatasetDTO.getFeatures() != null) {
            this.verifyTrainingDatasetFeatureList(((TrainingDatasetDTO)featurestoreEntityDTO).getFeatures());
        }
    }

    public void verifyDescription(FeaturestoreEntityDTO featurestoreEntityDTO) throws FeaturestoreException {
        if (!Strings.isNullOrEmpty((String)featurestoreEntityDTO.getDescription()) && featurestoreEntityDTO.getDescription().length() > 256) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_ENTITY_DESCRIPTION, Level.FINE, ", the provided description for the entity " + featurestoreEntityDTO.getName() + " is too long with " + featurestoreEntityDTO.getDescription().length() + " characters. Entity descriptions cannot be longer than " + 256 + " characters.");
        }
    }

    public void verifyFeatureGroupFeatureList(List<FeatureGroupFeatureDTO> featureGroupFeatureDTOS) throws FeaturestoreException {
        if (featureGroupFeatureDTOS != null && !featureGroupFeatureDTOS.isEmpty()) {
            for (FeatureGroupFeatureDTO featureGroupFeatureDTO : featureGroupFeatureDTOS) {
                this.nameValidation(featureGroupFeatureDTO.getName());
                this.descriptionValidation(featureGroupFeatureDTO.getName(), featureGroupFeatureDTO.getDescription());
            }
        }
    }

    private void verifyTrainingDatasetFeatureList(List<TrainingDatasetFeatureDTO> trainingDatasetFeatureDTOS) throws FeaturestoreException {
        for (TrainingDatasetFeatureDTO trainingDatasetFeatureDTO : trainingDatasetFeatureDTOS) {
            this.nameValidation(trainingDatasetFeatureDTO.getName());
        }
    }

    void nameValidation(String name) throws FeaturestoreException {
        Pattern namePattern = FeaturestoreConstants.FEATURESTORE_REGEX;
        if (!namePattern.matcher(name).matches()) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_FEATURE_NAME, Level.FINE, ", the provided feature name " + name + " is invalid. Feature names can only contain lower case characters, numbers and underscores, have to start with a letter and cannot be longer than " + 63 + " characters or empty.");
        }
    }

    void descriptionValidation(String name, String description) throws FeaturestoreException {
        if (!Strings.isNullOrEmpty((String)description) && description.length() > 256) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_FEATURE_DESCRIPTION, Level.FINE, ", the provided feature description of " + name + " is too long with " + description + " characters. Feature descriptions cannot be longer than " + 256 + " characters.");
        }
    }
}

