/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.query.filter;

import com.google.gson.Gson;
import io.hops.hopsworks.common.featurestore.feature.FeatureGroupFeatureDTO;
import io.hops.hopsworks.common.featurestore.query.ConstructorController;
import io.hops.hopsworks.common.featurestore.query.Feature;
import io.hops.hopsworks.common.featurestore.query.Query;
import io.hops.hopsworks.common.featurestore.query.filter.Filter;
import io.hops.hopsworks.common.featurestore.query.filter.FilterDTO;
import io.hops.hopsworks.common.featurestore.query.filter.FilterLogic;
import io.hops.hopsworks.common.featurestore.query.filter.FilterLogicDTO;
import io.hops.hopsworks.common.featurestore.query.filter.SqlFilterLogic;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.Featuregroup;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.json.JSONArray;
import org.json.JSONTokener;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class FilterController {
    @EJB
    private ConstructorController constructorController;

    public FilterController() {
    }

    public FilterController(ConstructorController constructorController) {
        this.constructorController = constructorController;
    }

    public FilterLogic convertFilterLogic(FilterLogicDTO filterLogicDTO, Map<Integer, Featuregroup> fgLookup, Map<Integer, List<Feature>> availableFeatureLookup) throws FeaturestoreException {
        FilterLogic filterLogic = new FilterLogic(filterLogicDTO.getType());
        this.validateFilterLogicDTO(filterLogicDTO);
        if (filterLogicDTO.getLeftFilter() != null) {
            filterLogic.setLeftFilter(this.convertFilter(filterLogicDTO.getLeftFilter(), fgLookup, availableFeatureLookup));
        }
        if (filterLogicDTO.getRightFilter() != null) {
            filterLogic.setRightFilter(this.convertFilter(filterLogicDTO.getRightFilter(), fgLookup, availableFeatureLookup));
        }
        if (filterLogicDTO.getLeftLogic() != null) {
            filterLogic.setLeftLogic(this.convertFilterLogic(filterLogicDTO.getLeftLogic(), fgLookup, availableFeatureLookup));
        }
        if (filterLogicDTO.getRightLogic() != null) {
            filterLogic.setRightLogic(this.convertFilterLogic(filterLogicDTO.getRightLogic(), fgLookup, availableFeatureLookup));
        }
        return filterLogic;
    }

    void validateFilterLogicDTO(FilterLogicDTO filterLogicDTO) throws FeaturestoreException {
        if (filterLogicDTO.getLeftFilter() != null && filterLogicDTO.getLeftLogic() != null || filterLogicDTO.getRightFilter() != null && filterLogicDTO.getRightLogic() != null || filterLogicDTO.getType() == SqlFilterLogic.SINGLE && (filterLogicDTO.getLeftFilter() == null || filterLogicDTO.getLeftLogic() != null || filterLogicDTO.getRightFilter() != null || filterLogicDTO.getRightLogic() != null)) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_FILTER_ARGUMENTS, Level.FINE, "The provided filters for the Query are malformed, please do not access private attributes, contact maintainers with reproducible example.");
        }
    }

    Filter convertFilter(FilterDTO filterDTO, Map<Integer, Featuregroup> fgLookup, Map<Integer, List<Feature>> availableFeatureLookup) throws FeaturestoreException {
        return new Filter(this.findFilteredFeature(filterDTO.getFeature(), fgLookup, availableFeatureLookup), filterDTO.getCondition(), filterDTO.getValue());
    }

    Feature findFilteredFeature(FeatureGroupFeatureDTO featureDTO, Map<Integer, Featuregroup> fgLookup, Map<Integer, List<Feature>> availableFeatureLookup) throws FeaturestoreException {
        Optional<Object> feature = Optional.empty();
        if (featureDTO.getFeatureGroupId() != null) {
            feature = availableFeatureLookup.get(featureDTO.getFeatureGroupId()).stream().filter(af -> af.getName().equals(featureDTO.getName())).findFirst();
        } else {
            Map.Entry<Integer, List<Feature>> pair;
            Iterator<Map.Entry<Integer, List<Feature>>> iterator = availableFeatureLookup.entrySet().iterator();
            while (iterator.hasNext() && !(feature = (pair = iterator.next()).getValue().stream().filter(af -> af.getName().equals(featureDTO.getName())).findFirst()).isPresent()) {
            }
        }
        return (Feature)feature.orElseThrow(() -> new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FEATURE_DOES_NOT_EXIST, Level.FINE, "Filtered feature: `" + featureDTO.getName() + "` not found in any of the feature groups."));
    }

    public SqlNode generateFilterLogicNode(FilterLogic filterLogic, boolean online) {
        if (filterLogic.getType() == SqlFilterLogic.SINGLE) {
            return this.generateFilterNode(filterLogic.getLeftFilter(), online);
        }
        SqlNode leftNode = filterLogic.getLeftFilter() != null ? this.generateFilterNode(filterLogic.getLeftFilter(), online) : this.generateFilterLogicNode(filterLogic.getLeftLogic(), online);
        SqlNode rightNode = filterLogic.getRightFilter() != null ? this.generateFilterNode(filterLogic.getRightFilter(), online) : this.generateFilterLogicNode(filterLogic.getRightLogic(), online);
        return filterLogic.getType().operator.createCall(SqlParserPos.ZERO, new SqlNode[]{leftNode, rightNode});
    }

    public SqlNode generateFilterNode(Filter filter, boolean online) {
        SqlNode filterValue;
        Object feature = filter.getFeature().getDefaultValue() == null || online ? (filter.getFeature().getFgAlias(false) != null ? new SqlIdentifier(Arrays.asList("`" + filter.getFeature().getFgAlias(false) + "`", "`" + filter.getFeature().getName() + "`"), SqlParserPos.ZERO) : new SqlIdentifier("`" + filter.getFeature().getName() + "`", SqlParserPos.ZERO)) : this.constructorController.caseWhenDefault(filter.getFeature());
        Object json = new JSONTokener(filter.getValue()).nextValue();
        if (json instanceof JSONArray) {
            ArrayList<SqlNode> operandList = new ArrayList<SqlNode>();
            for (Object item : (List)new Gson().fromJson(filter.getValue(), List.class)) {
                operandList.add(this.getSQLNode(filter.getFeature().getType(), item.toString()));
            }
            filterValue = new SqlNodeList(operandList, SqlParserPos.ZERO);
        } else {
            filterValue = this.getSQLNode(filter.getFeature().getType(), json.toString());
        }
        return filter.getCondition().operator.createCall(SqlParserPos.ZERO, new SqlNode[]{feature, filterValue});
    }

    private SqlNode getSQLNode(String type, String value) {
        if (type.equalsIgnoreCase("string")) {
            return SqlLiteral.createCharString((String)value, (SqlParserPos)SqlParserPos.ZERO);
        }
        return new SqlIdentifier(value, SqlParserPos.ZERO);
    }

    public SqlNode buildFilterNode(Query baseQuery, Query query, int i, boolean online) {
        if (i < 0 && query.getFilter() != null) {
            return this.generateFilterLogicNode(query.getFilter(), online);
        }
        if (i >= 0) {
            SqlNode filter = this.buildFilterNode(baseQuery, baseQuery.getJoins().get(i).getRightQuery(), i - 1, online);
            if (filter != null && query.getFilter() != null) {
                return SqlStdOperatorTable.AND.createCall(SqlParserPos.ZERO, new SqlNode[]{this.generateFilterLogicNode(query.getFilter(), online), filter});
            }
            if (filter != null) {
                return filter;
            }
            if (query.getFilter() != null) {
                return this.generateFilterLogicNode(query.getFilter(), online);
            }
        }
        return null;
    }
}

