/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.proxies.client;

import io.hops.hopsworks.common.proxies.client.NotRetryableClientProtocolException;
import io.hops.hopsworks.common.proxies.client.RetryableAction;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.util.BackOff;
import org.apache.hadoop.util.ExponentialBackOff;
import org.apache.http.client.ClientProtocolException;

public abstract class HttpRetryableAction<T>
implements RetryableAction {
    private final BackOff backOffPolicy;

    public HttpRetryableAction() {
        this(new ExponentialBackOff.Builder().setInitialIntervalMillis(500L).setMaximumIntervalMillis(5000L).setMaximumRetries(5).setMultiplier(1.7));
    }

    public HttpRetryableAction(ExponentialBackOff.Builder backoffBuilder) {
        this.backOffPolicy = backoffBuilder.build();
    }

    public abstract T performAction() throws ClientProtocolException, IOException;

    @Override
    public T tryAction() throws ClientProtocolException, IOException {
        this.backOffPolicy.reset();
        while (true) {
            try {
                return this.performAction();
            }
            catch (NotRetryableClientProtocolException ex) {
                throw ex;
            }
            catch (IOException ex) {
                long timeout = this.backOffPolicy.getBackOffInMillis();
                if (timeout != -1L) {
                    try {
                        TimeUnit.MILLISECONDS.sleep(timeout);
                    }
                    catch (InterruptedException iex) {
                        throw new ClientProtocolException(ex.getMessage(), (Throwable)ex);
                    }
                    continue;
                }
                throw ex;
            }
            break;
        }
    }
}

