/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.datavalidation;

import com.google.common.base.Strings;
import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.Featuregroup;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.cached.TimeTravelFormat;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.datavalidation.FeatureGroupValidation;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Optional;
import java.util.Set;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;

@Stateless
public class FeatureGroupValidationFacade
extends AbstractFacade<FeatureGroupValidationFacade> {
    private static final String JPQL_FEATURE_GROUP_COMMIT = "JOIN FETCH fgv.commit c ";
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    public FeatureGroupValidationFacade() {
        super(FeatureGroupValidationFacade.class);
    }

    @Override
    protected EntityManager getEntityManager() {
        return this.em;
    }

    public void persist(FeatureGroupValidation featureGroupValidation) {
        this.em.persist((Object)featureGroupValidation);
    }

    public FeatureGroupValidation findById(int id) {
        return (FeatureGroupValidation)this.em.find(FeatureGroupValidation.class, (Object)id);
    }

    public Optional<FeatureGroupValidation> findByFeaturegroupAndValidationTime(Featuregroup featureGroup, Date validationTime) {
        try {
            return Optional.of(this.em.createNamedQuery("FeatureGroupValidation.findByFeatureGroupAndValidationTime", FeatureGroupValidation.class).setParameter("featureGroup", (Object)featureGroup).setParameter("validationTime", (Object)validationTime).getSingleResult());
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }

    public AbstractFacade.CollectionInfo findByFeatureGroup(Integer offset, Integer limit, Set<? extends AbstractFacade.FilterBy> filters, Set<? extends AbstractFacade.SortBy> sorts, Featuregroup featureGroup) {
        String join = "";
        if (featureGroup.getCachedFeaturegroup() != null && featureGroup.getCachedFeaturegroup().getTimeTravelFormat() == TimeTravelFormat.HUDI) {
            if (sorts != null) {
                for (AbstractFacade.SortBy sortBy : sorts) {
                    if (!sortBy.getValue().contains(Sorts.COMMIT_TIME.getValue())) continue;
                    join = JPQL_FEATURE_GROUP_COMMIT;
                    break;
                }
            }
            if (filters != null) {
                for (AbstractFacade.FilterBy filterBy : filters) {
                    if (!filterBy.getValue().contains("COMMIT_TIME")) continue;
                    join = JPQL_FEATURE_GROUP_COMMIT;
                    break;
                }
            }
        }
        String queryStr = this.buildQuery("SELECT fgv FROM FeatureGroupValidation fgv " + join, filters, sorts, "fgv.featureGroup = :featureGroup ");
        String string = this.buildQuery("SELECT COUNT(fgv.id) FROM FeatureGroupValidation fgv " + join, filters, sorts, "fgv.featureGroup = :featureGroup ");
        TypedQuery query = this.em.createQuery(queryStr, FeatureGroupValidation.class).setParameter("featureGroup", (Object)featureGroup);
        TypedQuery queryCount = this.em.createQuery(string, FeatureGroupValidation.class).setParameter("featureGroup", (Object)featureGroup);
        this.setFilter(filters, (Query)query);
        this.setFilter(filters, (Query)queryCount);
        this.setOffsetAndLim(offset, limit, (Query)query);
        return new AbstractFacade.CollectionInfo((Long)queryCount.getSingleResult(), query.getResultList());
    }

    private void setFilter(Set<? extends AbstractFacade.FilterBy> filter, Query q) {
        if (filter == null || filter.isEmpty()) {
            return;
        }
        for (AbstractFacade.FilterBy filterBy : filter) {
            this.setFilterQuery(filterBy, q);
        }
    }

    private void setFilterQuery(AbstractFacade.FilterBy filterBy, Query q) {
        switch (Filters.valueOf(filterBy.getValue())) {
            case VALIDATION_TIME_EQ: 
            case VALIDATION_TIME_GT: 
            case VALIDATION_TIME_LT: 
            case COMMIT_TIME_EQ: 
            case COMMIT_TIME_LT: 
            case COMMIT_TIME_GT: {
                if (Strings.isNullOrEmpty((String)filterBy.getParam()) || filterBy.getParam().equalsIgnoreCase("null")) break;
                Timestamp date = new Timestamp(Long.parseLong(filterBy.getParam()));
                q.setParameter(filterBy.getField(), (Object)date);
                break;
            }
            case STATUS_EQ: {
                q.setParameter(filterBy.getField(), (Object)FeatureGroupValidation.Status.valueOf((String)filterBy.getParam()));
            }
        }
    }

    public static enum Filters {
        VALIDATION_TIME_EQ("VALIDATION_TIME_EQ", "fgv.validationTime = :validationTime ", "validationTime", " "),
        VALIDATION_TIME_GT("VALIDATION_TIME_GT", "fgv.validationTime > :validationTime ", "validationTime", " "),
        VALIDATION_TIME_LT("VALIDATION_TIME_LT", "fgv.validationTime < :validationTime ", "validationTime", " "),
        COMMIT_TIME_EQ("COMMIT_TIME_EQ", "fgv.commit.committedOn = :commitTime ", "commitTime", " "),
        COMMIT_TIME_LT("COMMIT_TIME_LT", "fgv.commit.committedOn > :commitTime ", "commitTime", " "),
        COMMIT_TIME_GT("COMMIT_TIME_GT", "fgv.commit.committedOn < :commitTime ", "commitTime", " "),
        STATUS_EQ("STATUS_EQ", "fgv.status = :status", "status", "");

        private final String value;
        private final String sql;
        private final String field;
        private final String defaultParam;

        private Filters(String value, String sql, String field, String defaultParam) {
            this.value = value;
            this.sql = sql;
            this.field = field;
            this.defaultParam = defaultParam;
        }

        public String getValue() {
            return this.value;
        }

        public String getDefaultParam() {
            return this.defaultParam;
        }

        public String getSql() {
            return this.sql;
        }

        public String getField() {
            return this.field;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Sorts {
        ID("ID", "fgv.id ", "ASC"),
        VALIDATION_TIME("VALIDATION_TIME", "fgv.validationTime", "ASC"),
        COMMIT_TIME("COMMIT_TIME", "c.committedOn", "ASC");

        private final String value;
        private final String sql;
        private final String defaultParam;

        private Sorts(String value, String sql, String defaultParam) {
            this.value = value;
            this.sql = sql;
            this.defaultParam = defaultParam;
        }

        public String getValue() {
            return this.value;
        }

        public String getDefaultParam() {
            return this.defaultParam;
        }

        public String getSql() {
            return this.sql;
        }

        public String toString() {
            return this.value;
        }
    }
}

