/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.jupyter;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationModule;
import com.google.common.base.Strings;
import com.logicalclocks.servicediscoverclient.exceptions.ServiceDiscoveryException;
import io.hops.hopsworks.common.dao.hdfsUser.HdfsUsersFacade;
import io.hops.hopsworks.common.dao.jupyter.JupyterSettingsFacade;
import io.hops.hopsworks.common.dao.jupyter.config.JupyterFacade;
import io.hops.hopsworks.common.dao.user.UserFacade;
import io.hops.hopsworks.common.hdfs.DistributedFileSystemOps;
import io.hops.hopsworks.common.hdfs.DistributedFsService;
import io.hops.hopsworks.common.hdfs.HdfsUsersController;
import io.hops.hopsworks.common.hdfs.xattrs.XAttrsController;
import io.hops.hopsworks.common.jupyter.JupyterJWTManager;
import io.hops.hopsworks.common.jupyter.JupyterManager;
import io.hops.hopsworks.common.jupyter.JupyterNbVCSController;
import io.hops.hopsworks.common.livy.LivyController;
import io.hops.hopsworks.common.livy.LivyMsg;
import io.hops.hopsworks.common.security.CertificateMaterializer;
import io.hops.hopsworks.common.util.HopsUtils;
import io.hops.hopsworks.common.util.OSProcessExecutor;
import io.hops.hopsworks.common.util.ProcessDescriptor;
import io.hops.hopsworks.common.util.ProcessResult;
import io.hops.hopsworks.common.util.ProjectUtils;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.ServiceException;
import io.hops.hopsworks.persistence.entity.hdfs.user.HdfsUsers;
import io.hops.hopsworks.persistence.entity.jupyter.JupyterProject;
import io.hops.hopsworks.persistence.entity.jupyter.JupyterSettings;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.inject.Inject;
import javax.ws.rs.client.ClientBuilder;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.json.JSONArray;
import org.json.JSONObject;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class JupyterController {
    private static final Logger LOGGER = Logger.getLogger(JupyterController.class.getName());
    @EJB
    private DistributedFsService dfs;
    @EJB
    private OSProcessExecutor osProcessExecutor;
    @EJB
    private Settings settings;
    @EJB
    private LivyController livyController;
    @EJB
    private JupyterFacade jupyterFacade;
    @Inject
    private JupyterManager jupyterManager;
    @EJB
    private CertificateMaterializer certificateMaterializer;
    @EJB
    private DistributedFsService dfsService;
    @EJB
    private HdfsUsersController hdfsUsersController;
    @EJB
    private UserFacade userFacade;
    @EJB
    private JupyterSettingsFacade jupyterSettingsFacade;
    @EJB
    private HdfsUsersFacade hdfsUsersFacade;
    @EJB
    private JupyterJWTManager jupyterJWTManager;
    @Inject
    private JupyterNbVCSController jupyterNbVCSController;
    @EJB
    private ProjectUtils projectUtils;
    @EJB
    private XAttrsController xAttrsController;
    private ObjectMapper objectMapper;

    @PostConstruct
    public void init() {
        this.objectMapper = new ObjectMapper();
        this.objectMapper.registerModule((Module)new JaxbAnnotationModule());
    }

    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public String convertIPythonNotebook(String hdfsUsername, String notebookPath, Project project, String pyPath, NotebookConversion notebookConversion) throws ServiceException {
        File baseDir = new File(this.settings.getStagingDir() + "/ipython_conversions/");
        if (!baseDir.exists()) {
            baseDir.mkdir();
        }
        File conversionDir = new File(baseDir, DigestUtils.sha256Hex((String)Integer.toString(ThreadLocalRandom.current().nextInt())));
        conversionDir.mkdir();
        HdfsUsers user = this.hdfsUsersFacade.findByName(hdfsUsername);
        try {
            String prog = this.settings.getSudoersDir() + "/convert-ipython-notebook.sh";
            ProcessDescriptor processDescriptor = new ProcessDescriptor.Builder().addCommand("/usr/bin/sudo").addCommand(prog).addCommand(notebookPath).addCommand(hdfsUsername).addCommand(this.settings.getAnacondaProjectDir()).addCommand(pyPath).addCommand(conversionDir.getAbsolutePath()).addCommand(notebookConversion.name()).addCommand(this.projectUtils.getFullDockerImageName(project, true)).setWaitTimeout(60L, TimeUnit.SECONDS).redirectErrorStream(true).build();
            LOGGER.log(Level.FINE, processDescriptor.toString());
            this.certificateMaterializer.materializeCertificatesLocalCustomDir(user.getUsername(), project.getName(), conversionDir.getAbsolutePath());
            ProcessResult processResult = this.osProcessExecutor.execute(processDescriptor);
            if (!processResult.processExited() || processResult.getExitCode() != 0) {
                LOGGER.log(Level.WARNING, "error code: " + processResult.getExitCode(), "Failed to convert " + notebookPath + "\nstderr: " + processResult.getStderr() + "\nstdout: " + processResult.getStdout());
                throw new ServiceException(RESTCodes.ServiceErrorCode.IPYTHON_CONVERT_ERROR, Level.SEVERE, "error code: " + processResult.getExitCode(), "Failed to convert " + notebookPath + "\nstderr: " + processResult.getStderr() + "\nstdout: " + processResult.getStdout());
            }
            String stdOut = processResult.getStdout();
            if (!Strings.isNullOrEmpty((String)stdOut) && notebookConversion.equals((Object)NotebookConversion.HTML)) {
                StringBuilder renderedNotebookSB = new StringBuilder(stdOut);
                int startIndex = renderedNotebookSB.indexOf("<html>");
                int stopIndex = renderedNotebookSB.length();
                String string = renderedNotebookSB.substring(startIndex, stopIndex);
                return string;
            }
            String string = null;
            return string;
        }
        catch (ServiceDiscoveryException | IOException ex) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.IPYTHON_CONVERT_ERROR, Level.SEVERE, null, ex.getMessage(), ex);
        }
        finally {
            this.certificateMaterializer.removeCertificatesLocalCustomDir(user.getUsername(), project.getName(), conversionDir.getAbsolutePath());
        }
    }

    public void shutdownOrphan(String cid, Integer port) throws ServiceException {
        try {
            this.jupyterManager.stopOrphanedJupyterServer(cid, port);
        }
        finally {
            this.jupyterJWTManager.cleanJWT(cid, port);
        }
    }

    public void shutdownQuietly(Project project, String hdfsUser, Users user, String secret, String cid, int port) {
        try {
            this.shutdown(project, hdfsUser, user, secret, cid, port, true);
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Encountered exception while cleaning up", e);
        }
        this.jupyterJWTManager.cleanJWT(cid, port);
    }

    public void shutdown(Project project, String hdfsUser, Users user, String secret, String cid, int port) throws ServiceException {
        this.shutdown(project, hdfsUser, user, secret, cid, port, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(Project project, String hdfsUser, Users user, String secret, String cid, int port, boolean quiet) throws ServiceException {
        DistributedFileSystemOps dfso;
        String[] project_user;
        List<LivyMsg.Session> sessions = this.livyController.getLivySessionsForProjectUser(project, user);
        for (int retries = 3; retries > 0 && this.livyController.getLivySessionsForProjectUser(project, user).size() > 0; --retries) {
            LOGGER.log(Level.SEVERE, "Failed previous attempt to delete livy sessions for project " + project.getName() + " user " + hdfsUser + ", retrying...");
            this.livyController.deleteAllLivySessions(hdfsUser);
            try {
                Thread.sleep(200L);
                continue;
            }
            catch (InterruptedException ie) {
                LOGGER.log(Level.SEVERE, "Interrupted while sleeping");
            }
        }
        String jupyterHomePath = this.jupyterManager.getJupyterHome(hdfsUser, project, secret);
        try {
            JupyterProject jupyterProject = this.jupyterFacade.findByUser(hdfsUser);
            JupyterSettings jupyterSettings = this.jupyterSettingsFacade.findByProjectUser(project, user.getEmail());
            if (jupyterProject != null && jupyterSettings != null && jupyterSettings.isGitBackend().booleanValue() && jupyterSettings.getGitConfig().getShutdownAutoPush().booleanValue()) {
                try {
                    this.jupyterNbVCSController.push(jupyterProject, jupyterSettings, user);
                }
                catch (ServiceException ex) {
                    if (!quiet) {
                        throw ex;
                    }
                    LOGGER.log(Level.WARNING, "Could not push Git repository, shutting down Jupyter nevertheless", ex);
                }
            }
            this.jupyterManager.stopJupyterServer(project, user, hdfsUser, jupyterHomePath, cid, port);
            project_user = hdfsUser.split("__");
            dfso = this.dfsService.getDfsOps();
        }
        catch (Throwable throwable) {
            String[] project_user2 = hdfsUser.split("__");
            DistributedFileSystemOps dfso2 = this.dfsService.getDfsOps();
            try {
                String certificatesDir = Paths.get(jupyterHomePath, "certificates").toString();
                HopsUtils.cleanupCertificatesForUserCustomDir(project_user2[1], project.getName(), this.settings.getHdfsTmpCertDir(), this.certificateMaterializer, certificatesDir, this.settings);
                this.certificateMaterializer.removeCertificatesLocal(project_user2[1], project.getName());
            }
            finally {
                if (dfso2 != null) {
                    this.dfsService.closeDfsClient(dfso2);
                }
            }
            FileUtils.deleteQuietly((File)new File(jupyterHomePath));
            this.jupyterJWTManager.cleanJWT(cid, port);
            this.livyController.deleteAllLivySessions(hdfsUser);
            throw throwable;
        }
        try {
            String certificatesDir = Paths.get(jupyterHomePath, "certificates").toString();
            HopsUtils.cleanupCertificatesForUserCustomDir(project_user[1], project.getName(), this.settings.getHdfsTmpCertDir(), this.certificateMaterializer, certificatesDir, this.settings);
            this.certificateMaterializer.removeCertificatesLocal(project_user[1], project.getName());
        }
        finally {
            if (dfso != null) {
                this.dfsService.closeDfsClient(dfso);
            }
        }
        FileUtils.deleteQuietly((File)new File(jupyterHomePath));
        this.jupyterJWTManager.cleanJWT(cid, port);
        this.livyController.deleteAllLivySessions(hdfsUser);
    }

    public void stopSession(Project project, Users user, String appId) {
        List<LivyMsg.Session> sessions = this.livyController.getLivySessionsForProjectUser(project, user);
        for (LivyMsg.Session session : sessions) {
            if (!session.getAppId().equalsIgnoreCase(appId)) continue;
            this.livyController.deleteLivySession(session.getId());
            break;
        }
    }

    public void removeJupyter(Project project) throws ServiceException {
        for (JupyterProject jp : project.getJupyterProjectCollection()) {
            HdfsUsers hdfsUser = this.hdfsUsersFacade.findById(jp.getHdfsUserId());
            String username = this.hdfsUsersController.getUserName(hdfsUser.getName());
            Users user = this.userFacade.findByUsername(username);
            this.shutdown(project, hdfsUser.getName(), user, jp.getSecret(), jp.getCid(), jp.getPort());
        }
        this.jupyterManager.projectCleanup(project);
    }

    public void updateExpirationDate(Project project, Users user, JupyterSettings jupyterSettings) {
        JupyterSettings js = this.jupyterSettingsFacade.findByProjectUser(project, user.getEmail());
        js.setShutdownLevel(jupyterSettings.getShutdownLevel());
        this.jupyterSettingsFacade.update(js);
        String hdfsUser = this.hdfsUsersController.getHdfsUserName(project, user);
        JupyterProject jupyterProject = this.jupyterFacade.findByUser(hdfsUser);
        Date expirationDate = jupyterProject.getExpires();
        Calendar cal = Calendar.getInstance();
        cal.setTime(expirationDate);
        cal.add(11, jupyterSettings.getShutdownLevel());
        expirationDate = cal.getTime();
        jupyterProject.setExpires(expirationDate);
        jupyterProject.setNoLimit(jupyterSettings.isNoLimit());
        this.jupyterFacade.update(jupyterProject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void versionProgram(Project project, Users user, String sessionKernelId, Path outputPath) throws ServiceException {
        DistributedFileSystemOps udfso = null;
        try {
            String username = this.hdfsUsersController.getHdfsUserName(project, user);
            udfso = this.dfs.getDfsOps(username);
            this.versionProgram(username, sessionKernelId, outputPath, udfso);
            if (udfso != null) {
                this.dfs.closeDfsClient(udfso);
            }
        }
        catch (Throwable throwable) {
            if (udfso != null) {
                this.dfs.closeDfsClient(udfso);
            }
            throw throwable;
        }
    }

    public void versionProgram(String hdfsUser, String sessionKernelId, Path outputPath, DistributedFileSystemOps udfso) throws ServiceException {
        block4: {
            JupyterProject jp = this.jupyterFacade.findByUser(hdfsUser);
            String relativeNotebookPath = null;
            try {
                relativeNotebookPath = this.getNotebookRelativeFilePath(hdfsUser, sessionKernelId, udfso);
                if (Strings.isNullOrEmpty((String)relativeNotebookPath)) break block4;
                JSONObject notebookContents = new JSONObject((String)ClientBuilder.newClient().target("http://" + this.jupyterManager.getJupyterHost() + ":" + jp.getPort() + "/hopsworks-api/jupyter/" + jp.getPort() + "/api/contents/" + relativeNotebookPath + "?content=1&token=" + jp.getToken()).request().method("GET").readEntity(String.class));
                JSONObject notebookJSON = (JSONObject)notebookContents.get("content");
                try {
                    udfso.create(outputPath, notebookJSON.toString());
                }
                catch (IOException e) {
                    throw new ServiceException(RESTCodes.ServiceErrorCode.JUPYTER_NOTEBOOK_VERSIONING_FAILED, Level.FINE, "failed to save notebook content", e.getMessage(), (Throwable)e);
                }
            }
            catch (Exception e) {
                throw new ServiceException(RESTCodes.ServiceErrorCode.JUPYTER_NOTEBOOK_VERSIONING_FAILED, Level.FINE, "failed to version notebook", e.getMessage(), (Throwable)e);
            }
        }
    }

    public void attachJupyterConfigurationToNotebook(Users user, String hdfsUsername, Project project, String kernelId) throws ServiceException {
        DistributedFileSystemOps udfso = null;
        try {
            JupyterSettings jupyterSettings = this.jupyterSettingsFacade.findByProjectUser(project, user.getEmail());
            if (jupyterSettings.isGitBackend().booleanValue()) {
                return;
            }
            udfso = this.dfs.getDfsOps(hdfsUsername);
            String relativeNotebookPath = this.getNotebookRelativeFilePath(hdfsUsername, kernelId, udfso);
            JSONObject jupyterSettingsMetadataObj = new JSONObject();
            jupyterSettingsMetadataObj.put("jupyter_configuration", (Object)this.objectMapper.writeValueAsString((Object)jupyterSettings));
            jupyterSettingsMetadataObj.put("usage_time", new Date().getTime());
            this.xAttrsController.addStrXAttr(jupyterSettings.getBaseDir() + "/" + relativeNotebookPath, "jupyter_configuration", jupyterSettingsMetadataObj.toString(), udfso);
            this.dfs.closeDfsClient(udfso);
        }
        catch (Exception e) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.ATTACHING_JUPYTER_CONFIG_TO_NOTEBOOK_FAILED, Level.FINE, "Failed to attach jupyter configuration for user: " + user + ", project: " + project + ", kernelId: " + kernelId, e.getMessage(), (Throwable)e);
        }
        finally {
            this.dfs.closeDfsClient(udfso);
        }
    }

    public String getNotebookRelativeFilePath(String hdfsUser, String sessionKernelId, DistributedFileSystemOps udfso) throws ServiceException {
        String relativeNotebookPath = null;
        JupyterProject jp = this.jupyterFacade.findByUser(hdfsUser);
        JSONArray sessionsArray = new JSONArray((String)ClientBuilder.newClient().target("http://" + this.jupyterManager.getJupyterHost() + ":" + jp.getPort() + "/hopsworks-api/jupyter/" + jp.getPort() + "/api/sessions?token=" + jp.getToken()).request().method("GET").readEntity(String.class));
        boolean foundKernel = false;
        for (int i = 0; i < sessionsArray.length(); ++i) {
            JSONObject session = (JSONObject)sessionsArray.get(i);
            JSONObject kernel = (JSONObject)session.get("kernel");
            String kernelId = kernel.getString("id");
            if (!kernelId.equals(sessionKernelId)) continue;
            relativeNotebookPath = session.getString("path");
            foundKernel = true;
        }
        if (!foundKernel) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.JUPYTER_NOTEBOOK_VERSIONING_FAILED, Level.FINE, "failed to find kernel " + sessionKernelId);
        }
        return relativeNotebookPath;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public NotebookConversion getNotebookConversionType(String notebookPath, Users user, Project project) throws ServiceException {
        String projectUsername = this.hdfsUsersController.getHdfsUserName(project, user);
        DistributedFileSystemOps udfso = null;
        Path p = new Path(notebookPath);
        try {
            String notebookString;
            udfso = this.dfs.getDfsOps(projectUsername);
            try (FSDataInputStream inStream = udfso.open(p);){
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                IOUtils.copyBytes((InputStream)inStream, (OutputStream)out, (int)512);
                notebookString = out.toString("UTF-8");
            }
            JSONObject notebookJSON = new JSONObject(notebookString);
            String notebookKernel = (String)notebookJSON.getJSONObject("metadata").getJSONObject("kernelspec").get("display_name");
            Optional<NotebookConversion> kernel = NotebookConversion.fromKernel(notebookKernel);
            if (!kernel.isPresent()) throw new ServiceException(RESTCodes.ServiceErrorCode.IPYTHON_CONVERT_ERROR, Level.FINE, "Unsupported kernel for notebook. Conversion to .py is for PySpark or Python notebooks");
            if (kernel.get() == NotebookConversion.PY_JOB || kernel.get() == NotebookConversion.PY) {
                NotebookConversion notebookConversion = kernel.get();
                return notebookConversion;
            }
            try {
                throw new ServiceException(RESTCodes.ServiceErrorCode.IPYTHON_CONVERT_ERROR, Level.FINE, "Unsupported kernel: " + kernel.get().name() + ". Conversion to .py is for PySpark or Python notebooks");
            }
            catch (Exception e) {
                throw new ServiceException(RESTCodes.ServiceErrorCode.IPYTHON_CONVERT_ERROR, Level.FINE, "Failed to get kernel for notebook.", e.getMessage(), (Throwable)e);
            }
        }
        finally {
            this.dfs.closeDfsClient(udfso);
        }
    }

    public static enum NotebookConversion {
        PY("PySpark"),
        HTML("Html"),
        PY_JOB("Python");

        private String kernel;

        private NotebookConversion(String kernel) {
            this.kernel = kernel;
        }

        public static Optional<NotebookConversion> fromKernel(String kernel) {
            return Arrays.stream(NotebookConversion.values()).filter(k -> k.getKernel().equalsIgnoreCase(kernel)).findFirst();
        }

        public String getKernel() {
            return this.kernel;
        }
    }
}

