/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.featuregroup;

import io.hops.hopsworks.common.featurestore.FeaturestoreConstants;
import io.hops.hopsworks.common.featurestore.feature.FeatureGroupFeatureDTO;
import io.hops.hopsworks.common.featurestore.featuregroup.FeaturegroupDTO;
import io.hops.hopsworks.common.featurestore.featuregroup.cached.CachedFeaturegroupDTO;
import io.hops.hopsworks.common.featurestore.utils.FeaturestoreInputValidation;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class FeatureGroupInputValidation {
    @EJB
    private FeaturestoreInputValidation featureStoreInputValidation;

    public void verifyUserInput(FeaturegroupDTO featuregroupDTO) throws FeaturestoreException {
        this.featureStoreInputValidation.verifyUserInput(featuregroupDTO);
        this.verifyFeatureGroupFeatureList(featuregroupDTO.getFeatures());
    }

    public void verifyFeatureGroupFeatureList(List<FeatureGroupFeatureDTO> featureGroupFeatureDTOS) throws FeaturestoreException {
        if (featureGroupFeatureDTOS != null && !featureGroupFeatureDTOS.isEmpty()) {
            for (FeatureGroupFeatureDTO featureGroupFeatureDTO : featureGroupFeatureDTOS) {
                this.featureStoreInputValidation.nameValidation(featureGroupFeatureDTO.getName());
                this.featureStoreInputValidation.descriptionValidation(featureGroupFeatureDTO.getName(), featureGroupFeatureDTO.getDescription());
            }
        }
    }

    public void verifyEventTimeFeature(String name, List<FeatureGroupFeatureDTO> features) throws FeaturestoreException {
        if (name == null) {
            return;
        }
        Optional<FeatureGroupFeatureDTO> eventTimeFeature = features.stream().filter(feature -> feature.getName().equalsIgnoreCase(name)).findAny();
        if (eventTimeFeature.isPresent()) {
            if (!FeaturestoreConstants.EVENT_TIME_FEATURE_TYPES.contains(eventTimeFeature.get().getType().toUpperCase())) {
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_EVENT_TIME_FEATURE_TYPE, Level.FINE, ", the provided event time feature `" + name + "` is of type `" + eventTimeFeature.get().getType() + "` but can only be one of the following types: " + FeaturestoreConstants.EVENT_TIME_FEATURE_TYPES + ".");
            }
        } else {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.EVENT_TIME_FEATURE_NOT_FOUND, Level.FINE, ", the provided event time feature `" + name + "` was not found among the available features: " + features.stream().map(FeatureGroupFeatureDTO::getName).collect(Collectors.joining(", ")) + ".");
        }
    }

    public void verifySchemaProvided(FeaturegroupDTO featuregroupDTO) throws FeaturestoreException {
        if (featuregroupDTO instanceof CachedFeaturegroupDTO && ((CachedFeaturegroupDTO)featuregroupDTO).getOnlineEnabled().booleanValue() && featuregroupDTO.getFeatures().isEmpty()) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.COULD_NOT_CREATE_ONLINE_FEATUREGROUP, Level.SEVERE, "Cannot create an online feature group without a feature schema.");
        }
    }
}

