/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.security;

import io.hops.hopsworks.common.security.AcquireLockException;
import io.hops.hopsworks.persistence.entity.security.RemoteMaterialRefID;
import io.hops.hopsworks.persistence.entity.security.RemoteMaterialReferences;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
public class RemoteMaterialReferencesFacade {
    private static final Logger LOG = Logger.getLogger(RemoteMaterialReferencesFacade.class.getName());
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager entityManager;

    public RemoteMaterialReferences findById(RemoteMaterialRefID identifier) {
        RemoteMaterialReferences result = (RemoteMaterialReferences)this.entityManager.find(RemoteMaterialReferences.class, (Object)identifier);
        return result;
    }

    public void persist(RemoteMaterialReferences materialReferences) {
        this.entityManager.persist((Object)materialReferences);
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void update(RemoteMaterialReferences materialReferences) {
        this.entityManager.merge((Object)materialReferences);
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void delete(RemoteMaterialRefID identifier) {
        RemoteMaterialReferences materialReferences = this.findById(identifier);
        if (materialReferences != null) {
            this.entityManager.remove((Object)materialReferences);
        }
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public List<RemoteMaterialReferences> findAll() {
        TypedQuery query = this.entityManager.createNamedQuery("RemoteMaterialReferences.findAll", RemoteMaterialReferences.class);
        return query.getResultList();
    }

    public void createNewMaterialReference(RemoteMaterialRefID identifier) {
        RemoteMaterialReferences ref = new RemoteMaterialReferences(identifier);
        this.entityManager.persist((Object)ref);
    }

    public RemoteMaterialReferences acquireLock(RemoteMaterialRefID identifier, String lockId) throws AcquireLockException {
        RemoteMaterialReferences ref = (RemoteMaterialReferences)this.entityManager.find(RemoteMaterialReferences.class, (Object)identifier);
        if (ref != null) {
            if (ref.getLock() && !lockId.equals(ref.getLockId())) {
                throw new AcquireLockException("Could not get lock for <" + identifier + ">");
            }
            ref.setLock(true);
            ref.setLockId(lockId);
            return (RemoteMaterialReferences)this.entityManager.merge((Object)ref);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void releaseLock(RemoteMaterialRefID identifier, String lockId) throws AcquireLockException {
        RemoteMaterialReferences ref = (RemoteMaterialReferences)this.entityManager.find(RemoteMaterialReferences.class, (Object)identifier);
        if (ref != null) {
            if (!ref.getLock() || !lockId.equals(ref.getLockId())) throw new AcquireLockException("Could not release lock. I does not belong to " + lockId);
            ref.setLock(false);
            ref.setLockId("");
            this.entityManager.merge((Object)ref);
            return;
        } else {
            LOG.log(Level.WARNING, "Tried to release lock for non-existing reference: " + identifier);
        }
    }
}

