/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.elastic;

import com.lambdista.util.FailableSupplier;
import com.lambdista.util.Try;
import io.hops.hopsworks.common.elastic.ElasticClient;
import io.hops.hopsworks.common.provenance.core.elastic.ElasticAggregation;
import io.hops.hopsworks.common.provenance.core.elastic.ElasticAggregationParser;
import io.hops.hopsworks.common.provenance.core.elastic.ElasticHelper;
import io.hops.hopsworks.common.provenance.core.elastic.ElasticHits;
import io.hops.hopsworks.exceptions.ElasticException;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.net.ssl.SSLHandshakeException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.ClearScrollResponse;
import org.elasticsearch.action.search.MultiSearchRequest;
import org.elasticsearch.action.search.MultiSearchResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.GetAliasesResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.CreateIndexResponse;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.client.indices.GetIndexResponse;
import org.elasticsearch.client.indices.GetIndexTemplatesRequest;
import org.elasticsearch.client.indices.GetIndexTemplatesResponse;
import org.elasticsearch.client.indices.GetMappingsRequest;
import org.elasticsearch.client.indices.GetMappingsResponse;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.rest.RestStatus;
import org.javatuples.Pair;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class ElasticClientController {
    private static final Logger LOG = Logger.getLogger(ElasticClientController.class.getName());
    @EJB
    private ElasticClient client;

    public GetIndexResponse mngIndexGet(GetIndexRequest request) throws ElasticException {
        FailableSupplier query = () -> this.client.getClient().indices().get(request, RequestOptions.DEFAULT);
        return (GetIndexResponse)this.executeElasticQuery(query, "elastic get index", request.toString());
    }

    public String[] mngIndicesGetBySimplifiedRegex(String regex) throws ElasticException {
        try {
            return this.mngIndexGet(new GetIndexRequest(new String[]{regex})).getIndices();
        }
        catch (ElasticException e) {
            if (ElasticHelper.indexNotFound(e.getCause())) {
                return new String[0];
            }
            throw e;
        }
    }

    public String[] mngIndicesGetByRegex(String regex) throws ElasticException {
        GetIndexResponse response = this.mngIndexGet(new GetIndexRequest(new String[]{"*"}));
        ArrayList<String> result = new ArrayList<String>();
        Pattern pattern = Pattern.compile(regex);
        for (String index : response.getIndices()) {
            if (!pattern.matcher(index).matches()) continue;
            result.add(index);
        }
        return result.toArray(new String[0]);
    }

    public <T> Map<String, T> mngIndicesGetByRegex(String regex, Function<Settings, T> indexSettingsParser) throws ElasticException {
        GetIndexResponse response = this.mngIndexGet(new GetIndexRequest(new String[]{"*"}));
        HashMap<String, T> result = new HashMap<String, T>();
        Pattern pattern = Pattern.compile(regex);
        Map settings = response.getSettings();
        for (String index : response.getIndices()) {
            if (!pattern.matcher(index).matches()) continue;
            result.put(index, indexSettingsParser.apply((Settings)settings.get(index)));
        }
        return result;
    }

    public Map<String, Map<String, String>> mngIndexGetMappings(String indexRegex) throws ElasticException {
        GetMappingsRequest request = new GetMappingsRequest().indices(new String[]{indexRegex});
        FailableSupplier query = () -> this.client.getClient().indices().getMapping(request, RequestOptions.DEFAULT);
        GetMappingsResponse response = (GetMappingsResponse)this.executeElasticQuery(query, "elastic get index mapping", request.toString());
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
        for (Map.Entry e1 : response.mappings().entrySet()) {
            String index = (String)e1.getKey();
            Map<String, String> mapping = this.parseMapping((Map)((MappingMetaData)e1.getValue()).sourceAsMap().get("properties"));
            result.put(index, mapping);
        }
        return result;
    }

    private Map<String, String> parseMapping(Map mapping) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry e1 : mapping.entrySet()) {
            String key1 = (String)e1.getKey();
            Map value = (Map)e1.getValue();
            if (value.containsKey("type")) {
                result.put(key1, (String)value.get("type"));
                continue;
            }
            if (!value.containsKey("properties")) continue;
            Map<String, String> embeddedMapping = this.parseMapping((Map)value.get("properties"));
            for (Map.Entry<String, String> e2 : embeddedMapping.entrySet()) {
                String key2 = key1 + "." + e2.getKey();
                result.put(key2, e2.getValue());
            }
        }
        return result;
    }

    public boolean mngIndexExists(String indexName) throws ElasticException {
        GetIndexRequest request = new GetIndexRequest(new String[]{indexName});
        FailableSupplier query = () -> this.client.getClient().indices().exists(request, RequestOptions.DEFAULT);
        return (Boolean)this.executeElasticQuery(query, "elastic index exists", request.toString());
    }

    public CreateIndexResponse mngIndexCreate(CreateIndexRequest request) throws ElasticException {
        if (request.index().length() > 255) {
            String msg = "elastic index name is too long:" + request.index();
            throw new ElasticException(RESTCodes.ElasticErrorCode.ELASTIC_QUERY_ERROR, Level.INFO, msg);
        }
        if (!request.index().equals(request.index().toLowerCase())) {
            String msg = "elastic index names can only contain lower case:" + request.index();
            throw new ElasticException(RESTCodes.ElasticErrorCode.ELASTIC_QUERY_ERROR, Level.INFO, msg);
        }
        FailableSupplier query = () -> this.client.getClient().indices().create(request, RequestOptions.DEFAULT);
        CreateIndexResponse response = (CreateIndexResponse)this.executeElasticQuery(query, "elastic index create", request.toString());
        if (response.isAcknowledged()) {
            return response;
        }
        String msg = "elastic index:" + request.index() + "creation could not be acknowledged";
        throw new ElasticException(RESTCodes.ElasticErrorCode.ELASTIC_QUERY_ERROR, Level.INFO, msg);
    }

    public AcknowledgedResponse mngIndexDelete(String index) throws ElasticException {
        return this.mngIndexDelete(new DeleteIndexRequest(index));
    }

    public AcknowledgedResponse mngIndexDelete(DeleteIndexRequest request) throws ElasticException {
        FailableSupplier query = () -> this.client.getClient().indices().delete(request, RequestOptions.DEFAULT);
        AcknowledgedResponse response = (AcknowledgedResponse)this.executeElasticQuery(query, "elastic index delete", request.toString());
        if (response.isAcknowledged()) {
            return response;
        }
        String msg = "elastic index:" + request.indices()[0] + "deletion could not be acknowledged";
        throw new ElasticException(RESTCodes.ElasticErrorCode.ELASTIC_QUERY_ERROR, Level.INFO, msg);
    }

    public void indexDoc(IndexRequest request) throws ElasticException {
        FailableSupplier query = () -> this.client.getClient().index(request, RequestOptions.DEFAULT);
        IndexResponse response = (IndexResponse)this.executeElasticQuery(query, "elastic index doc", request.toString());
        if (response.status().getStatus() != 201) {
            String msg = "doc index - bad status response:" + response.status().getStatus();
            throw new ElasticException(RESTCodes.ElasticErrorCode.ELASTIC_QUERY_ERROR, Level.INFO, msg);
        }
    }

    public void updateDoc(UpdateRequest request) throws ElasticException {
        FailableSupplier query = () -> this.client.getClient().update(request, RequestOptions.DEFAULT);
        UpdateResponse response = (UpdateResponse)this.executeElasticQuery(query, "elastic update doc", request.toString());
        if (response.status().getStatus() != 200) {
            String msg = "doc update - bad status response:" + response.status().getStatus();
            throw new ElasticException(RESTCodes.ElasticErrorCode.ELASTIC_QUERY_ERROR, Level.INFO, msg);
        }
    }

    public MultiSearchResponse multiSearch(MultiSearchRequest request) throws ElasticException {
        FailableSupplier query = () -> this.client.getClient().msearch(request, RequestOptions.DEFAULT);
        MultiSearchResponse response = (MultiSearchResponse)this.executeElasticQuery(query, "elastic multi search", request.toString());
        return response;
    }

    public SearchResponse baseSearch(SearchRequest request) throws ElasticException {
        FailableSupplier query = () -> this.client.getClient().search(request, RequestOptions.DEFAULT);
        SearchResponse response = (SearchResponse)this.executeElasticQuery(query, "elastic basic search", request.toString());
        if (response.status().getStatus() != 200) {
            String msg = "searchBasic query - bad status response:" + response.status().getStatus();
            throw new ElasticException(RESTCodes.ElasticErrorCode.ELASTIC_QUERY_ERROR, Level.INFO, msg);
        }
        return response;
    }

    public <R, S> Pair<Long, Try<S>> search(SearchRequest request, ElasticHits.Handler<R, S> handler) throws ElasticException {
        SearchResponse response = this.baseSearch(request);
        Try collectedResults = (Try)handler.apply(response.getHits().getHits());
        return Pair.with((Object)response.getHits().getTotalHits().value, (Object)collectedResults);
    }

    public <R, S> Pair<Long, Try<S>> scrolling(SearchResponse response, ElasticHits.Handler<R, S> handler, SearchRequest request) throws ElasticException {
        long totalHits = response.getHits().getTotalHits().value;
        long leftover = Math.min((long)request.source().size(), totalHits);
        Try result = (Try)handler.apply(response.getHits().getHits());
        if ((leftover -= (long)response.getHits().getHits().length) > 0L && response.getScrollId() == null) {
            response = this.baseSearch(request);
        }
        while (leftover > 0L && result.isSuccess()) {
            SearchScrollRequest next = this.nextScrollPage(response.getScrollId());
            response = this.searchScrollingInt(next);
            leftover -= (long)response.getHits().getHits().length;
            result = (Try)handler.apply(response.getHits().getHits());
        }
        if (response.getScrollId() != null) {
            this.clearScrollingContext(response.getScrollId());
        }
        return Pair.with((Object)totalHits, (Object)result);
    }

    public <R, S> Pair<Long, Try<S>> searchScrolling(SearchRequest request, ElasticHits.Handler<R, S> handler) throws ElasticException {
        SearchResponse response = this.baseSearch(request);
        return this.scrolling(response, handler, request);
    }

    public <O1, O2, O3> List<Pair<Long, Try<O1>>> multiSearchScrolling(MultiSearchRequest multiSearchRequest, GenericHandlerFactory<O1, O2, O3> handlerFactory) throws ElasticException {
        MultiSearchResponse multiSearchResponse = this.multiSearch(multiSearchRequest);
        ArrayList<Pair<Long, Try<O1>>> searchResult = new ArrayList<Pair<Long, Try<O1>>>();
        int index = 0;
        for (MultiSearchResponse.Item item : multiSearchResponse) {
            SearchResponse response = item.getResponse();
            SearchRequest request = (SearchRequest)multiSearchRequest.requests().get(index++);
            searchResult.add(this.scrolling(response, handlerFactory.getHandler(), request));
        }
        return searchResult;
    }

    public long searchCount(SearchRequest request) throws ElasticException {
        LOG.log(Level.FINE, "request:{0}", request.toString());
        SearchResponse response = this.baseSearch(request);
        LOG.log(Level.FINE, "response:{0}", response.toString());
        return response.getHits().getTotalHits().value;
    }

    public <A extends ElasticAggregation, E extends Exception> Map<A, List> searchAggregations(SearchRequest request, Map<A, ElasticAggregationParser<?, E>> aggregations) throws ElasticException, E {
        SearchResponse response = this.baseSearch(request);
        LOG.log(Level.FINE, "response:{0}", response.toString());
        HashMap aggResults = new HashMap();
        if (!aggregations.isEmpty()) {
            for (Map.Entry<A, ElasticAggregationParser<?, E>> aggregation : aggregations.entrySet()) {
                aggResults.put(aggregation.getKey(), aggregation.getValue().apply(response.getAggregations()));
            }
        }
        return aggResults;
    }

    SearchResponse searchScrollingInt(SearchScrollRequest request) throws ElasticException {
        FailableSupplier query = () -> this.client.getClient().scroll(request, RequestOptions.DEFAULT);
        SearchResponse response = (SearchResponse)this.executeElasticQuery(query, "elastic scrolling search", request.toString());
        if (response.status().getStatus() != 200) {
            String msg = "searchBasic query - bad status response:" + response.status().getStatus();
            throw new ElasticException(RESTCodes.ElasticErrorCode.ELASTIC_QUERY_ERROR, Level.INFO, msg);
        }
        return response;
    }

    private SearchScrollRequest nextScrollPage(String scrollId) {
        SearchScrollRequest ssr = new SearchScrollRequest(scrollId);
        ssr.scroll(TimeValue.timeValueMinutes((long)1L));
        return ssr;
    }

    ClearScrollResponse clearScrollingContext(String scrollId) throws ElasticException {
        ClearScrollRequest request = new ClearScrollRequest();
        request.addScrollId(scrollId);
        FailableSupplier query = () -> this.client.getClient().clearScroll(request, RequestOptions.DEFAULT);
        ClearScrollResponse response = (ClearScrollResponse)this.executeElasticQuery(query, "elastic scrolling search", request.toString());
        if (response.status().getStatus() != 200) {
            String msg = "scroll context clearing query - bad status response:" + response.status().getStatus();
            throw new ElasticException(RESTCodes.ElasticErrorCode.ELASTIC_QUERY_ERROR, Level.INFO, msg);
        }
        return response;
    }

    public void bulkDelete(BulkRequest request) throws ElasticException {
        FailableSupplier query = () -> this.client.getClient().bulk(request, RequestOptions.DEFAULT);
        BulkResponse response = (BulkResponse)this.executeElasticQuery(query, "elastic bulk delete", request.toString());
        if (response.hasFailures()) {
            String msg = "failures during bulk delete";
            throw new ElasticException(RESTCodes.ElasticErrorCode.ELASTIC_QUERY_ERROR, Level.INFO, msg);
        }
    }

    public BulkResponse bulkUpdateDoc(BulkRequest request) throws ElasticException {
        FailableSupplier query = () -> this.client.getClient().bulk(request, RequestOptions.DEFAULT);
        BulkResponse response = (BulkResponse)this.executeElasticQuery(query, "elastic bulk update doc", request.toString());
        if (response.status().getStatus() != 200) {
            String msg = "doc update - bad status response:" + response.status().getStatus();
            throw new ElasticException(RESTCodes.ElasticErrorCode.ELASTIC_QUERY_ERROR, Level.INFO, msg);
        }
        return response;
    }

    public AcknowledgedResponse aliasUpdate(IndicesAliasesRequest request) throws ElasticException {
        FailableSupplier query = () -> this.client.getClient().indices().updateAliases(request, RequestOptions.DEFAULT);
        AcknowledgedResponse response = (AcknowledgedResponse)this.executeElasticQuery(query, "elastic alias update", request.toString());
        if (response.isAcknowledged()) {
            return response;
        }
        throw new ElasticException(RESTCodes.ElasticErrorCode.ELASTIC_INTERNAL_REQ_ERROR, Level.INFO, "error during elastic alias update");
    }

    public AcknowledgedResponse aliasSwitchIndex(String alias, String fromIndex, String toIndex) throws ElasticException {
        IndicesAliasesRequest request = new IndicesAliasesRequest().addAliasAction(new IndicesAliasesRequest.AliasActions(IndicesAliasesRequest.AliasActions.Type.REMOVE).index(fromIndex).alias(alias)).addAliasAction(new IndicesAliasesRequest.AliasActions(IndicesAliasesRequest.AliasActions.Type.ADD).index(toIndex).alias(alias));
        return this.aliasUpdate(request);
    }

    public GetAliasesResponse aliasGet(GetAliasesRequest request) throws ElasticException {
        FailableSupplier query = () -> this.client.getClient().indices().getAlias(request, RequestOptions.DEFAULT);
        GetAliasesResponse response = (GetAliasesResponse)this.executeElasticQuery(query, "elastic get alias", request.toString());
        if (response.status().equals((Object)RestStatus.OK) || response.status().equals((Object)RestStatus.NOT_FOUND)) {
            return response;
        }
        throw new ElasticException(RESTCodes.ElasticErrorCode.ELASTIC_QUERY_ERROR, Level.INFO, "error during elastic get alias");
    }

    public GetAliasesResponse getAliases(String alias) throws ElasticException {
        GetAliasesRequest request = new GetAliasesRequest().aliases(new String[]{alias});
        return this.aliasGet(request);
    }

    public AcknowledgedResponse createAlias(String alias, String index) throws ElasticException {
        IndicesAliasesRequest request = new IndicesAliasesRequest().addAliasAction(new IndicesAliasesRequest.AliasActions(IndicesAliasesRequest.AliasActions.Type.ADD).index(index).alias(alias));
        return this.aliasUpdate(request);
    }

    public ClusterHealthResponse clusterHealthGet() throws ElasticException {
        ClusterHealthRequest request = new ClusterHealthRequest();
        FailableSupplier query = () -> this.client.getClient().cluster().health(request, RequestOptions.DEFAULT);
        ClusterHealthResponse response = (ClusterHealthResponse)this.executeElasticQuery(query, "elastic get cluster health", request.toString());
        if (response.status().equals((Object)RestStatus.OK) || response.status().equals((Object)RestStatus.NOT_FOUND)) {
            return response;
        }
        throw new ElasticException(RESTCodes.ElasticErrorCode.ELASTIC_QUERY_ERROR, Level.INFO, "error during elastic get cluster health");
    }

    public GetIndexTemplatesResponse templateGet(String template) throws ElasticException {
        GetIndexTemplatesRequest request = new GetIndexTemplatesRequest(new String[]{template});
        FailableSupplier query = () -> this.client.getClient().indices().getIndexTemplate(request, RequestOptions.DEFAULT);
        return (GetIndexTemplatesResponse)this.executeElasticQuery(query, "elastic get template", request.toString());
    }

    private <O> O executeElasticQuery(FailableSupplier<O> query, String usrMsg, String devMsg) throws ElasticException {
        try {
            try {
                LOG.log(Level.FINE, "{0}:{1}", new Object[]{usrMsg, devMsg});
                return (O)query.get();
            }
            catch (SSLHandshakeException e) {
                this.client.resetClient();
                return (O)query.get();
            }
        }
        catch (IndexNotFoundException e) {
            throw new ElasticException(RESTCodes.ElasticErrorCode.ELASTIC_INDEX_NOT_FOUND, Level.INFO, "elastic index not found during " + usrMsg, devMsg, (Throwable)e);
        }
        catch (ElasticsearchStatusException e) {
            if (e.status().equals((Object)RestStatus.NOT_FOUND)) {
                throw new ElasticException(RESTCodes.ElasticErrorCode.ELASTIC_INDEX_NOT_FOUND, Level.INFO, "elastic index not found during " + usrMsg, devMsg, (Throwable)e);
            }
            throw new ElasticException(RESTCodes.ElasticErrorCode.ELASTIC_INTERNAL_REQ_ERROR, Level.WARNING, "error during " + usrMsg, devMsg, (Throwable)e);
        }
        catch (Throwable e) {
            throw new ElasticException(RESTCodes.ElasticErrorCode.ELASTIC_INTERNAL_REQ_ERROR, Level.WARNING, "error during " + usrMsg, devMsg, e);
        }
    }

    public static interface GenericHandlerFactory<O1, O2, O3> {
        public ElasticHits.Handler<O3, O1> getHandler();

        public O2 checkedResult(Try<O1> var1) throws Exception;
    }
}

