/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.datavalidation;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.Featuregroup;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.datavalidation.FeatureGroupExpectation;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.datavalidation.FeatureStoreExpectation;
import java.util.Optional;
import java.util.Set;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;

@Stateless
public class FeatureGroupExpectationFacade
extends AbstractFacade<FeatureGroupExpectation> {
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    public FeatureGroupExpectationFacade() {
        super(FeatureGroupExpectation.class);
    }

    @Override
    protected EntityManager getEntityManager() {
        return this.em;
    }

    public FeatureGroupExpectation merge(FeatureGroupExpectation featureGroupExpectation) {
        featureGroupExpectation = (FeatureGroupExpectation)this.em.merge((Object)featureGroupExpectation);
        this.em.flush();
        return featureGroupExpectation;
    }

    public FeatureGroupExpectation findById(int id) {
        return (FeatureGroupExpectation)this.em.find(FeatureGroupExpectation.class, (Object)id);
    }

    public Optional<FeatureGroupExpectation> findByFeaturegroupAndExpectation(Featuregroup featuregroup, FeatureStoreExpectation expectation) {
        try {
            TypedQuery query = this.em.createNamedQuery("FeatureGroupExpectation.findByFeatureGroupAndExpectation", FeatureGroupExpectation.class).setParameter("featuregroup", (Object)featuregroup).setParameter("featureStoreExpectation", (Object)expectation);
            return Optional.of(query.getSingleResult());
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }

    public AbstractFacade.CollectionInfo findByFeaturegroup(Integer offset, Integer limit, Set<? extends AbstractFacade.FilterBy> filter, Set<? extends AbstractFacade.SortBy> sort, Featuregroup featuregroup) {
        String queryStr = this.buildQuery("SELECT fge FROM FeatureGroupExpectation fge ", filter, sort, "fge.featuregroup = :featuregroup ");
        String queryCountStr = this.buildQuery("SELECT COUNT(fge.id) FROM FeatureGroupExpectation fge ", filter, sort, "fge.featuregroup = :featuregroup ");
        TypedQuery query = this.em.createQuery(queryStr, FeatureGroupExpectation.class).setParameter("featuregroup", (Object)featuregroup);
        TypedQuery queryCount = this.em.createQuery(queryCountStr, FeatureGroupExpectation.class).setParameter("featuregroup", (Object)featuregroup);
        return this.findAll(offset, limit, filter, (Query)query, (Query)queryCount);
    }

    private AbstractFacade.CollectionInfo findAll(Integer offset, Integer limit, Set<? extends AbstractFacade.FilterBy> filter, Query query, Query queryCount) {
        this.setOffsetAndLim(offset, limit, query);
        return new AbstractFacade.CollectionInfo((Long)queryCount.getSingleResult(), query.getResultList());
    }

    public static enum Filters {
        NAME("NAME", "fge.featureStoreExpectation.name = :name ", "name", "");

        private final String value;
        private final String sql;
        private final String field;
        private final String defaultParam;

        private Filters(String value, String sql, String field, String defaultParam) {
            this.value = value;
            this.sql = sql;
            this.field = field;
            this.defaultParam = defaultParam;
        }

        public String getValue() {
            return this.value;
        }

        public String getDefaultParam() {
            return this.defaultParam;
        }

        public String getSql() {
            return this.sql;
        }

        public String getField() {
            return this.field;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Sorts {
        NAME("NAME", "fge.featureStoreExpectation.name ", "ASC");

        private final String value;
        private final String sql;
        private final String defaultParam;

        private Sorts(String value, String sql, String defaultParam) {
            this.value = value;
            this.sql = sql;
            this.defaultParam = defaultParam;
        }

        public String getValue() {
            return this.value;
        }

        public String getDefaultParam() {
            return this.defaultParam;
        }

        public String getSql() {
            return this.sql;
        }

        public String toString() {
            return this.value;
        }
    }
}

