/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.storageconnectors.snowflake;

import com.google.common.base.Strings;
import io.hops.hopsworks.common.dao.user.UserFacade;
import io.hops.hopsworks.common.featurestore.OptionDTO;
import io.hops.hopsworks.common.featurestore.storageconnectors.snowflake.FeaturestoreSnowflakeConnectorDTO;
import io.hops.hopsworks.common.security.secrets.SecretsController;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.exceptions.ProjectException;
import io.hops.hopsworks.exceptions.ServiceException;
import io.hops.hopsworks.exceptions.UserException;
import io.hops.hopsworks.persistence.entity.featurestore.Featurestore;
import io.hops.hopsworks.persistence.entity.featurestore.storageconnector.FeaturestoreConnector;
import io.hops.hopsworks.persistence.entity.featurestore.storageconnector.snowflake.FeaturestoreSnowflakeConnector;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.persistence.entity.user.security.secrets.Secret;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.transaction.Transactional;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class FeaturestoreSnowflakeConnectorController {
    private static final Logger LOGGER = Logger.getLogger(FeaturestoreSnowflakeConnectorController.class.getName());
    @EJB
    private SecretsController secretsController;
    @EJB
    private UserFacade userFacade;

    public FeaturestoreSnowflakeConnectorDTO getConnector(Users user, FeaturestoreConnector featurestoreConnector) {
        FeaturestoreSnowflakeConnectorDTO snowflakeConnectorDTO = new FeaturestoreSnowflakeConnectorDTO(featurestoreConnector);
        snowflakeConnectorDTO.setSfOptions(this.toOptions(featurestoreConnector.getSnowflakeConnector().getArguments()));
        snowflakeConnectorDTO.setPassword(this.getSecret(user, featurestoreConnector.getSnowflakeConnector().getPwdSecret()));
        snowflakeConnectorDTO.setToken(this.getSecret(user, featurestoreConnector.getSnowflakeConnector().getTokenSecret()));
        return snowflakeConnectorDTO;
    }

    public FeaturestoreSnowflakeConnector createConnector(Users user, Featurestore featurestore, FeaturestoreSnowflakeConnectorDTO featurestoreSnowflakeConnectorDTO) throws FeaturestoreException, UserException, ProjectException {
        this.verifyConnectorDTO(featurestoreSnowflakeConnectorDTO);
        Secret secret = this.createSecret(user, featurestore, featurestoreSnowflakeConnectorDTO);
        FeaturestoreSnowflakeConnector snowflakeConnector = new FeaturestoreSnowflakeConnector();
        this.setConnector(snowflakeConnector, secret, featurestoreSnowflakeConnectorDTO);
        return snowflakeConnector;
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    @Transactional(rollbackOn={FeaturestoreException.class})
    public FeaturestoreSnowflakeConnector updateConnector(Users user, FeaturestoreSnowflakeConnectorDTO featurestoreSnowflakeConnectorDTO, FeaturestoreSnowflakeConnector snowflakeConnector) throws FeaturestoreException, UserException, ProjectException {
        this.verifyConnectorDTO(featurestoreSnowflakeConnectorDTO);
        Secret secret = this.updateSecret(user, featurestoreSnowflakeConnectorDTO, snowflakeConnector);
        this.setConnector(snowflakeConnector, secret, featurestoreSnowflakeConnectorDTO);
        return snowflakeConnector;
    }

    private void setConnector(FeaturestoreSnowflakeConnector snowflakeConnector, Secret secret, FeaturestoreSnowflakeConnectorDTO featurestoreSnowflakeConnectorDTO) {
        snowflakeConnector.setUrl(this.getValueOrNull(featurestoreSnowflakeConnectorDTO.getUrl()));
        snowflakeConnector.setDatabaseUser(this.getValueOrNull(featurestoreSnowflakeConnectorDTO.getUser()));
        snowflakeConnector.setDatabaseName(this.getValueOrNull(featurestoreSnowflakeConnectorDTO.getDatabase()));
        snowflakeConnector.setDatabaseSchema(this.getValueOrNull(featurestoreSnowflakeConnectorDTO.getSchema()));
        snowflakeConnector.setTableName(this.getValueOrNull(featurestoreSnowflakeConnectorDTO.getTable()));
        snowflakeConnector.setRole(this.getValueOrNull(featurestoreSnowflakeConnectorDTO.getRole()));
        snowflakeConnector.setWarehouse(this.getValueOrNull(featurestoreSnowflakeConnectorDTO.getWarehouse()));
        snowflakeConnector.setArguments(this.fromOptions(featurestoreSnowflakeConnectorDTO.getSfOptions()));
        snowflakeConnector.setApplication(featurestoreSnowflakeConnectorDTO.getApplication());
        if (!Strings.isNullOrEmpty((String)featurestoreSnowflakeConnectorDTO.getPassword())) {
            snowflakeConnector.setPwdSecret(secret);
            snowflakeConnector.setTokenSecret(null);
        } else {
            snowflakeConnector.setTokenSecret(secret);
            snowflakeConnector.setPwdSecret(null);
        }
    }

    private boolean isNullOrWhitespace(String val) {
        return Strings.isNullOrEmpty((String)val) || Strings.isNullOrEmpty((String)val.trim());
    }

    private String getValueOrNull(String val) {
        return this.isNullOrWhitespace(val) ? null : val.trim();
    }

    private List<OptionDTO> toOptions(String arguments) {
        if (Strings.isNullOrEmpty((String)arguments)) {
            return null;
        }
        return Arrays.stream(arguments.split(";")).map(arg -> arg.split("=")).map(a -> new OptionDTO(a[0], a[1])).collect(Collectors.toList());
    }

    private String fromOptions(List<OptionDTO> options) {
        if (options == null || options.isEmpty()) {
            return null;
        }
        StringBuilder arguments = new StringBuilder();
        for (OptionDTO option : options) {
            arguments.append(arguments.length() > 0 ? ";" : "").append(option.getName()).append("=").append(option.getValue());
        }
        return arguments.toString();
    }

    private Secret getSecret(FeaturestoreSnowflakeConnector snowflakeConnector) {
        if (snowflakeConnector.getPwdSecret() != null) {
            return snowflakeConnector.getPwdSecret();
        }
        return snowflakeConnector.getTokenSecret();
    }

    private String getSecret(Users user, Secret secret) {
        if (secret != null) {
            try {
                Users owner = (Users)this.userFacade.find(secret.getId().getUid());
                return this.secretsController.getShared(user, owner, secret.getId().getName()).getPlaintext();
            }
            catch (ProjectException | ServiceException | UserException throwable) {
                // empty catch block
            }
        }
        return null;
    }

    private String createSecretName(Integer featurestoreId, String connectorName) {
        return "snowflake_" + connectorName.replaceAll(" ", "_").toLowerCase() + "_" + featurestoreId;
    }

    private Secret createSecret(Users user, Featurestore featurestore, FeaturestoreSnowflakeConnectorDTO featurestoreSnowflakeConnectorDTO) throws ProjectException, UserException {
        String secretName = this.createSecretName(featurestore.getId(), featurestoreSnowflakeConnectorDTO.getName());
        Secret secret = !Strings.isNullOrEmpty((String)featurestoreSnowflakeConnectorDTO.getPassword()) ? this.secretsController.createSecretForProject(user, secretName, featurestoreSnowflakeConnectorDTO.getPassword(), featurestore.getProject().getId()) : this.secretsController.createSecretForProject(user, secretName, featurestoreSnowflakeConnectorDTO.getToken(), featurestore.getProject().getId());
        return secret;
    }

    private Secret updateSecret(Users user, FeaturestoreSnowflakeConnectorDTO featurestoreSnowflakeConnectorDTO, FeaturestoreSnowflakeConnector snowflakeConnector) throws UserException, ProjectException {
        Secret existingSecret = this.getSecret(snowflakeConnector);
        this.secretsController.checkCanAccessSecret(existingSecret, user);
        String secret = !Strings.isNullOrEmpty((String)featurestoreSnowflakeConnectorDTO.getPassword()) ? featurestoreSnowflakeConnectorDTO.getPassword() : featurestoreSnowflakeConnectorDTO.getToken();
        try {
            existingSecret.setSecret(this.secretsController.encryptSecret(secret));
        }
        catch (IOException | GeneralSecurityException e) {
            throw new UserException(RESTCodes.UserErrorCode.SECRET_ENCRYPTION_ERROR, Level.SEVERE, "Error encrypting secret", "Could not encrypt Secret " + existingSecret.getId().getName(), (Throwable)e);
        }
        return existingSecret;
    }

    private void verifyConnectorDTO(FeaturestoreSnowflakeConnectorDTO featurestoreSnowflakeConnectorDTO) throws FeaturestoreException {
        if (featurestoreSnowflakeConnectorDTO == null) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STORAGE_CONNECTOR_ARG, Level.FINE, "Null input data");
        }
        if (this.isNullOrWhitespace(featurestoreSnowflakeConnectorDTO.getUrl())) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STORAGE_CONNECTOR_ARG, Level.FINE, "Url can not be empty");
        }
        if (this.isNullOrWhitespace(featurestoreSnowflakeConnectorDTO.getUser())) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STORAGE_CONNECTOR_ARG, Level.FINE, "User can not be empty");
        }
        if (this.isNullOrWhitespace(featurestoreSnowflakeConnectorDTO.getSchema())) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STORAGE_CONNECTOR_ARG, Level.FINE, "Schema can not be empty");
        }
        if (this.isNullOrWhitespace(featurestoreSnowflakeConnectorDTO.getDatabase())) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STORAGE_CONNECTOR_ARG, Level.FINE, "Database can not be empty");
        }
        if (Strings.isNullOrEmpty((String)featurestoreSnowflakeConnectorDTO.getPassword()) && Strings.isNullOrEmpty((String)featurestoreSnowflakeConnectorDTO.getToken())) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STORAGE_CONNECTOR_ARG, Level.FINE, "Password or OAuth token must be set");
        }
        if (!Strings.isNullOrEmpty((String)featurestoreSnowflakeConnectorDTO.getPassword()) && !Strings.isNullOrEmpty((String)featurestoreSnowflakeConnectorDTO.getToken())) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STORAGE_CONNECTOR_ARG, Level.FINE, "Only one authentication method is allowed");
        }
    }
}

