/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.elastic;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.annotation.XmlRootElement;
import org.elasticsearch.search.SearchHit;

@XmlRootElement
public class ElasticHit
implements Comparator<ElasticHit> {
    private static final Logger LOG = Logger.getLogger(ElasticHit.class.getName());
    private String id;
    private String name;
    private String description;
    private String publicId;
    private String type;
    private boolean localDataset;
    private boolean public_ds;
    private float score;
    private Map<String, Object> map;

    public ElasticHit() {
    }

    public ElasticHit(SearchHit hit) {
        this.map = hit.getSourceAsMap();
        this.score = hit.getScore();
        for (Map.Entry<String, Object> entry : this.map.entrySet()) {
            if (entry.getKey().equals("name")) {
                this.name = entry.getValue().toString();
                continue;
            }
            if (entry.getKey().equals("description")) {
                this.description = entry.getValue().toString();
                continue;
            }
            if (entry.getKey().equals("public_ds")) {
                this.public_ds = Boolean.valueOf(entry.getValue().toString());
                continue;
            }
            if (!entry.getKey().equals("doc_type")) continue;
            this.type = entry.getValue().toString();
            if (this.type.equals("inode") || this.type.equals("ds") || this.type.equals("proj")) continue;
            LOG.log(Level.WARNING, "Got a wrong document type [{0}] was expecting one of these types [{1}, {2}, {3}]", new Object[]{this.type, "inode", "ds", "proj"});
        }
        this.id = this.type.equals("proj") ? this.map.get("project_id").toString() : hit.getId();
    }

    public boolean isPublic_ds() {
        return this.public_ds;
    }

    public void setPublic_ds(boolean public_ds) {
        this.public_ds = public_ds;
    }

    public boolean isLocalDataset() {
        return this.localDataset;
    }

    public void setLocalDataset(boolean localDataset) {
        this.localDataset = localDataset;
    }

    public String getPublicId() {
        return this.publicId;
    }

    public void setPublicId(String publicId) {
        this.publicId = publicId;
    }

    public float getScore() {
        return this.score;
    }

    public void setScore(float score) {
        this.score = score;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void setMap(Map<String, Object> source) {
        this.map = new HashMap<String, Object>(source);
    }

    public Map<String, String> getMap() {
        HashMap<String, String> refined = new HashMap<String, String>();
        if (this.map != null) {
            for (Map.Entry<String, Object> entry : this.map.entrySet()) {
                String value = entry.getValue() == null ? "null" : entry.getValue().toString();
                refined.put(entry.getKey(), value);
            }
        }
        return refined;
    }

    @Override
    public int compare(ElasticHit o1, ElasticHit o2) {
        return Float.compare(o2.getScore(), o1.getScore());
    }
}

