/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.jobs;

import io.hops.hopsworks.common.dao.certificates.CertsFacade;
import io.hops.hopsworks.common.dao.hdfs.inode.InodeFacade;
import io.hops.hopsworks.common.dao.jobhistory.ExecutionFacade;
import io.hops.hopsworks.common.hdfs.DistributedFileSystemOps;
import io.hops.hopsworks.common.hdfs.DistributedFsService;
import io.hops.hopsworks.common.jobs.execution.HopsJob;
import io.hops.hopsworks.common.jobs.yarn.YarnExecutionFinalizer;
import io.hops.hopsworks.common.security.BaseHadoopClientsService;
import io.hops.hopsworks.common.security.CertificateMaterializer;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.common.yarn.YarnClientService;
import javax.ejb.Asynchronous;
import javax.ejb.EJB;
import javax.ejb.LocalBean;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

@Stateless
@LocalBean
public class AsynchronousJobExecutor {
    @EJB
    private ExecutionFacade executionFacade;
    @EJB
    private DistributedFsService dfs;
    @EJB
    private InodeFacade inodeFacade;
    @EJB
    private CertsFacade userCerts;
    @EJB
    private Settings settings;
    @EJB
    private YarnExecutionFinalizer yarnExecutionFinalizer;
    @EJB
    private YarnClientService yarnClientService;
    @EJB
    private CertificateMaterializer certificateMaterializer;
    @EJB
    private BaseHadoopClientsService baseHadoopClientsService;

    @Asynchronous
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void startExecution(HopsJob job) {
        this.startExecution(job, null);
    }

    @Asynchronous
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void startExecution(HopsJob job, String args) {
        job.execute(args);
    }

    public ExecutionFacade getExecutionFacade() {
        return this.executionFacade;
    }

    public YarnExecutionFinalizer getYarnExecutionFinalizer() {
        return this.yarnExecutionFinalizer;
    }

    public DistributedFsService getFsService() {
        return this.dfs;
    }

    public InodeFacade getInodeFacade() {
        return this.inodeFacade;
    }

    public YarnClientService getYarnClientService() {
        return this.yarnClientService;
    }

    public DistributedFileSystemOps getFileOperations(String hdfsUser) {
        return this.dfs.getDfsOps(hdfsUser);
    }

    public CertsFacade getUserCerts() {
        return this.userCerts;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public CertificateMaterializer getCertificateMaterializer() {
        return this.certificateMaterializer;
    }

    public BaseHadoopClientsService getBaseHadoopClientsService() {
        return this.baseHadoopClientsService;
    }
}

