/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.util;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.Writer;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import javax.imageio.ImageIO;

public class QRCodeGenerator {
    private final int width = 200;
    private final int height = 200;
    private final String qrURL;
    private final Writer qrw;

    private QRCodeGenerator(String qrURL) {
        this.qrURL = qrURL;
        this.qrw = new QRCodeWriter();
    }

    public static QRCodeGenerator qrCodeURLFormat(String qrURL) {
        return new QRCodeGenerator(qrURL);
    }

    public ByteArrayOutputStream qrcodeStream() throws IOException, WriterException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        this.writeToStream(stream);
        return stream;
    }

    private BitMatrix generateMatrix() throws WriterException {
        return this.qrw.encode(this.qrURL, BarcodeFormat.QR_CODE, 200, 200);
    }

    private void writeToStream(OutputStream stream) throws IOException, WriterException {
        MatrixToImageWriter.writeToStream((BitMatrix)this.generateMatrix(), (String)"PNG", (OutputStream)stream);
    }

    public static ByteArrayInputStream getQRCode(String user, String host, String secret) throws UnsupportedEncodingException, IOException, WriterException {
        String chl = "otpauth://totp/" + user + "?secret=" + secret + "&issuer=" + host;
        ByteArrayOutputStream stream = QRCodeGenerator.qrCodeURLFormat(chl).qrcodeStream();
        BufferedImage bufferedImg = new BufferedImage(100, 25, 1);
        Graphics2D g2 = bufferedImg.createGraphics();
        ImageIO.write((RenderedImage)bufferedImg, "png", stream);
        return new ByteArrayInputStream(stream.toByteArray());
    }

    public static byte[] getQRCodeBytes(String user, String host, String secret) throws UnsupportedEncodingException, IOException, WriterException {
        String chl = "otpauth://totp/" + user + "?secret=" + secret + "&issuer=" + host;
        ByteArrayOutputStream stream = QRCodeGenerator.qrCodeURLFormat(chl).qrcodeStream();
        BufferedImage bufferedImg = new BufferedImage(100, 25, 1);
        Graphics2D g2 = bufferedImg.createGraphics();
        ImageIO.write((RenderedImage)bufferedImg, "png", stream);
        return stream.toByteArray();
    }
}

