/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;

public class StreamGobbler
implements Runnable {
    private static final int KB = 1024;
    private final InputStream in;
    private final OutputStream out;
    private final byte[] buffer;
    private final boolean ignoreStream;

    public StreamGobbler(InputStream in, OutputStream out, boolean ignoreStream) {
        this.in = in;
        this.out = out;
        this.ignoreStream = ignoreStream;
        this.buffer = new byte[4096];
    }

    @Override
    public void run() {
        int bytesRead = 0;
        try (BufferedInputStream bis = new BufferedInputStream(this.in);){
            while ((bytesRead = bis.read(this.buffer)) != -1) {
                if (this.ignoreStream) continue;
                this.out.write(this.buffer, 0, bytesRead);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace(new PrintStream(this.out));
        }
    }
}

