/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.provenance.ops;

import io.hops.hopsworks.common.provenance.core.ProvParser;
import io.hops.hopsworks.common.provenance.ops.ProvOps;
import io.hops.hopsworks.exceptions.ProvenanceException;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.javatuples.Pair;

public class ProvLinks {
    private static <R> R onlyAllowed() throws ProvenanceException {
        String msg = "allowed fields:" + EnumSet.allOf(FieldsPF.class);
        throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.BAD_REQUEST, Level.INFO, msg);
    }

    public static Field extractField(String val) throws ProvenanceException {
        try {
            return FieldsPF.valueOf(val.toUpperCase());
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            return (Field)ProvLinks.onlyAllowed();
        }
    }

    public static Pair<Field, Object> extractFilter(String param) throws ProvenanceException {
        String rawVal;
        String rawFilter;
        if (param.contains(":")) {
            int aux = param.indexOf(58);
            rawFilter = param.substring(0, aux);
            rawVal = param.substring(aux + 1);
        } else {
            rawFilter = param;
            rawVal = "true";
        }
        Field field = ProvLinks.extractField(rawFilter);
        Object val = field.filterValParser().apply(rawVal);
        return Pair.with((Object)field, val);
    }

    public static void filterBySanityCheck(Map<ProvParser.Field, ProvParser.FilterVal> filterBy, Field newField) throws ProvenanceException {
        ProvLinks.extractField(newField.queryFieldName());
        if (filterBy.containsKey(FieldsPF.IN_ARTIFACT) && newField.equals(FieldsPF.OUT_ARTIFACT) || filterBy.containsKey(FieldsPF.OUT_ARTIFACT) && newField.equals(FieldsPF.IN_ARTIFACT)) {
            throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.BAD_REQUEST, Level.INFO, "filterBy does not support both IN_ARTIFACT and OUT_ARTIFACT at the same time", "exception extracting <full prov links> filterBy params");
        }
    }

    public static class MLLinksTypeValParser
    implements ProvParser.ValParser<List<String>> {
        @Override
        public List<String> apply(Object o) throws ProvenanceException {
            try {
                if (o instanceof String) {
                    ProvParser.DocSubType val = ProvParser.DocSubType.valueOf((String)o);
                    ArrayList<String> result = new ArrayList<String>();
                    switch (val) {
                        case FEATURE: 
                        case TRAINING_DATASET: 
                        case MODEL: 
                        case EXPERIMENT: {
                            result.add(val.toString().toUpperCase());
                            result.add(val.getPart().toString().toUpperCase());
                            return result;
                        }
                    }
                    String msg = "supports only:" + EnumSet.of(ProvParser.DocSubType.FEATURE, ProvParser.DocSubType.TRAINING_DATASET, ProvParser.DocSubType.MODEL, ProvParser.DocSubType.EXPERIMENT);
                    throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.BAD_REQUEST, Level.INFO, msg);
                }
                String msg = "expected string-ified version of MLType found " + o.getClass();
                throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.BAD_REQUEST, Level.INFO, msg);
            }
            catch (IllegalArgumentException | NullPointerException e) {
                String msg = "expected string-ified version of MLType found " + o.getClass();
                throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.BAD_REQUEST, Level.INFO, msg, msg, (Throwable)e);
            }
        }
    }

    public static enum FieldsPF implements Field
    {
        APP_ID(ProvOps.FieldsP.APP_ID, ProvParser.FilterType.EXACT),
        IN_ARTIFACT(ProvOps.FieldsP.ML_ID, ProvParser.FilterType.EXACT),
        IN_TYPE(IntFieldsP.ML_TYPE, ProvParser.FilterType.EXACT),
        OUT_ARTIFACT(ProvOps.FieldsP.ML_ID, ProvParser.FilterType.EXACT),
        OUT_TYPE(IntFieldsP.ML_TYPE, ProvParser.FilterType.EXACT),
        ARTIFACT(ProvOps.FieldsP.ML_ID, ProvParser.FilterType.EXACT),
        ARTIFACT_TYPE(IntFieldsP.ML_TYPE, ProvParser.FilterType.EXACT),
        ONLY_APPS(ProvOps.FieldsP.APP_ID, ProvParser.FilterType.NOT);

        ProvParser.Field base;
        ProvParser.FilterType filterType;

        private FieldsPF(ProvParser.Field base, ProvParser.FilterType filterType) {
            this.base = base;
            this.filterType = filterType;
        }

        @Override
        public String elasticFieldName() {
            return this.base.elasticFieldName();
        }

        @Override
        public String queryFieldName() {
            return this.name().toLowerCase();
        }

        @Override
        public ProvParser.FilterType filterType() {
            return this.filterType;
        }

        @Override
        public ProvParser.ValParser<?> filterValParser() {
            return this.base.filterValParser();
        }
    }

    private static enum IntFieldsP implements Field
    {
        ML_TYPE(ProvParser.Fields.ML_TYPE, new MLLinksTypeValParser());

        ProvParser.ElasticField elasticField;
        ProvParser.ValParser valParser;

        private IntFieldsP(ProvParser.ElasticField elasticField, ProvParser.ValParser valParser) {
            this.elasticField = elasticField;
            this.valParser = valParser;
        }

        @Override
        public String elasticFieldName() {
            return this.elasticField.toString().toLowerCase();
        }

        @Override
        public String queryFieldName() {
            return this.name().toLowerCase();
        }

        @Override
        public ProvParser.FilterType filterType() {
            return ProvParser.FilterType.EXACT;
        }

        public ProvParser.ValParser filterValParser() {
            return this.valParser;
        }
    }

    public static interface Field
    extends ProvParser.Field {
    }
}

