/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.elastic;

import io.hops.hopsworks.common.elastic.ElasticClientController;
import java.util.Map;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Schedule;
import javax.ejb.Singleton;
import javax.ejb.Timer;
import org.elasticsearch.common.settings.Settings;

@Singleton
public class ElasticCleaner {
    private static final Logger LOGGER = Logger.getLogger(ElasticCleaner.class.getName());
    @EJB
    ElasticClientController elasticClientCtrl;
    @EJB
    io.hops.hopsworks.common.util.Settings settings;

    @Schedule(persistent=false, minute="0", hour="1")
    public void deleteLogIndices(Timer timer) {
        LOGGER.log(Level.INFO, "Running ElasticCleaner.");
        try {
            Function<Settings, Long> creationTimeParser = settings -> {
                try {
                    return Long.parseLong(settings.get("index.creation_date"));
                }
                catch (NullPointerException | NumberFormatException e) {
                    return -1L;
                }
            };
            String indexRegex = "(.*_logs-\\d{4}.\\d{2}.\\d{2})|(.*_serving-\\d{4}.\\d{2}.\\d{2})|(.services-\\d{4}.\\d{2}.\\d{2})";
            Map<String, Long> indices = this.elasticClientCtrl.mngIndicesGetByRegex(indexRegex, creationTimeParser);
            for (String index : indices.keySet()) {
                long indexCreationTime;
                long currentTime = System.currentTimeMillis();
                if (currentTime - (indexCreationTime = indices.get(index).longValue()) <= this.settings.getElasticLogsIndexExpiration()) continue;
                this.elasticClientCtrl.mngIndexDelete(index);
                LOGGER.log(Level.INFO, "Deletedindex:{0}", index);
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Index deletion failed", ex);
        }
    }
}

