/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.provenance.core.elastic;

import com.lambdista.util.Try;
import io.hops.hopsworks.common.provenance.core.elastic.ElasticHitsHandlerImpl;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.elasticsearch.search.SearchHit;

public class ElasticHits {
    public static <R, S> Handler<R, S> handlerBasic(Parser<R> parser, S state, Merger<R, S> stateMerger) {
        return new ElasticHitsHandlerImpl<R, S>(parser, state, stateMerger);
    }

    public static <R> Handler<R, List<R>> handlerAddToList(Parser<R> parser) {
        ListMerger simpleListAcc = (item, s) -> {
            s.add(item);
            return Try.apply(() -> s);
        };
        return new ElasticHitsHandlerImpl(parser, new ArrayList(), simpleListAcc);
    }

    public static <R> Handler<R, Set<R>> handlerAddToSet(Parser<R> parser) {
        SetMerger simpleListAcc = (item, s) -> {
            s.add(item);
            return Try.apply(() -> s);
        };
        return new ElasticHitsHandlerImpl(parser, new HashSet(), simpleListAcc);
    }

    public static interface Handler<R, S>
    extends Function<SearchHit[], Try<S>> {
    }

    public static interface Parser<R>
    extends Function<SearchHit, Try<R>> {
    }

    public static interface MapMerger<K, R>
    extends Merger<R, Map<K, R>> {
    }

    public static interface SetMerger<R>
    extends Merger<R, Set<R>> {
    }

    public static interface ListMerger<R>
    extends Merger<R, List<R>> {
    }

    public static interface Merger<R, S>
    extends BiFunction<R, S, Try<S>> {
    }
}

