/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.query;

import com.google.common.base.Strings;
import com.logicalclocks.servicediscoverclient.exceptions.ServiceDiscoveryException;
import io.hops.hopsworks.common.featurestore.FeaturestoreFacade;
import io.hops.hopsworks.common.featurestore.feature.FeatureGroupFeatureDTO;
import io.hops.hopsworks.common.featurestore.featuregroup.FeaturegroupController;
import io.hops.hopsworks.common.featurestore.featuregroup.FeaturegroupDTO;
import io.hops.hopsworks.common.featurestore.featuregroup.FeaturegroupFacade;
import io.hops.hopsworks.common.featurestore.featuregroup.cached.CachedFeaturegroupController;
import io.hops.hopsworks.common.featurestore.featuregroup.cached.CachedFeaturegroupDTO;
import io.hops.hopsworks.common.featurestore.featuregroup.cached.FeatureGroupCommitController;
import io.hops.hopsworks.common.featurestore.featuregroup.ondemand.OnDemandFeaturegroupDTO;
import io.hops.hopsworks.common.featurestore.online.OnlineFeaturestoreController;
import io.hops.hopsworks.common.featurestore.query.Feature;
import io.hops.hopsworks.common.featurestore.query.FsQueryDTO;
import io.hops.hopsworks.common.featurestore.query.HudiFeatureGroupAliasDTO;
import io.hops.hopsworks.common.featurestore.query.OnDemandFeatureGroupAliasDTO;
import io.hops.hopsworks.common.featurestore.query.Query;
import io.hops.hopsworks.common.featurestore.query.QueryDTO;
import io.hops.hopsworks.common.featurestore.query.filter.FilterController;
import io.hops.hopsworks.common.featurestore.query.join.Join;
import io.hops.hopsworks.common.featurestore.query.join.JoinController;
import io.hops.hopsworks.common.featurestore.query.join.JoinDTO;
import io.hops.hopsworks.common.featurestore.query.pit.PitJoinController;
import io.hops.hopsworks.common.featurestore.storageconnectors.FeaturestoreStorageConnectorController;
import io.hops.hopsworks.common.featurestore.storageconnectors.FeaturestoreStorageConnectorDTO;
import io.hops.hopsworks.common.featurestore.utils.FeaturestoreUtils;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.exceptions.ServiceException;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.Featuregroup;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.FeaturegroupType;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.cached.FeatureGroupCommit;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.cached.TimeTravelFormat;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.SqlCondition;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.calcite.sql.JoinType;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.dialect.HiveSqlDialect;
import org.apache.calcite.sql.dialect.SparkSqlDialect;
import org.apache.calcite.sql.fun.SqlCase;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class ConstructorController {
    @EJB
    private FeaturegroupFacade featuregroupFacade;
    @EJB
    private FeaturestoreFacade featurestoreFacade;
    @EJB
    private FeaturegroupController featuregroupController;
    @EJB
    private OnlineFeaturestoreController onlineFeaturestoreController;
    @EJB
    private FeatureGroupCommitController featureGroupCommitCommitController;
    @EJB
    private CachedFeaturegroupController cachedFeaturegroupController;
    @EJB
    private FeaturestoreUtils featurestoreUtils;
    @EJB
    private FeaturestoreStorageConnectorController storageConnectorController;
    @EJB
    private FilterController filterController;
    @EJB
    private JoinController joinController;
    @EJB
    private PitJoinController pitJoinController;
    private static final String ALL_FEATURES = "*";

    public ConstructorController() {
    }

    public ConstructorController(FeaturegroupController featuregroupController, FeaturestoreFacade featurestoreFacade, FeaturegroupFacade featuregroupFacade, OnlineFeaturestoreController onlineFeaturestoreController, CachedFeaturegroupController cachedFeaturegroupController, FilterController filterController, JoinController joinController) {
        this.featuregroupController = featuregroupController;
        this.featurestoreFacade = featurestoreFacade;
        this.featuregroupFacade = featuregroupFacade;
        this.onlineFeaturestoreController = onlineFeaturestoreController;
        this.cachedFeaturegroupController = cachedFeaturegroupController;
        this.filterController = filterController;
        this.joinController = joinController;
    }

    public FsQueryDTO construct(QueryDTO queryDTO, Project project, Users user) throws FeaturestoreException, ServiceException {
        boolean pitEnabled = this.pitJoinController.isPitEnabled(queryDTO);
        HashMap<Integer, String> fgAliasLookup = new HashMap<Integer, String>();
        HashMap<Integer, Featuregroup> fgLookup = new HashMap<Integer, Featuregroup>();
        HashMap<Integer, List<Feature>> availableFeatureLookup = new HashMap<Integer, List<Feature>>();
        this.populateFgLookupTables(queryDTO, 0, fgAliasLookup, fgLookup, availableFeatureLookup, project, user, null);
        Query query = this.convertQueryDTO(queryDTO, fgAliasLookup, fgLookup, availableFeatureLookup, pitEnabled);
        return this.construct(query, pitEnabled, false, project, user);
    }

    public FsQueryDTO construct(Query query, boolean pitEnabled, boolean isTrainingDataset, Project project, Users user) throws FeaturestoreException, ServiceException {
        FsQueryDTO fsQueryDTO = new FsQueryDTO();
        fsQueryDTO.setQuery(this.makeOfflineQuery(query));
        fsQueryDTO.setHudiCachedFeatureGroups(this.getHudiAliases(query, new ArrayList<HudiFeatureGroupAliasDTO>(), project, user));
        fsQueryDTO.setOnDemandFeatureGroups(this.getOnDemandAliases(user, project, query, new ArrayList<OnDemandFeatureGroupAliasDTO>()));
        if (fsQueryDTO.getOnDemandFeatureGroups().isEmpty()) {
            fsQueryDTO.setQueryOnline(this.generateSQL(query, true).toSqlString((SqlDialect)new SparkSqlDialect(SqlDialect.EMPTY_CONTEXT)).getSql());
        }
        if (pitEnabled) {
            fsQueryDTO.setPitQuery(this.makePitQuery(query, isTrainingDataset));
        }
        return fsQueryDTO;
    }

    String makeOfflineQuery(Query query) {
        HiveSqlDialect offlineSqlDialect = query.getHiveEngine() != false ? new HiveSqlDialect(SqlDialect.EMPTY_CONTEXT) : new SparkSqlDialect(SqlDialect.EMPTY_CONTEXT);
        return this.generateSQL(query, false).toSqlString((SqlDialect)offlineSqlDialect).getSql();
    }

    String makePitQuery(Query query, boolean isTrainingDataset) {
        SqlNode pitQuery = this.pitJoinController.generateSQL(query, isTrainingDataset);
        return query.getHiveEngine() != false ? pitQuery.toSqlString((SqlDialect)new HiveSqlDialect(SqlDialect.EMPTY_CONTEXT)).getSql() : pitQuery.toSqlString((SqlDialect)new SparkSqlDialect(SqlDialect.EMPTY_CONTEXT)).getSql();
    }

    public Query convertQueryDTO(QueryDTO queryDTO, Map<Integer, String> fgAliasLookup, Map<Integer, Featuregroup> fgLookup, Map<Integer, List<Feature>> availableFeatureLookup, boolean pitEnabled) throws FeaturestoreException {
        Integer fgId = queryDTO.getLeftFeatureGroup().getId();
        Featuregroup fg = fgLookup.get(fgId);
        String featureStore = this.featurestoreFacade.getHiveDbName(fg.getFeaturestore().getHiveDbId());
        String projectName = this.onlineFeaturestoreController.getOnlineFeaturestoreDbName(fg.getFeaturestore().getProject());
        List<Feature> requestedFeatures = this.validateFeatures(fg, queryDTO.getLeftFeatures(), availableFeatureLookup.get(fgId));
        Query query = new Query(featureStore, projectName, fg, fgAliasLookup.get(fgId), requestedFeatures, availableFeatureLookup.get(fgId), queryDTO.getHiveEngine());
        if (fg.getCachedFeaturegroup() != null && fg.getCachedFeaturegroup().getTimeTravelFormat() == TimeTravelFormat.HUDI) {
            if (queryDTO.getHiveEngine().booleanValue() && (queryDTO.getLeftFeatureGroupEndTime() != null || queryDTO.getJoins().stream().anyMatch(join -> join.getQuery().getLeftFeatureGroupEndTime() != null))) {
                throw new IllegalArgumentException("Hive engine on Python environments does not support incremental or snapshot queries. Read feature group without timestamp to retrieve latest snapshot or switch to environment with Spark Engine.");
            }
            FeatureGroupCommit endCommit = this.featureGroupCommitCommitController.findCommitByDate(fg, queryDTO.getLeftFeatureGroupEndTime());
            query.setLeftFeatureGroupEndTimestamp(endCommit.getCommittedOn());
            query.setLeftFeatureGroupEndCommitId(endCommit.getFeatureGroupCommitPK().getCommitId());
            if ((queryDTO.getJoins() == null || queryDTO.getJoins().isEmpty()) && queryDTO.getLeftFeatureGroupStartTime() != null) {
                Long exactStartCommitTimestamp = this.featureGroupCommitCommitController.findCommitByDate(query.getFeaturegroup(), queryDTO.getLeftFeatureGroupStartTime()).getCommittedOn();
                query.setLeftFeatureGroupStartTimestamp(exactStartCommitTimestamp);
            } else if (queryDTO.getJoins() != null && queryDTO.getLeftFeatureGroupStartTime() != null) {
                throw new IllegalArgumentException("For incremental queries start time must be provided and join statements are not allowed");
            }
        }
        if (queryDTO.getJoins() != null && !queryDTO.getJoins().isEmpty()) {
            query.setJoins(this.convertJoins(query, queryDTO.getJoins(), fgAliasLookup, fgLookup, availableFeatureLookup, pitEnabled));
            this.removeDuplicateColumns(query, pitEnabled);
        }
        if (queryDTO.getFilter() != null) {
            query.setFilter(this.filterController.convertFilterLogic(queryDTO.getFilter(), fgLookup, availableFeatureLookup));
        }
        return query;
    }

    public int populateFgLookupTables(QueryDTO queryDTO, int fgId, Map<Integer, String> fgAliasLookup, Map<Integer, Featuregroup> fgLookup, Map<Integer, List<Feature>> availableFeatureLookup, Project project, Users user, String prefix) throws FeaturestoreException {
        if (queryDTO.getJoins() != null && !queryDTO.getJoins().isEmpty()) {
            for (JoinDTO join : queryDTO.getJoins()) {
                fgId = this.populateFgLookupTables(join.getQuery(), fgId, fgAliasLookup, fgLookup, availableFeatureLookup, project, user, join.getPrefix());
                ++fgId;
            }
        }
        Featuregroup fg = this.validateFeaturegroupDTO(queryDTO.getLeftFeatureGroup());
        fgLookup.put(fg.getId(), fg);
        fgAliasLookup.put(fg.getId(), this.generateAs(fgId));
        List availableFeatures = this.featuregroupController.getFeatures(fg, project, user).stream().map(f -> new Feature(f.getName(), (String)fgAliasLookup.get(fg.getId()), f.getType(), f.getDefaultValue(), f.getPrimary(), fg, prefix)).collect(Collectors.toList());
        availableFeatureLookup.put(fg.getId(), availableFeatures);
        return fgId;
    }

    private String generateAs(int id) {
        return "fg" + id;
    }

    private Featuregroup validateFeaturegroupDTO(FeaturegroupDTO featuregroupDTO) throws FeaturestoreException {
        if (featuregroupDTO == null) {
            throw new IllegalArgumentException("Feature group not specified");
        }
        return this.featuregroupFacade.findById(featuregroupDTO.getId()).orElseThrow(() -> new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FEATUREGROUP_NOT_FOUND, Level.FINE, "Could not find feature group with ID" + featuregroupDTO.getId()));
    }

    protected List<Feature> validateFeatures(Featuregroup fg, List<FeatureGroupFeatureDTO> requestedFeatures, List<Feature> availableFeatures) throws FeaturestoreException {
        ArrayList<Feature> featureList = new ArrayList<Feature>();
        if (requestedFeatures == null || requestedFeatures.isEmpty()) {
            throw new IllegalArgumentException("Invalid requested features");
        }
        if (requestedFeatures.size() == 1 && requestedFeatures.get(0).getName().equals(ALL_FEATURES)) {
            featureList.addAll(availableFeatures);
        } else {
            for (FeatureGroupFeatureDTO requestedFeature : requestedFeatures) {
                featureList.add(availableFeatures.stream().filter(af -> af.getName().equals(requestedFeature.getName())).findFirst().orElseThrow(() -> new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FEATURE_DOES_NOT_EXIST, Level.FINE, "Feature: " + requestedFeature.getName() + " not found in feature group: " + fg.getName())));
            }
        }
        return featureList;
    }

    private List<Join> convertJoins(Query leftQuery, List<JoinDTO> joinDTOS, Map<Integer, String> fgAliasLookup, Map<Integer, Featuregroup> fgLookup, Map<Integer, List<Feature>> availableFeatureLookup, boolean pitEnabled) throws FeaturestoreException {
        ArrayList<Join> joins = new ArrayList<Join>();
        for (JoinDTO joinDTO : joinDTOS) {
            List<Feature> rightOn;
            List<Feature> leftOn;
            if (joinDTO.getQuery() == null) {
                throw new IllegalArgumentException("Subquery not specified");
            }
            Query rightQuery = this.convertQueryDTO(joinDTO.getQuery(), fgAliasLookup, fgLookup, availableFeatureLookup, pitEnabled);
            if (joinDTO.getOn() != null && !joinDTO.getOn().isEmpty()) {
                leftOn = joinDTO.getOn().stream().map(f -> new Feature(f.getName())).collect(Collectors.toList());
                rightOn = joinDTO.getOn().stream().map(f -> new Feature(f.getName())).collect(Collectors.toList());
                joins.add(this.extractLeftRightOn(leftQuery, rightQuery, leftOn, rightOn, joinDTO.getType(), joinDTO.getPrefix()));
                continue;
            }
            if (joinDTO.getLeftOn() != null && !joinDTO.getLeftOn().isEmpty()) {
                leftOn = joinDTO.getLeftOn().stream().map(f -> new Feature(f.getName())).collect(Collectors.toList());
                rightOn = joinDTO.getRightOn().stream().map(f -> new Feature(f.getName())).collect(Collectors.toList());
                joins.add(this.extractLeftRightOn(leftQuery, rightQuery, leftOn, rightOn, joinDTO.getType(), joinDTO.getPrefix()));
                continue;
            }
            joins.add(this.extractPrimaryKeysJoin(leftQuery, rightQuery, joinDTO.getType(), joinDTO.getPrefix()));
        }
        return joins;
    }

    public Join extractLeftRightOn(Query leftQuery, Query rightQuery, List<Feature> leftOn, List<Feature> rightOn, JoinType joinType, String prefix) throws FeaturestoreException {
        if (leftOn.size() != rightOn.size()) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.LEFT_RIGHT_ON_DIFF_SIZES, Level.FINE);
        }
        List<SqlCondition> joinOperator = leftOn.stream().map(f -> SqlCondition.EQUALS).collect(Collectors.toList());
        if (joinOperator.size() != leftOn.size()) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.JOIN_OPERATOR_MISMATCH, Level.FINE);
        }
        for (Feature feature : leftOn) {
            this.checkFeatureExistsAndSetAttributes(leftQuery, feature);
        }
        for (Feature feature : rightOn) {
            this.checkFeatureExistsAndSetAttributes(rightQuery, feature);
        }
        return new Join(leftQuery, rightQuery, leftOn, rightOn, joinType, prefix, joinOperator);
    }

    protected Join extractPrimaryKeysJoin(Query leftQuery, Query rightQuery, JoinType joinType, String prefix) throws FeaturestoreException {
        ArrayList<Feature> joinFeatures = new ArrayList<Feature>();
        leftQuery.getAvailableFeatures().stream().filter(Feature::isPrimary).forEach(lf -> joinFeatures.addAll(rightQuery.getAvailableFeatures().stream().filter(rf -> rf.getName().equals(lf.getName()) && rf.isPrimary()).collect(Collectors.toList())));
        if (joinFeatures.isEmpty()) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.NO_PK_JOINING_KEYS, Level.FINE, leftQuery.getFeaturegroup().getName() + " and: " + rightQuery.getFeaturegroup().getName());
        }
        List<SqlCondition> joinOperator = joinFeatures.stream().map(f -> SqlCondition.EQUALS).collect(Collectors.toList());
        return new Join(leftQuery, rightQuery, joinFeatures, joinFeatures, joinType, prefix, joinOperator);
    }

    private void checkFeatureExistsAndSetAttributes(Query query, Feature feature) throws FeaturestoreException {
        Optional<Feature> availableFeature = query.getAvailableFeatures().stream().filter(f -> f.getName().equals(feature.getName())).findAny();
        if (!availableFeature.isPresent()) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FEATURE_DOES_NOT_EXIST, Level.FINE, "Could not find Join feature " + feature.getName() + " in feature group: " + query.getFeaturegroup().getName());
        }
        feature.setDefaultValue(availableFeature.get().getDefaultValue());
        feature.setType(availableFeature.get().getType());
        feature.setFgAlias(availableFeature.get().getFgAlias());
    }

    void removeDuplicateColumns(Query query, boolean pitEnabled) {
        for (Join join : query.getJoins()) {
            List leftJoinFeatureNames = join.getLeftOn().stream().map(Feature::getName).collect(Collectors.toList());
            List<Feature> filteredRightFeatures = new ArrayList<Feature>();
            for (Feature rightFeature : join.getRightQuery().getFeatures()) {
                if (leftJoinFeatureNames.contains(rightFeature.getName()) && join.getLeftQuery().getFeatures().stream().anyMatch(lf -> lf.getName().equals(Strings.isNullOrEmpty((String)rightFeature.getPrefix()) ? rightFeature.getName() : rightFeature.getPrefix() + rightFeature.getName()))) continue;
                filteredRightFeatures.add(rightFeature);
            }
            if (pitEnabled) {
                filteredRightFeatures = filteredRightFeatures.stream().filter(f -> !f.getName().equals(join.getRightQuery().getFeaturegroup().getEventTime())).collect(Collectors.toList());
            }
            join.getRightQuery().setFeatures(filteredRightFeatures);
        }
    }

    public SqlSelect generateSQL(Query query, boolean online) {
        SqlNodeList selectList = new SqlNodeList(SqlParserPos.ZERO);
        for (Feature f : this.collectFeatures(query)) {
            if (f.getDefaultValue() == null || online) {
                selectList.add(this.getWithOrWithoutPrefix(f, true));
                continue;
            }
            selectList.add(this.selectWithDefaultAs(f));
        }
        SqlNode joinNode = null;
        joinNode = query.getJoins() == null || query.getJoins().isEmpty() ? this.generateTableNode(query, online) : this.joinController.buildJoinNode(query, query.getJoins().size() - 1, online);
        SqlNode filterNode = null;
        if (query.getJoins() == null || query.getJoins().isEmpty()) {
            if (query.getFilter() != null) {
                filterNode = this.filterController.generateFilterLogicNode(query.getFilter(), online);
            }
        } else {
            filterNode = this.filterController.buildFilterNode(query, query, query.getJoins().size() - 1, online);
        }
        SqlNodeList orderByList = null;
        if (query.getOrderByFeatures() != null && !query.getOrderByFeatures().isEmpty()) {
            orderByList = new SqlNodeList(SqlParserPos.ZERO);
            for (Feature f : query.getOrderByFeatures()) {
                if (f.getDefaultValue() == null || online) {
                    orderByList.add(this.getWithOrWithoutPrefix(f, false));
                    continue;
                }
                orderByList.add(this.selectWithDefaultAs(f));
            }
        }
        return new SqlSelect(SqlParserPos.ZERO, null, selectList, joinNode, filterNode, null, null, null, orderByList, null, null, null);
    }

    public SqlNode caseWhenDefault(Feature feature) {
        SqlIdentifier featureIdentifier = new SqlIdentifier(Arrays.asList("`" + feature.getFgAlias() + "`", "`" + feature.getName() + "`"), SqlParserPos.ZERO);
        SqlCall featureIsNull = SqlStdOperatorTable.IS_NULL.createCall(SqlParserPos.ZERO, new SqlNode[]{featureIdentifier});
        Object defaultValue = feature.getType().equalsIgnoreCase("string") ? SqlLiteral.createCharString((String)feature.getDefaultValue(), (SqlParserPos)SqlParserPos.ZERO) : new SqlIdentifier(feature.getDefaultValue(), SqlParserPos.ZERO);
        return new SqlCase(SqlParserPos.ZERO, null, new SqlNodeList(Arrays.asList(featureIsNull), SqlParserPos.ZERO), new SqlNodeList(Arrays.asList(defaultValue), SqlParserPos.ZERO), (SqlNode)featureIdentifier);
    }

    public SqlNode selectWithDefaultAs(Feature feature) {
        return SqlStdOperatorTable.AS.createCall(new SqlNodeList(Arrays.asList(this.caseWhenDefault(feature), new SqlIdentifier("`" + feature.getName() + "`", SqlParserPos.ZERO)), SqlParserPos.ZERO));
    }

    public List<Feature> collectFeatures(Query query) {
        List<Feature> features = new ArrayList<Feature>(query.getFeatures());
        if (query.getJoins() != null) {
            for (Join join : query.getJoins()) {
                if (join.getRightQuery() == null || join.getRightQuery().getFeatures() == null) continue;
                if (join.getPrefix() != null) {
                    for (Feature f : join.getRightQuery().getFeatures()) {
                        f.setPrefix(join.getPrefix());
                    }
                }
                features.addAll(this.collectFeatures(join.getRightQuery()));
            }
        }
        if (query.getFeaturegroup().getFeaturegroupType() == FeaturegroupType.CACHED_FEATURE_GROUP && query.getFeaturegroup().getCachedFeaturegroup().getTimeTravelFormat() == TimeTravelFormat.HUDI) {
            features = this.cachedFeaturegroupController.dropHudiSpecFeatures(features);
        }
        return features;
    }

    private SqlNode generateCachedTableNode(Query query, boolean online) {
        ArrayList<String> tableIdentifierStr = new ArrayList<String>();
        if (online) {
            tableIdentifierStr.add("`" + query.getProject() + "`");
            tableIdentifierStr.add("`" + query.getFeaturegroup().getName() + "_" + query.getFeaturegroup().getVersion() + "`");
        } else if (query.getFeaturegroup().getCachedFeaturegroup().getTimeTravelFormat() != TimeTravelFormat.HUDI || query.getHiveEngine().booleanValue()) {
            tableIdentifierStr.add("`" + query.getFeatureStore() + "`");
            tableIdentifierStr.add("`" + query.getFeaturegroup().getName() + "_" + query.getFeaturegroup().getVersion() + "`");
        } else {
            tableIdentifierStr.add("`" + query.getAs() + "`");
        }
        SqlNodeList asNodeList = new SqlNodeList(Arrays.asList(new SqlIdentifier(tableIdentifierStr, SqlParserPos.ZERO), new SqlIdentifier("`" + query.getAs() + "`", SqlParserPos.ZERO)), SqlParserPos.ZERO);
        return SqlStdOperatorTable.AS.createCall(asNodeList);
    }

    private SqlNode generateOnDemandTableNode(Query query) {
        return new SqlIdentifier("`" + query.getAs() + "`", SqlParserPos.ZERO);
    }

    public SqlNode generateTableNode(Query query, boolean online) {
        if (query.getFeaturegroup().getFeaturegroupType() == FeaturegroupType.CACHED_FEATURE_GROUP) {
            return this.generateCachedTableNode(query, online);
        }
        return this.generateOnDemandTableNode(query);
    }

    public List<HudiFeatureGroupAliasDTO> getHudiAliases(Query query, List<HudiFeatureGroupAliasDTO> aliases, Project project, Users user) throws FeaturestoreException, ServiceException {
        if (query.getFeaturegroup().getFeaturegroupType() == FeaturegroupType.CACHED_FEATURE_GROUP && query.getFeaturegroup().getCachedFeaturegroup().getTimeTravelFormat() == TimeTravelFormat.HUDI) {
            CachedFeaturegroupDTO featuregroupDTO = new CachedFeaturegroupDTO(query.getFeaturegroup());
            Featuregroup featuregroup = query.getFeaturegroup();
            List<FeatureGroupFeatureDTO> featureGroupFeatureDTOS = this.cachedFeaturegroupController.getFeaturesDTO(featuregroup, project, user);
            featuregroupDTO.setFeatures(featureGroupFeatureDTOS);
            featuregroupDTO.setLocation(this.featurestoreUtils.resolveLocationURI(featuregroup.getCachedFeaturegroup().getHiveTbls().getSdId().getLocation()));
            if (query.getLeftFeatureGroupStartTimestamp() == null) {
                aliases.add(new HudiFeatureGroupAliasDTO(query.getAs(), featuregroupDTO, query.getLeftFeatureGroupEndTimestamp()));
            } else {
                aliases.add(new HudiFeatureGroupAliasDTO(query.getAs(), featuregroupDTO, query.getLeftFeatureGroupStartTimestamp(), query.getLeftFeatureGroupEndTimestamp()));
            }
        }
        if (query.getJoins() != null && !query.getJoins().isEmpty()) {
            for (Join join : query.getJoins()) {
                this.getHudiAliases(join.getRightQuery(), aliases, project, user);
            }
        }
        return aliases;
    }

    public List<OnDemandFeatureGroupAliasDTO> getOnDemandAliases(Users user, Project project, Query query, List<OnDemandFeatureGroupAliasDTO> aliases) throws FeaturestoreException, ServiceException {
        if (query.getFeaturegroup().getFeaturegroupType() == FeaturegroupType.ON_DEMAND_FEATURE_GROUP) {
            FeaturestoreStorageConnectorDTO featurestoreStorageConnectorDTO = this.storageConnectorController.convertToConnectorDTO(user, project, query.getFeaturegroup().getOnDemandFeaturegroup().getFeaturestoreConnector());
            OnDemandFeaturegroupDTO onDemandFeaturegroupDTO = new OnDemandFeaturegroupDTO(query.getFeaturegroup(), featurestoreStorageConnectorDTO);
            try {
                String path = this.featuregroupController.getFeatureGroupLocation(query.getFeaturegroup());
                onDemandFeaturegroupDTO.setLocation(this.featurestoreUtils.prependNameNode(path));
            }
            catch (ServiceDiscoveryException e) {
                throw new ServiceException(RESTCodes.ServiceErrorCode.SERVICE_NOT_FOUND, Level.SEVERE);
            }
            aliases.add(new OnDemandFeatureGroupAliasDTO(query.getAs(), onDemandFeaturegroupDTO));
        }
        if (query.getJoins() != null && !query.getJoins().isEmpty()) {
            for (Join join : query.getJoins()) {
                this.getOnDemandAliases(user, project, join.getRightQuery(), aliases);
            }
        }
        return aliases;
    }

    protected SqlNode getWithOrWithoutPrefix(Feature feature, boolean withPrefix) {
        if (feature.getPrefix() != null && withPrefix) {
            return SqlStdOperatorTable.AS.createCall(SqlParserPos.ZERO, new SqlNode[]{new SqlIdentifier(Arrays.asList("`" + feature.getFgAlias() + "`", "`" + feature.getName() + "`"), SqlParserPos.ZERO), new SqlIdentifier("`" + feature.getPrefix() + feature.getName() + "`", SqlParserPos.ZERO)});
        }
        return new SqlIdentifier(Arrays.asList("`" + feature.getFgAlias() + "`", "`" + feature.getName() + "`"), SqlParserPos.ZERO);
    }
}

