/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.util;

import io.hops.hopsworks.common.util.OSProcessExecutor;
import io.hops.hopsworks.common.util.ProcessDescriptor;
import io.hops.hopsworks.common.util.ProcessResult;
import io.hops.hopsworks.common.util.Settings;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LocalhostServices {
    private static final Logger logger = Logger.getLogger(LocalhostServices.class.getName());

    public static void generateHopsSiteKeystore(Settings settings, OSProcessExecutor osProcessExecutor, String userKeyPwd) throws IOException {
        ProcessDescriptor processDescriptor = new ProcessDescriptor.Builder().addCommand("/usr/bin/sudo").addCommand(settings.getHopsSiteCaScript()).addCommand(userKeyPwd).build();
        ProcessResult processResult = osProcessExecutor.execute(processDescriptor);
        if (!processResult.processExited()) {
            throw new IOException("Generating Hops site keystore time-out");
        }
        int exitCode = processResult.getExitCode();
        if (exitCode != 0) {
            throw new IOException("stdout: " + processResult.getStdout() + "\nstderr: " + processResult.getStderr());
        }
    }

    public static String du(OSProcessExecutor osProcessExecutor, File base) throws IOException {
        ProcessDescriptor processDescriptor = new ProcessDescriptor.Builder().addCommand("du").addCommand("-sh").addCommand(base.getCanonicalPath()).build();
        logger.log(Level.FINE, processDescriptor.toString());
        try {
            ProcessResult processResult = osProcessExecutor.execute(processDescriptor);
            if (!processResult.processExited()) {
                logger.log(Level.SEVERE, "Operation to calculate disk usage time-out");
                return "";
            }
            return processResult.getStdout();
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "Problem getting logs: {0}", ex.toString());
            return "";
        }
    }
}

