/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.jobs.spark;

import io.hops.hopsworks.common.jobs.yarn.YarnRunner;
import io.hops.hopsworks.common.jobs.yarn.YarnSetupCommand;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.hadoop.yarn.util.ConverterUtils;

public final class SparkSetEnvironmentCommand
extends YarnSetupCommand {
    private static final Logger logger = Logger.getLogger(SparkSetEnvironmentCommand.class.toString());

    @Override
    public void execute(YarnRunner r) {
        ApplicationSubmissionContext appContext = r.getAppContext();
        ContainerLaunchContext launchContext = appContext.getAMContainerSpec();
        Map env = launchContext.getEnvironment();
        Map rescs = launchContext.getLocalResources();
        StringBuilder fileUris = new StringBuilder();
        StringBuilder fileTimestamps = new StringBuilder();
        StringBuilder fileSizes = new StringBuilder();
        StringBuilder fileVisibilities = new StringBuilder();
        StringBuilder fileTypes = new StringBuilder();
        StringBuilder archiveUris = new StringBuilder();
        StringBuilder archiveTimestamps = new StringBuilder();
        StringBuilder archiveSizes = new StringBuilder();
        StringBuilder archiveVisibilities = new StringBuilder();
        for (Map.Entry resource : rescs.entrySet()) {
            try {
                Path destPath = ConverterUtils.getPathFromYarnURL((URL)((LocalResource)resource.getValue()).getResource());
                URI sparkUri = destPath.toUri();
                URI pathURI = new URI(sparkUri.getScheme(), sparkUri.getAuthority(), sparkUri.getPath(), null, (String)resource.getKey());
                fileUris.append(pathURI.toString()).append(",");
                fileTimestamps.append(((LocalResource)resource.getValue()).getTimestamp()).append(",");
                fileSizes.append(((LocalResource)resource.getValue()).getSize()).append(",");
                fileVisibilities.append(((LocalResource)resource.getValue()).getVisibility()).append(",");
                fileTypes.append(((LocalResource)resource.getValue()).getType().toString()).append(",");
            }
            catch (URISyntaxException e) {
                logger.log(Level.SEVERE, "Failed to add LocalResource " + resource + " to Spark Environment.", e);
            }
        }
        env.put("CACHED_FILES", fileUris.substring(0, fileUris.length() - 1));
        env.put("CACHED_FILES_TIMESTAMPS", fileTimestamps.substring(0, fileTimestamps.length() - 1));
        env.put("CACHED_FILES_SIZES", fileSizes.substring(0, fileSizes.length() - 1));
        env.put("CACHED_FILES_VISIBILITIES", fileVisibilities.substring(0, fileVisibilities.length() - 1));
        env.put("CACHED_FILES_TYPES", fileTypes.substring(0, fileTypes.length() - 1));
        ContainerLaunchContext amContainer = ContainerLaunchContext.newInstance((Map)launchContext.getLocalResources(), (Map)env, (List)launchContext.getCommands(), null, null, null);
        appContext.setAMContainerSpec(amContainer);
    }
}

