/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.python.library;

import com.lambdista.util.Try;
import io.hops.hopsworks.common.dao.project.ProjectFacade;
import io.hops.hopsworks.common.dao.python.LibraryFacade;
import io.hops.hopsworks.common.elastic.ElasticClientController;
import io.hops.hopsworks.common.provenance.core.elastic.BasicElasticHit;
import io.hops.hopsworks.common.provenance.core.elastic.ElasticHelper;
import io.hops.hopsworks.common.provenance.core.elastic.ElasticHits;
import io.hops.hopsworks.common.provenance.util.functional.CheckedSupplier;
import io.hops.hopsworks.common.python.commands.CommandsController;
import io.hops.hopsworks.common.python.library.LibraryVersionDTO;
import io.hops.hopsworks.common.python.search.PyPiLibraryElasticIndexer;
import io.hops.hopsworks.common.util.OSProcessExecutor;
import io.hops.hopsworks.common.util.ProcessDescriptor;
import io.hops.hopsworks.common.util.ProcessResult;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.ElasticException;
import io.hops.hopsworks.exceptions.GenericException;
import io.hops.hopsworks.exceptions.ProvenanceException;
import io.hops.hopsworks.exceptions.ServiceException;
import io.hops.hopsworks.persistence.entity.jupyter.config.GitBackend;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.python.AnacondaRepo;
import io.hops.hopsworks.persistence.entity.python.CondaCommands;
import io.hops.hopsworks.persistence.entity.python.CondaInstallType;
import io.hops.hopsworks.persistence.entity.python.CondaOp;
import io.hops.hopsworks.persistence.entity.python.PythonDep;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Response;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.javatuples.Pair;
import org.json.JSONArray;
import org.json.JSONObject;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class LibraryController {
    private static final Logger LOGGER = Logger.getLogger(LibraryController.class.getName());
    @EJB
    private ProjectFacade projectFacade;
    @EJB
    private CommandsController commandsController;
    @EJB
    private Settings settings;
    @EJB
    private LibraryFacade libraryFacade;
    @EJB
    private OSProcessExecutor osProcessExecutor;
    @EJB
    private ElasticClientController provElasticController;
    @EJB
    private PyPiLibraryElasticIndexer pypiIndexer;

    public PythonDep getPythonDep(String dependency, Project project) {
        return this.libraryFacade.findByDependencyAndProject(dependency, project);
    }

    public void uninstallLibrary(Project project, Users user, String libName) throws GenericException, ServiceException {
        for (PythonDep dep : project.getPythonDepCollection()) {
            if (!dep.getDependency().equals(libName)) continue;
            this.uninstallLibrary(project, user, dep.getInstallType(), dep.getRepoUrl().getUrl(), libName, dep.getVersion());
            break;
        }
    }

    public Project syncProjectPythonDepsWithEnv(Project proj, Collection<PythonDep> newDeps) {
        proj.setPythonDepCollection(newDeps);
        proj = this.projectFacade.update(proj);
        this.projectFacade.flushEm();
        return proj;
    }

    public PythonDep installLibrary(Project proj, Users user, CondaInstallType installType, String channelUrl, String dependency, String version, String arg, GitBackend gitBackend, String apiKeyName) throws GenericException, ServiceException {
        return this.commandsController.condaOp(CondaOp.INSTALL, user, installType, proj, channelUrl, dependency, version, arg, gitBackend, apiKeyName);
    }

    public void uninstallLibrary(Project proj, Users user, CondaInstallType installType, String channelUrl, String dependency, String version) throws GenericException, ServiceException {
        this.commandsController.condaOp(CondaOp.UNINSTALL, user, installType, proj, channelUrl, dependency, version, "", null, null);
    }

    public HashMap<String, List<LibraryVersionDTO>> condaSearch(String library, String url) throws ServiceException {
        HashMap<String, List<LibraryVersionDTO>> libVersions = new HashMap<String, List<LibraryVersionDTO>>();
        String prog = this.settings.getHopsworksDomainDir() + "/bin/condasearch.sh";
        String[] lines = this.condaList(prog, library, url);
        String foundLib = "";
        for (String line : lines) {
            String[] libVersion = line.split(",");
            if (libVersion.length != 2) {
                throw new ServiceException(RESTCodes.ServiceErrorCode.ANACONDA_LIST_LIB_FORMAT_ERROR, Level.WARNING);
            }
            String key = libVersion[0];
            String value = libVersion[1];
            if (key.isEmpty() || key.equalsIgnoreCase("Loading") && value.equalsIgnoreCase("channels:") || key.equalsIgnoreCase("#") && value.equalsIgnoreCase("Name") || key.equalsIgnoreCase("no") && value.equalsIgnoreCase("match")) continue;
            foundLib = key;
            String foundVersion = value;
            if (!libVersions.containsKey(foundLib)) {
                LinkedList<LibraryVersionDTO> versions = new LinkedList<LibraryVersionDTO>();
                versions.add(new LibraryVersionDTO(foundVersion));
                libVersions.put(foundLib, versions);
                continue;
            }
            LibraryVersionDTO libraryVersionDTO = new LibraryVersionDTO(foundVersion);
            if (libVersions.get(foundLib).contains(libraryVersionDTO)) continue;
            libVersions.get(foundLib).add(0, libraryVersionDTO);
        }
        if (libVersions.isEmpty()) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.ANACONDA_LIST_LIB_NOT_FOUND, Level.FINE);
        }
        return libVersions;
    }

    private void findPipLibPyPi(String libName, HashMap<String, List<LibraryVersionDTO>> versions) {
        Response resp = null;
        try {
            resp = ClientBuilder.newClient().target(this.settings.getPyPiRESTEndpoint().replaceFirst("\\{package}", libName)).request().header("Content-Type", (Object)"application/json").get();
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "PyPi REST endpoint connection failed" + this.settings.getPyPiRESTEndpoint().replaceFirst("\\{package}", libName), e);
            return;
        }
        if (resp.getStatusInfo().getStatusCode() != Response.Status.OK.getStatusCode()) {
            return;
        }
        JSONObject jsonObject = new JSONObject((String)resp.readEntity(String.class));
        if (jsonObject.has("releases")) {
            JSONObject releases = jsonObject.getJSONObject("releases");
            versions.put(libName, this.getVersions(releases));
        }
    }

    private List<LibraryVersionDTO> getVersions(JSONObject releases) {
        ArrayList<LibraryVersionDTO> versions = new ArrayList<LibraryVersionDTO>();
        Iterator keys = releases.keys();
        Date releaseDate = new Date(0L);
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (releases.get(key) instanceof JSONArray) {
                JSONObject versionMeta;
                JSONObject jSONObject = versionMeta = ((JSONArray)releases.get(key)).length() > 0 ? (JSONObject)((JSONArray)releases.get(key)).get(0) : null;
                if (versionMeta != null && versionMeta.has("upload_time")) {
                    String strDate = versionMeta.getString("upload_time");
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                    try {
                        releaseDate = sdf.parse(strDate);
                    }
                    catch (ParseException e) {
                        LOGGER.log(Level.FINE, "Failed to parse release date: {0}", strDate);
                    }
                }
            }
            versions.add(new LibraryVersionDTO(key, releaseDate));
        }
        return versions;
    }

    public HashMap<String, List<LibraryVersionDTO>> pipSearch(String query) throws ServiceException {
        String[] lines;
        HashMap<String, List<LibraryVersionDTO>> versions = new HashMap<String, List<LibraryVersionDTO>>();
        for (String library : lines = this.pipList(query, new HandlerFactory.BaseList(), "pypi_libraries")) {
            this.findPipLibPyPi(library, versions);
        }
        if (versions.isEmpty()) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.ANACONDA_LIST_LIB_NOT_FOUND, Level.FINE);
        }
        return versions;
    }

    private String[] condaList(String program, String library, String url) throws ServiceException {
        ProcessResult processResult;
        ProcessDescriptor.Builder pdBuilder = new ProcessDescriptor.Builder();
        pdBuilder.addCommand(program);
        if (url != null && !url.isEmpty()) {
            pdBuilder.addCommand(url);
            pdBuilder.addCommand(library);
        } else if (library != null && !library.isEmpty()) {
            pdBuilder.addCommand(library);
        }
        ProcessDescriptor processDescriptor = pdBuilder.redirectErrorStream(true).setWaitTimeout(5L, TimeUnit.MINUTES).build();
        try {
            processResult = this.osProcessExecutor.execute(processDescriptor);
            boolean exited = processResult.processExited();
            int errCode = processResult.getExitCode();
            if (!exited) {
                throw new ServiceException(RESTCodes.ServiceErrorCode.ANACONDA_LIST_LIB_ERROR, Level.WARNING, "errCode: " + errCode + ", " + processResult.getStderr());
            }
            if (errCode == 1 || errCode == 23) {
                throw new ServiceException(RESTCodes.ServiceErrorCode.ANACONDA_LIST_LIB_NOT_FOUND, Level.FINE, "errCode: " + errCode + ", " + processResult.getStderr());
            }
            if (errCode != 0) {
                throw new ServiceException(RESTCodes.ServiceErrorCode.ANACONDA_LIST_LIB_ERROR, Level.WARNING, "errCode: " + errCode + ", " + processResult.getStderr());
            }
        }
        catch (IOException ex) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.ANACONDA_LIST_LIB_ERROR, Level.WARNING, "lib: " + library, ex.getMessage(), (Throwable)ex);
        }
        String result = processResult.getStdout();
        return result != null && !result.isEmpty() ? result.split("\n") : new String[]{};
    }

    public <R, S1, S2> S2 pipList(String query, HandlerFactory<R, S1, S2> handlerFactory, String index) throws ServiceException {
        return this.pipList(query, 0, 10, handlerFactory, index);
    }

    private <R, S1, S2> S2 pipList(String query, Integer offset, Integer limit, HandlerFactory<R, S1, S2> handlerFactory, String index) throws ServiceException {
        Pair<Long, Try<S1>> searchResult;
        try {
            CheckedSupplier<SearchRequest, ProvenanceException> srF = ElasticHelper.baseSearchRequest(index, this.settings.getElasticDefaultScrollPageSize()).andThen(ElasticHelper.withPagination(offset, limit, this.settings.getElasticDefaultScrollPageSize().intValue()));
            SearchRequest request = srF.get();
            SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
            sourceBuilder.query(ElasticHelper.fullTextSearch("library", query));
            request.source(sourceBuilder);
            searchResult = this.provElasticController.search(request, handlerFactory.getHandler());
        }
        catch (ElasticException | ProvenanceException pe) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.ANACONDA_LIST_LIB_ERROR, Level.FINE, "Unable to list python libraries", pe.getMessage(), pe);
        }
        return handlerFactory.checkedResult(searchResult);
    }

    public static Try<String[]> tryInstance(BasicElasticHit hit) {
        return Try.apply(() -> new String[]{hit.getSource().get("library").toString()});
    }

    public Collection<PythonDep> parseCondaList(String condaListStr) throws ServiceException {
        ArrayList<PythonDep> deps = new ArrayList<PythonDep>();
        String[] lines = condaListStr.split(System.getProperty("line.separator"));
        for (int i = 3; i < lines.length; ++i) {
            String line = lines[i];
            String[] split = line.split(" +");
            String libraryName = split[0];
            String version = split[1];
            String channel = "conda";
            if (split.length > 3) {
                channel = split[3].trim().isEmpty() ? channel : split[3];
            }
            CondaInstallType installType = CondaInstallType.PIP;
            if (!channel.equals("pypi")) {
                installType = CondaInstallType.CONDA;
            }
            AnacondaRepo repo = this.libraryFacade.getRepo(channel, true);
            boolean cannotBeRemoved = channel.equals("default");
            PythonDep pyDep = this.libraryFacade.getOrCreateDep(repo, installType, libraryName, version, false, cannotBeRemoved);
            deps.add(pyDep);
        }
        return deps;
    }

    public Project addOngoingOperations(Project project) throws ServiceException {
        Collection commands = project.getCondaCommandsCollection();
        for (CondaCommands condaCommand : commands) {
            if (condaCommand.getInstallType().equals((Object)CondaInstallType.ENVIRONMENT)) continue;
            PythonDep pythonDep = new PythonDep();
            pythonDep.setDependency(condaCommand.getLib());
            pythonDep.setInstallType(condaCommand.getInstallType());
            pythonDep.setPreinstalled(false);
            AnacondaRepo repo = this.libraryFacade.getRepo(condaCommand.getChannelUrl(), false);
            pythonDep.setRepoUrl(repo);
            pythonDep.setVersion(condaCommand.getVersion());
            pythonDep = this.libraryFacade.getOrCreateDep(pythonDep);
            if (project.getPythonDepCollection().contains(pythonDep)) continue;
            project.getPythonDepCollection().add(pythonDep);
        }
        return this.projectFacade.update(project);
    }

    public Collection<PythonDep> persistAndMarkImmutable(Collection<PythonDep> pyDepsInImage) {
        ArrayList<PythonDep> deps = new ArrayList<PythonDep>();
        for (PythonDep dep : pyDepsInImage) {
            PythonDep pyDep;
            String libraryName = dep.getDependency();
            if (this.settings.getImmutablePythonLibraryNames().contains(libraryName)) {
                pyDep = this.libraryFacade.getOrCreateDep(dep.getRepoUrl(), dep.getInstallType(), libraryName, dep.getVersion(), true, true);
                deps.add(pyDep);
                continue;
            }
            pyDep = this.libraryFacade.getOrCreateDep(dep);
            deps.add(pyDep);
        }
        return deps;
    }

    public String condaList(String dockerImage) throws IOException {
        String prog = this.settings.getSudoersDir() + "/dockerImage.sh";
        ProcessDescriptor processDescriptor = new ProcessDescriptor.Builder().addCommand("/usr/bin/sudo").addCommand(prog).addCommand("list").addCommand(dockerImage).redirectErrorStream(true).setWaitTimeout(30L, TimeUnit.MINUTES).build();
        ProcessResult processResult = this.osProcessExecutor.execute(processDescriptor);
        if (processResult.getExitCode() != 0) {
            String errorMsg = "Could list libraries in the docker image. Try to retry the command or recreate the environment\n Exit code: " + processResult.getExitCode() + "\nout: " + processResult.getStdout() + "\nerr: " + processResult.getStderr() + "||\n";
            throw new IOException(errorMsg);
        }
        return processResult.getStdout();
    }

    public boolean isPyPiIndexed() {
        return this.pypiIndexer.isIndexed();
    }

    public static interface HandlerFactory<R, S1, S2> {
        public ElasticHits.Handler<R, S1> getHandler();

        public S2 checkedResult(Pair<Long, Try<S1>> var1) throws ServiceException;

        public static class BaseList
        implements HandlerFactory<String[], List<String[]>, String[]> {
            @Override
            public ElasticHits.Handler<String[], List<String[]>> getHandler() {
                ElasticHits.Parser parser = hit -> LibraryController.tryInstance(BasicElasticHit.instance(hit));
                return ElasticHits.handlerAddToList(parser);
            }

            @Override
            public String[] checkedResult(Pair<Long, Try<List<String[]>>> result) throws ServiceException {
                try {
                    ArrayList<String> hits = new ArrayList<String>();
                    for (String[] lib : (List)((Try)result.getValue1()).checkedGet()) {
                        hits.add(lib[0]);
                    }
                    return hits.toArray(new String[0]);
                }
                catch (Throwable t) {
                    throw new ServiceException(RESTCodes.ServiceErrorCode.ANACONDA_LIST_LIB_ERROR, Level.WARNING, "Failed to list libraries");
                }
            }
        }
    }
}

