/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.trainingdatasets;

import com.logicalclocks.shaded.com.google.common.collect.Streams;
import io.hops.hopsworks.common.featurestore.FeaturestoreFacade;
import io.hops.hopsworks.common.featurestore.activity.FeaturestoreActivityFacade;
import io.hops.hopsworks.common.featurestore.feature.TrainingDatasetFeatureDTO;
import io.hops.hopsworks.common.featurestore.featuregroup.FeaturegroupController;
import io.hops.hopsworks.common.featurestore.featuregroup.FeaturegroupDTO;
import io.hops.hopsworks.common.featurestore.featuregroup.online.OnlineFeaturegroupController;
import io.hops.hopsworks.common.featurestore.online.OnlineFeaturestoreController;
import io.hops.hopsworks.common.featurestore.query.ConstructorController;
import io.hops.hopsworks.common.featurestore.query.Feature;
import io.hops.hopsworks.common.featurestore.query.Query;
import io.hops.hopsworks.common.featurestore.query.QueryDTO;
import io.hops.hopsworks.common.featurestore.query.filter.Filter;
import io.hops.hopsworks.common.featurestore.query.filter.FilterLogic;
import io.hops.hopsworks.common.featurestore.query.filter.FilterValue;
import io.hops.hopsworks.common.featurestore.query.join.Join;
import io.hops.hopsworks.common.featurestore.query.pit.PitJoinController;
import io.hops.hopsworks.common.featurestore.statistics.StatisticsController;
import io.hops.hopsworks.common.featurestore.statistics.columns.StatisticColumnController;
import io.hops.hopsworks.common.featurestore.storageconnectors.FeaturestoreConnectorFacade;
import io.hops.hopsworks.common.featurestore.trainingdatasets.TrainingDatasetDTO;
import io.hops.hopsworks.common.featurestore.trainingdatasets.TrainingDatasetFacade;
import io.hops.hopsworks.common.featurestore.trainingdatasets.TrainingDatasetInputValidation;
import io.hops.hopsworks.common.featurestore.trainingdatasets.external.ExternalTrainingDatasetController;
import io.hops.hopsworks.common.featurestore.trainingdatasets.external.ExternalTrainingDatasetFacade;
import io.hops.hopsworks.common.featurestore.trainingdatasets.hopsfs.HopsfsTrainingDatasetController;
import io.hops.hopsworks.common.featurestore.trainingdatasets.hopsfs.HopsfsTrainingDatasetFacade;
import io.hops.hopsworks.common.featurestore.transformationFunction.TransformationFunctionFacade;
import io.hops.hopsworks.common.featurestore.utils.FeaturestoreUtils;
import io.hops.hopsworks.common.hdfs.DistributedFileSystemOps;
import io.hops.hopsworks.common.hdfs.DistributedFsService;
import io.hops.hopsworks.common.hdfs.HdfsUsersController;
import io.hops.hopsworks.common.hdfs.Utils;
import io.hops.hopsworks.common.hdfs.inode.InodeController;
import io.hops.hopsworks.common.provenance.core.HopsFSProvenanceController;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.exceptions.ProvenanceException;
import io.hops.hopsworks.exceptions.ServiceException;
import io.hops.hopsworks.persistence.entity.dataset.Dataset;
import io.hops.hopsworks.persistence.entity.featurestore.Featurestore;
import io.hops.hopsworks.persistence.entity.featurestore.activity.FeaturestoreActivityMeta;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.Featuregroup;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.FeaturegroupType;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.cached.TimeTravelFormat;
import io.hops.hopsworks.persistence.entity.featurestore.statistics.StatisticColumn;
import io.hops.hopsworks.persistence.entity.featurestore.statistics.StatisticsConfig;
import io.hops.hopsworks.persistence.entity.featurestore.storageconnector.FeaturestoreConnector;
import io.hops.hopsworks.persistence.entity.featurestore.storageconnector.FeaturestoreConnectorType;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.SqlFilterLogic;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.TrainingDataset;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.TrainingDatasetFeature;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.TrainingDatasetFilter;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.TrainingDatasetFilterCondition;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.TrainingDatasetJoin;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.TrainingDatasetJoinCondition;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.TrainingDatasetType;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.external.ExternalTrainingDataset;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.hopsfs.HopsfsTrainingDataset;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.split.TrainingDatasetSplit;
import io.hops.hopsworks.persistence.entity.featurestore.transformationFunction.TransformationFunction;
import io.hops.hopsworks.persistence.entity.hdfs.inode.Inode;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.calcite.sql.JoinType;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class TrainingDatasetController {
    @EJB
    private TrainingDatasetFacade trainingDatasetFacade;
    @EJB
    private FeaturestoreFacade featurestoreFacade;
    @EJB
    private HopsfsTrainingDatasetController hopsfsTrainingDatasetController;
    @EJB
    private HopsfsTrainingDatasetFacade hopsfsTrainingDatasetFacade;
    @EJB
    private ExternalTrainingDatasetController externalTrainingDatasetController;
    @EJB
    private ExternalTrainingDatasetFacade externalTrainingDatasetFacade;
    @EJB
    private TrainingDatasetInputValidation trainingDatasetInputValidation;
    @EJB
    private InodeController inodeController;
    @EJB
    private HopsFSProvenanceController fsProvenanceController;
    @EJB
    private DistributedFsService dfs;
    @EJB
    private HdfsUsersController hdfsUsersBean;
    @EJB
    private FeaturestoreUtils featurestoreUtils;
    @EJB
    private StatisticsController statisticsController;
    @EJB
    private ConstructorController constructorController;
    @EJB
    private OnlineFeaturestoreController onlineFeaturestoreController;
    @EJB
    private FeaturegroupController featuregroupController;
    @EJB
    private FeaturestoreConnectorFacade featurestoreConnectorFacade;
    @EJB
    private FeaturestoreActivityFacade fsActivityFacade;
    @EJB
    private StatisticColumnController statisticColumnController;
    @EJB
    private OnlineFeaturegroupController onlineFeaturegroupController;
    @EJB
    private TransformationFunctionFacade transformationFunctionFacade;
    @EJB
    private TrainingDatasetInputValidation inputValidation;
    @EJB
    private PitJoinController pitJoinController;

    public List<TrainingDatasetDTO> getTrainingDatasetsForFeaturestore(Users user, Project project, Featurestore featurestore) throws ServiceException, FeaturestoreException {
        ArrayList<TrainingDatasetDTO> trainingDatasets = new ArrayList<TrainingDatasetDTO>();
        for (TrainingDataset td : this.trainingDatasetFacade.findByFeaturestore(featurestore)) {
            trainingDatasets.add(this.convertTrainingDatasetToDTO(user, project, td));
        }
        return trainingDatasets;
    }

    private TrainingDatasetDTO convertTrainingDatasetToDTO(Users user, Project project, TrainingDataset trainingDataset) throws ServiceException, FeaturestoreException {
        TrainingDatasetDTO trainingDatasetDTO = new TrainingDatasetDTO(trainingDataset);
        String featurestoreName = this.featurestoreFacade.getHiveDbName(trainingDataset.getFeaturestore().getHiveDbId());
        trainingDatasetDTO.setFeaturestoreName(featurestoreName);
        List<TrainingDatasetFeature> tdFeatures = this.getFeaturesSorted(trainingDataset, true);
        Map<Integer, String> fsLookupTable = this.getFsLookupTableFeatures(tdFeatures);
        trainingDatasetDTO.setFeatures(tdFeatures.stream().map(f -> new TrainingDatasetFeatureDTO(this.checkPrefix((TrainingDatasetFeature)f), f.getType(), f.getFeatureGroup() != null ? new FeaturegroupDTO(f.getFeatureGroup().getFeaturestore().getId(), (String)fsLookupTable.get(f.getFeatureGroup().getFeaturestore().getId()), f.getFeatureGroup().getId(), f.getFeatureGroup().getName(), f.getFeatureGroup().getVersion(), this.onlineFeaturegroupController.onlineFeatureGroupTopicName(project.getId(), f.getFeatureGroup().getId(), Utils.getFeaturegroupName(f.getFeatureGroup()))) : null, f.getIndex(), f.isLabel())).collect(Collectors.toList()));
        switch (trainingDataset.getTrainingDatasetType()) {
            case HOPSFS_TRAINING_DATASET: {
                return this.hopsfsTrainingDatasetController.convertHopsfsTrainingDatasetToDTO(trainingDatasetDTO, trainingDataset);
            }
            case EXTERNAL_TRAINING_DATASET: {
                return this.externalTrainingDatasetController.convertExternalTrainingDatasetToDTO(user, project, trainingDatasetDTO, trainingDataset);
            }
        }
        throw new IllegalArgumentException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_TRAINING_DATASET_TYPE.getMessage() + ", Recognized training dataset types are: " + TrainingDatasetType.HOPSFS_TRAINING_DATASET + ", and: " + TrainingDatasetType.EXTERNAL_TRAINING_DATASET + ". The provided training dataset type was not recognized: " + trainingDataset.getTrainingDatasetType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TrainingDatasetDTO createTrainingDataset(Users user, Project project, Featurestore featurestore, TrainingDatasetDTO trainingDatasetDTO) throws FeaturestoreException, ProvenanceException, IOException, ServiceException {
        if (trainingDatasetDTO.getVersion() == null) {
            List<TrainingDataset> tdPrevious = this.trainingDatasetFacade.findByNameAndFeaturestoreOrderedDescVersion(trainingDatasetDTO.getName(), featurestore);
            if (tdPrevious != null && !tdPrevious.isEmpty()) {
                trainingDatasetDTO.setVersion(tdPrevious.get(0).getVersion() + 1);
            } else {
                trainingDatasetDTO.setVersion(1);
            }
        }
        if (this.trainingDatasetFacade.findByNameVersionAndFeaturestore(trainingDatasetDTO.getName(), trainingDatasetDTO.getVersion(), featurestore).isPresent()) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.TRAINING_DATASET_ALREADY_EXISTS, Level.FINE, "Training Dataset: " + trainingDatasetDTO.getName() + ", version: " + trainingDatasetDTO.getVersion());
        }
        Query query = null;
        if (trainingDatasetDTO.getQueryDTO() != null) {
            query = this.constructQuery(trainingDatasetDTO.getQueryDTO(), project, user);
        } else if (trainingDatasetDTO.getFeatures() == null) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.TRAINING_DATASET_NO_SCHEMA, Level.FINE, "The training dataset doesn't have any feature");
        }
        this.inputValidation.validate(trainingDatasetDTO, query);
        Inode inode = null;
        if (trainingDatasetDTO.getTrainingDatasetType() == TrainingDatasetType.HOPSFS_TRAINING_DATASET) {
            FeaturestoreConnector featurestoreConnector;
            if (trainingDatasetDTO.getStorageConnector() != null && trainingDatasetDTO.getStorageConnector().getId() != null) {
                featurestoreConnector = this.featurestoreConnectorFacade.findByIdType(trainingDatasetDTO.getStorageConnector().getId(), FeaturestoreConnectorType.HOPSFS).orElseThrow(() -> new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.HOPSFS_CONNECTOR_NOT_FOUND, Level.FINE, "HOPSFS Connector: " + trainingDatasetDTO.getStorageConnector().getId()));
            } else {
                String connectorName = featurestore.getProject().getName() + "_" + Settings.ServiceDataset.TRAININGDATASETS.getName();
                featurestoreConnector = this.featurestoreConnectorFacade.findByFeaturestoreName(featurestore, connectorName).orElseThrow(() -> new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.HOPSFS_CONNECTOR_NOT_FOUND, Level.FINE, "HOPSFS Connector: " + connectorName));
            }
            Dataset trainingDatasetsFolder = featurestoreConnector.getHopsfsConnector().getHopsfsDataset();
            String trainingDatasetPath = this.getTrainingDatasetPath(this.inodeController.getPath(trainingDatasetsFolder.getInode()), trainingDatasetDTO.getName(), trainingDatasetDTO.getVersion());
            DistributedFileSystemOps udfso = null;
            String username = this.hdfsUsersBean.getHdfsUserName(project, user);
            try {
                udfso = this.dfs.getDfsOps(username);
                udfso.mkdir(trainingDatasetPath);
                inode = this.inodeController.getInodeAtPath(trainingDatasetPath);
                TrainingDatasetDTO completeTrainingDatasetDTO = this.createTrainingDatasetMetadata(user, project, featurestore, trainingDatasetDTO, query, featurestoreConnector, inode);
                this.fsProvenanceController.trainingDatasetAttachXAttr(trainingDatasetPath, completeTrainingDatasetDTO, udfso);
                TrainingDatasetDTO trainingDatasetDTO2 = completeTrainingDatasetDTO;
                return trainingDatasetDTO2;
            }
            finally {
                if (udfso != null) {
                    this.dfs.closeDfsClient(udfso);
                }
            }
        }
        if (trainingDatasetDTO.getStorageConnector() == null) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.CONNECTOR_NOT_FOUND, Level.FINE, "Storage connector is empty");
        }
        FeaturestoreConnector featurestoreConnector = this.featurestoreConnectorFacade.findById(trainingDatasetDTO.getStorageConnector().getId()).orElseThrow(() -> new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.CONNECTOR_NOT_FOUND, Level.FINE, "Connector: " + trainingDatasetDTO.getStorageConnector().getId()));
        return this.createTrainingDatasetMetadata(user, project, featurestore, trainingDatasetDTO, query, featurestoreConnector, null);
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    private TrainingDatasetDTO createTrainingDatasetMetadata(Users user, Project project, Featurestore featurestore, TrainingDatasetDTO trainingDatasetDTO, Query query, FeaturestoreConnector featurestoreConnector, Inode inode) throws FeaturestoreException, ServiceException {
        HopsfsTrainingDataset hopsfsTrainingDataset = null;
        ExternalTrainingDataset externalTrainingDataset = null;
        switch (trainingDatasetDTO.getTrainingDatasetType()) {
            case HOPSFS_TRAINING_DATASET: {
                hopsfsTrainingDataset = this.hopsfsTrainingDatasetFacade.createHopsfsTrainingDataset(featurestoreConnector, inode);
                break;
            }
            case EXTERNAL_TRAINING_DATASET: {
                externalTrainingDataset = this.externalTrainingDatasetFacade.createExternalTrainingDataset(featurestoreConnector, trainingDatasetDTO.getLocation());
                break;
            }
            default: {
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_TRAINING_DATASET_TYPE, Level.FINE, ", Recognized training dataset types are: " + TrainingDatasetType.HOPSFS_TRAINING_DATASET + ", and: " + TrainingDatasetType.EXTERNAL_TRAINING_DATASET + ". The provided training dataset type was not recognized: " + trainingDatasetDTO.getTrainingDatasetType());
            }
        }
        TrainingDataset trainingDataset = new TrainingDataset();
        trainingDataset.setName(trainingDatasetDTO.getName());
        trainingDataset.setHopsfsTrainingDataset(hopsfsTrainingDataset);
        trainingDataset.setExternalTrainingDataset(externalTrainingDataset);
        trainingDataset.setDataFormat(trainingDatasetDTO.getDataFormat());
        trainingDataset.setDescription(trainingDatasetDTO.getDescription());
        trainingDataset.setFeaturestore(featurestore);
        trainingDataset.setCreated(new Date());
        trainingDataset.setCreator(user);
        trainingDataset.setVersion(trainingDatasetDTO.getVersion());
        trainingDataset.setTrainingDatasetType(trainingDatasetDTO.getTrainingDatasetType());
        trainingDataset.setSeed(trainingDatasetDTO.getSeed());
        trainingDataset.setSplits((Collection)trainingDatasetDTO.getSplits().stream().map(tdDTO -> new TrainingDatasetSplit(trainingDataset, tdDTO.getName(), tdDTO.getPercentage())).collect(Collectors.toList()));
        trainingDataset.setCoalesce(Boolean.valueOf(trainingDatasetDTO.getCoalesce() != null ? trainingDatasetDTO.getCoalesce() : false));
        StatisticsConfig statisticsConfig = new StatisticsConfig(trainingDatasetDTO.getStatisticsConfig().getEnabled().booleanValue(), trainingDatasetDTO.getStatisticsConfig().getCorrelations().booleanValue(), trainingDatasetDTO.getStatisticsConfig().getHistograms().booleanValue(), trainingDatasetDTO.getStatisticsConfig().getExactUniqueness().booleanValue());
        statisticsConfig.setTrainingDataset(trainingDataset);
        statisticsConfig.setStatisticColumns((Collection)trainingDatasetDTO.getStatisticsConfig().getColumns().stream().map(sc -> new StatisticColumn(statisticsConfig, sc)).collect(Collectors.toList()));
        trainingDataset.setStatisticsConfig(statisticsConfig);
        trainingDataset.setTrainSplit(trainingDatasetDTO.getTrainSplit());
        trainingDataset.setQuery(trainingDatasetDTO.getQueryDTO() != null);
        if (trainingDataset.isQuery()) {
            this.setTrainingDatasetQuery(query, trainingDatasetDTO.getFeatures(), trainingDataset);
        } else {
            trainingDataset.setFeatures(this.getTrainingDatasetFeatures(trainingDatasetDTO.getFeatures(), trainingDataset));
        }
        TrainingDataset dbTrainingDataset = this.trainingDatasetFacade.update(trainingDataset);
        this.fsActivityFacade.logMetadataActivity(user, dbTrainingDataset, FeaturestoreActivityMeta.TD_CREATED);
        return this.convertTrainingDatasetToDTO(user, project, dbTrainingDataset);
    }

    private Query constructQuery(QueryDTO queryDTO, Project project, Users user) throws FeaturestoreException {
        HashMap<Integer, String> fgAliasLookup = new HashMap<Integer, String>();
        HashMap<Integer, Featuregroup> fgLookup = new HashMap<Integer, Featuregroup>();
        HashMap<Integer, List<Feature>> availableFeatureLookup = new HashMap<Integer, List<Feature>>();
        this.constructorController.populateFgLookupTables(queryDTO, 0, fgAliasLookup, fgLookup, availableFeatureLookup, project, user, null);
        return this.constructorController.convertQueryDTO(queryDTO, fgAliasLookup, fgLookup, availableFeatureLookup, this.pitJoinController.isPitEnabled(queryDTO));
    }

    private void setTrainingDatasetQuery(Query query, List<TrainingDatasetFeatureDTO> features, TrainingDataset trainingDataset) throws FeaturestoreException {
        List<TrainingDatasetJoin> tdJoins = this.collectJoins(query, trainingDataset);
        trainingDataset.setJoins(tdJoins);
        List<TrainingDatasetFeature> tdFeatures = this.collectFeatures(query, features, trainingDataset, 0, tdJoins, 0);
        trainingDataset.setFeatures(tdFeatures);
        List<TrainingDatasetFilter> filters = this.convertToFilterEntities(query.getFilter(), trainingDataset, "L");
        trainingDataset.setFilters(filters);
    }

    List<TrainingDatasetFilter> convertToFilterEntities(FilterLogic filterLogic, TrainingDataset trainingDataset, String path) {
        ArrayList<TrainingDatasetFilter> filters = new ArrayList<TrainingDatasetFilter>();
        if (filterLogic == null) {
            return filters;
        }
        if (filterLogic.getType().equals((Object)SqlFilterLogic.SINGLE)) {
            if (filterLogic.getLeftFilter() == null) {
                filters.add(this.makeTrainingDatasetFilter(path, trainingDataset, filterLogic.getRightFilter(), SqlFilterLogic.SINGLE));
            } else {
                filters.add(this.makeTrainingDatasetFilter(path, trainingDataset, filterLogic.getLeftFilter(), filterLogic.getType()));
            }
        } else {
            filters.add(this.makeTrainingDatasetFilter(path, trainingDataset, null, filterLogic.getType()));
            if (filterLogic.getLeftFilter() != null) {
                filters.add(this.makeTrainingDatasetFilter(path + ".L", trainingDataset, filterLogic.getLeftFilter(), SqlFilterLogic.SINGLE));
            }
            if (filterLogic.getRightFilter() != null) {
                filters.add(this.makeTrainingDatasetFilter(path + ".R", trainingDataset, filterLogic.getRightFilter(), SqlFilterLogic.SINGLE));
            }
            filters.addAll(this.convertToFilterEntities(filterLogic.getLeftLogic(), trainingDataset, path + ".L"));
            filters.addAll(this.convertToFilterEntities(filterLogic.getRightLogic(), trainingDataset, path + ".R"));
        }
        return filters;
    }

    private TrainingDatasetFilter makeTrainingDatasetFilter(String path, TrainingDataset trainingDataset, Filter filter, SqlFilterLogic type) {
        TrainingDatasetFilter trainingDatasetFilter = new TrainingDatasetFilter(trainingDataset);
        TrainingDatasetFilterCondition condition = filter == null ? null : this.convertFilter(filter, trainingDatasetFilter);
        trainingDatasetFilter.setCondition(condition);
        trainingDatasetFilter.setPath(path);
        trainingDatasetFilter.setType(type);
        return trainingDatasetFilter;
    }

    private TrainingDatasetFilterCondition convertFilter(Filter filter, TrainingDatasetFilter trainingDatasetFilter) {
        return new TrainingDatasetFilterCondition(trainingDatasetFilter, filter.getFeatures().get(0).getFeatureGroup(), filter.getFeatures().get(0).getName(), filter.getCondition(), filter.getValue().getFeatureGroupId(), filter.getValue().getValue());
    }

    private List<TrainingDatasetFeature> collectFeatures(Query query, List<TrainingDatasetFeatureDTO> featureDTOs, TrainingDataset trainingDataset, int featureIndex, List<TrainingDatasetJoin> tdJoins, int joinIndex) throws FeaturestoreException {
        ArrayList<TrainingDatasetFeature> features = new ArrayList<TrainingDatasetFeature>();
        boolean isLabel = false;
        TransformationFunction transformationFunction = null;
        for (Feature f : query.getFeatures()) {
            if (featureDTOs != null && !featureDTOs.isEmpty()) {
                isLabel = featureDTOs.stream().anyMatch(dto -> f.getName().equals(dto.getName()) && dto.getLabel() != false);
                transformationFunction = this.getTransformationFunction(f, featureDTOs);
            }
            features.add(new TrainingDatasetFeature(trainingDataset, tdJoins.get(joinIndex), query.getFeaturegroup(), f.getName(), f.getType(), Integer.valueOf(featureIndex++), isLabel, transformationFunction));
        }
        if (query.getJoins() != null) {
            for (Join join : query.getJoins()) {
                List<TrainingDatasetFeature> joinFeatures = this.collectFeatures(join.getRightQuery(), featureDTOs, trainingDataset, featureIndex, tdJoins, ++joinIndex);
                features.addAll(joinFeatures);
                featureIndex += joinFeatures.size();
            }
        }
        return features;
    }

    private List<TrainingDatasetJoin> collectJoins(Query query, TrainingDataset trainingDataset) {
        ArrayList<TrainingDatasetJoin> joins = new ArrayList<TrainingDatasetJoin>();
        int index = 0;
        if (query.getFeaturegroup().getFeaturegroupType() == FeaturegroupType.CACHED_FEATURE_GROUP && query.getFeaturegroup().getCachedFeaturegroup().getTimeTravelFormat() == TimeTravelFormat.HUDI) {
            joins.add(new TrainingDatasetJoin(trainingDataset, query.getFeaturegroup(), query.getLeftFeatureGroupEndCommitId(), 0, index++, null));
        } else {
            joins.add(new TrainingDatasetJoin(trainingDataset, query.getFeaturegroup(), 0, index++, null));
        }
        if (query.getJoins() != null && !query.getJoins().isEmpty()) {
            for (Join join : query.getJoins()) {
                TrainingDatasetJoin tdJoin = query.getFeaturegroup().getFeaturegroupType() == FeaturegroupType.CACHED_FEATURE_GROUP && query.getFeaturegroup().getCachedFeaturegroup().getTimeTravelFormat() == TimeTravelFormat.HUDI ? new TrainingDatasetJoin(trainingDataset, join.getRightQuery().getFeaturegroup(), join.getRightQuery().getLeftFeatureGroupEndCommitId(), (short)join.getJoinType().ordinal(), index++, join.getPrefix()) : new TrainingDatasetJoin(trainingDataset, join.getRightQuery().getFeaturegroup(), (short)join.getJoinType().ordinal(), index++, join.getPrefix());
                tdJoin.setConditions(this.collectJoinConditions(join, tdJoin));
                joins.add(tdJoin);
            }
        }
        return joins;
    }

    private List<TrainingDatasetJoinCondition> collectJoinConditions(Join join, TrainingDatasetJoin tdJoin) {
        return Streams.zip(join.getLeftOn().stream(), join.getRightOn().stream(), (left, right) -> new TrainingDatasetJoinCondition(tdJoin, left.getName(), right.getName())).collect(Collectors.toList());
    }

    private List<TrainingDatasetFeature> getTrainingDatasetFeatures(List<TrainingDatasetFeatureDTO> featureList, TrainingDataset trainingDataset) {
        ArrayList<TrainingDatasetFeature> trainingDatasetFeatureList = new ArrayList<TrainingDatasetFeature>();
        int index = 0;
        for (TrainingDatasetFeatureDTO f : featureList) {
            trainingDatasetFeatureList.add(new TrainingDatasetFeature(trainingDataset, f.getName(), f.getType(), Integer.valueOf(index++), f.getLabel().booleanValue(), null));
        }
        return trainingDatasetFeatureList;
    }

    public TrainingDatasetDTO getTrainingDatasetWithIdAndFeaturestore(Users user, Project project, Featurestore featurestore, Integer id) throws FeaturestoreException, ServiceException {
        TrainingDataset trainingDataset = this.getTrainingDatasetById(featurestore, id);
        return this.convertTrainingDatasetToDTO(user, project, trainingDataset);
    }

    public TrainingDataset getTrainingDatasetById(Featurestore featurestore, Integer id) throws FeaturestoreException {
        return this.trainingDatasetFacade.findByIdAndFeaturestore(id, featurestore).orElseThrow(() -> new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.TRAINING_DATASET_NOT_FOUND, Level.FINE, "trainingDatasetId: " + id));
    }

    public List<TrainingDatasetDTO> getWithNameAndFeaturestore(Users user, Project project, Featurestore featurestore, String name) throws FeaturestoreException, ServiceException {
        List<TrainingDataset> trainingDatasetList = this.trainingDatasetFacade.findByNameAndFeaturestore(name, featurestore);
        if (trainingDatasetList == null || trainingDatasetList.isEmpty()) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.TRAINING_DATASET_NOT_FOUND, Level.FINE, "training dataset name : " + name);
        }
        ArrayList<TrainingDatasetDTO> trainingDatasetDTOS = new ArrayList<TrainingDatasetDTO>();
        for (TrainingDataset td : trainingDatasetList) {
            trainingDatasetDTOS.add(this.convertTrainingDatasetToDTO(user, project, td));
        }
        return trainingDatasetDTOS;
    }

    public TrainingDatasetDTO getWithNameVersionAndFeaturestore(Users user, Project project, Featurestore featurestore, String name, Integer version) throws FeaturestoreException, ServiceException {
        Optional<TrainingDataset> trainingDataset = this.trainingDatasetFacade.findByNameVersionAndFeaturestore(name, version, featurestore);
        return this.convertTrainingDatasetToDTO(user, project, trainingDataset.orElseThrow(() -> new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.TRAINING_DATASET_NOT_FOUND, Level.FINE, "training dataset name : " + name)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String delete(Users user, Project project, Featurestore featurestore, Integer trainingDatasetId) throws FeaturestoreException {
        TrainingDataset trainingDataset = this.trainingDatasetFacade.findByIdAndFeaturestore(trainingDatasetId, featurestore).orElseThrow(() -> new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.TRAINING_DATASET_NOT_FOUND, Level.FINE, "training dataset id:" + trainingDatasetId));
        this.featurestoreUtils.verifyUserRole(trainingDataset, featurestore, user, project);
        this.statisticsController.deleteStatistics(project, user, trainingDataset);
        this.trainingDatasetFacade.removeTrainingDataset(trainingDataset);
        if (trainingDataset.getTrainingDatasetType() == TrainingDatasetType.HOPSFS_TRAINING_DATASET) {
            String dsPath = this.inodeController.getPath(trainingDataset.getHopsfsTrainingDataset().getInode());
            String username = this.hdfsUsersBean.getHdfsUserName(project, user);
            DistributedFileSystemOps udfso = this.dfs.getDfsOps(username);
            try {
                udfso.rm(dsPath, true);
            }
            catch (IOException iOException) {
            }
            finally {
                if (udfso != null) {
                    this.dfs.closeDfsClient(udfso);
                }
            }
        }
        return trainingDataset.getName();
    }

    public TrainingDatasetDTO updateTrainingDatasetMetadata(Users user, Project project, Featurestore featurestore, TrainingDatasetDTO trainingDatasetDTO) throws FeaturestoreException, ServiceException {
        TrainingDataset trainingDataset = this.trainingDatasetFacade.findByIdAndFeaturestore(trainingDatasetDTO.getId(), featurestore).orElseThrow(() -> new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.TRAINING_DATASET_NOT_FOUND, Level.FINE, "training dataset id: " + trainingDatasetDTO.getId()));
        this.trainingDatasetInputValidation.verifyUserInput(trainingDatasetDTO);
        trainingDataset.setDescription(trainingDatasetDTO.getDescription());
        this.trainingDatasetFacade.update(trainingDataset);
        TrainingDataset updatedTrainingDataset = this.trainingDatasetFacade.findByIdAndFeaturestore(trainingDatasetDTO.getId(), featurestore).orElseThrow(() -> new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.TRAINING_DATASET_NOT_FOUND, Level.FINE, "training dataset id: " + trainingDatasetDTO.getId()));
        return this.convertTrainingDatasetToDTO(user, project, updatedTrainingDataset);
    }

    public TrainingDatasetDTO updateTrainingDatasetStatsConfig(Users user, Project project, Featurestore featurestore, TrainingDatasetDTO trainingDatasetDTO) throws FeaturestoreException, ServiceException {
        TrainingDataset trainingDataset = this.getTrainingDatasetById(featurestore, trainingDatasetDTO.getId());
        if (trainingDatasetDTO.getStatisticsConfig().getEnabled() != null) {
            trainingDataset.getStatisticsConfig().setDescriptive(trainingDatasetDTO.getStatisticsConfig().getEnabled().booleanValue());
        }
        if (trainingDatasetDTO.getStatisticsConfig().getHistograms() != null) {
            trainingDataset.getStatisticsConfig().setHistograms(trainingDatasetDTO.getStatisticsConfig().getHistograms().booleanValue());
        }
        if (trainingDatasetDTO.getStatisticsConfig().getCorrelations() != null) {
            trainingDataset.getStatisticsConfig().setCorrelations(trainingDatasetDTO.getStatisticsConfig().getCorrelations().booleanValue());
        }
        if (trainingDatasetDTO.getStatisticsConfig().getExactUniqueness() != null) {
            trainingDataset.getStatisticsConfig().setExactUniqueness(trainingDatasetDTO.getStatisticsConfig().getExactUniqueness().booleanValue());
        }
        this.statisticColumnController.verifyStatisticColumnsExist(trainingDatasetDTO, trainingDataset);
        trainingDataset = this.trainingDatasetFacade.update(trainingDataset);
        this.statisticColumnController.persistStatisticColumns(trainingDataset, trainingDatasetDTO.getStatisticsConfig().getColumns());
        trainingDataset = this.getTrainingDatasetById(featurestore, trainingDatasetDTO.getId());
        return this.convertTrainingDatasetToDTO(user, project, trainingDataset);
    }

    public String getTrainingDatasetFolderName(Project project) {
        return project.getName() + "_" + Settings.ServiceDataset.TRAININGDATASETS.getName();
    }

    public String getTrainingDatasetPath(String trainingDatasetsFolderPath, String trainingDatasetName, Integer version) {
        return trainingDatasetsFolderPath + "/" + trainingDatasetName + "_" + version;
    }

    public Query getQuery(TrainingDataset trainingDataset, boolean withLabel, Project project, Users user, Boolean isHiveEngine) throws FeaturestoreException {
        if (!trainingDataset.isQuery()) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.TRAINING_DATASET_NO_QUERY, Level.FINE, "Inference vector is only available for datasets generated by queries");
        }
        List<TrainingDatasetJoin> joins = this.getJoinsSorted(trainingDataset);
        Map<Integer, String> fgAliasLookup = this.getAliasLookupTable(joins);
        List<TrainingDatasetFeature> tdFeatures = this.getFeaturesSorted(trainingDataset, withLabel);
        if (tdFeatures.stream().anyMatch(j -> j.getFeatureGroup() == null)) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.TRAINING_DATASET_QUERY_FG_DELETED, Level.FINE);
        }
        HashMap<Integer, List<Feature>> availableFeaturesLookup = new HashMap<Integer, List<Feature>>();
        for (TrainingDatasetJoin join : joins) {
            if (availableFeaturesLookup.containsKey(join.getFeatureGroup().getId())) continue;
            List availableFeatures = this.featuregroupController.getFeatures(join.getFeatureGroup(), project, user).stream().map(f -> new Feature(f.getName(), (String)fgAliasLookup.get(join.getId()), f.getType(), f.getDefaultValue(), f.getPrimary(), join.getFeatureGroup(), join.getPrefix())).collect(Collectors.toList());
            availableFeaturesLookup.put(join.getFeatureGroup().getId(), availableFeatures);
        }
        Map<String, Feature> featureLookup = availableFeaturesLookup.values().stream().flatMap(Collection::stream).collect(Collectors.toMap(f -> this.makeFeatureLookupKey(f.getFeatureGroup().getId(), f.getName()), f -> f, (f1, f2) -> f1));
        ArrayList<Feature> features = new ArrayList<Feature>();
        for (TrainingDatasetFeature requestedFeature : tdFeatures) {
            Feature tdFeature = featureLookup.get(this.makeFeatureLookupKey(requestedFeature.getFeatureGroup().getId(), requestedFeature.getName()));
            if (tdFeature == null) {
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FEATURE_DOES_NOT_EXIST, Level.FINE, "Feature: " + requestedFeature.getName() + " not found in feature group: " + requestedFeature.getFeatureGroup().getName());
            }
            new Feature(tdFeature.getName(), fgAliasLookup.get(requestedFeature.getTrainingDatasetJoin().getId()), tdFeature.getType(), tdFeature.getDefaultValue(), tdFeature.getPrefix(), requestedFeature.getFeatureGroup(), requestedFeature.getIndex());
            features.add(tdFeature);
        }
        Map<Integer, String> fsLookup = this.getFsLookupTableJoins(joins);
        Query query = new Query(fsLookup.get(joins.get(0).getFeatureGroup().getFeaturestore().getId()), this.onlineFeaturestoreController.getOnlineFeaturestoreDbName(joins.get(0).getFeatureGroup().getFeaturestore().getProject()), joins.get(0).getFeatureGroup(), fgAliasLookup.get(joins.get(0).getId()), features, (List)availableFeaturesLookup.get(joins.get(0).getFeatureGroup().getId()), isHiveEngine);
        ArrayList<Join> queryJoins = new ArrayList<Join>();
        for (int i = 1; i < joins.size(); ++i) {
            queryJoins.add(this.getQueryJoin(query, joins.get(i), fgAliasLookup, fsLookup, availableFeaturesLookup, isHiveEngine));
        }
        query.setJoins(queryJoins);
        FilterLogic filterLogic = this.convertToFilterLogic(trainingDataset.getFilters(), featureLookup, "L");
        query.setFilter(filterLogic);
        return query;
    }

    FilterLogic convertToFilterLogic(Collection<TrainingDatasetFilter> trainingDatasetFilters, Map<String, Feature> features, String headPath) throws FeaturestoreException {
        FilterLogic filterLogic = new FilterLogic();
        TrainingDatasetFilter headNode = trainingDatasetFilters.stream().filter(filter -> filter.getPath().equals(headPath)).findFirst().orElseThrow(() -> new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.COULD_NOT_GET_QUERY_FILTER, Level.WARNING));
        filterLogic.setType(headNode.getType());
        if (headNode.getType().equals((Object)SqlFilterLogic.SINGLE)) {
            Filter filter2 = this.convertToFilter(headNode.getCondition(), features);
            filterLogic.setLeftFilter(filter2);
        } else {
            List<TrainingDatasetFilter> leftChildren = trainingDatasetFilters.stream().filter(filter -> filter.getPath().startsWith(headPath + ".L")).collect(Collectors.toList());
            List<TrainingDatasetFilter> rightChildren = trainingDatasetFilters.stream().filter(filter -> filter.getPath().startsWith(headPath + ".R")).collect(Collectors.toList());
            if (!leftChildren.isEmpty()) {
                if (leftChildren.size() == 1) {
                    filterLogic.setLeftFilter(this.convertToFilter(((TrainingDatasetFilter)leftChildren.get(0)).getCondition(), features));
                } else {
                    filterLogic.setLeftLogic(this.convertToFilterLogic(leftChildren, features, headPath + ".L"));
                }
            }
            if (!rightChildren.isEmpty()) {
                if (rightChildren.size() == 1) {
                    filterLogic.setRightFilter(this.convertToFilter(((TrainingDatasetFilter)rightChildren.get(0)).getCondition(), features));
                } else {
                    filterLogic.setRightLogic(this.convertToFilterLogic(rightChildren, features, headPath + ".R"));
                }
            }
        }
        return filterLogic;
    }

    private Filter convertToFilter(TrainingDatasetFilterCondition condition, Map<String, Feature> features) {
        FilterValue filterValue;
        if (condition.getValueFeatureGroupId() == null) {
            filterValue = new FilterValue(condition.getValue());
        } else {
            Feature filterValueFeature = features.get(this.makeFeatureLookupKey(condition.getValueFeatureGroupId(), condition.getValue()));
            filterValue = new FilterValue(condition.getValueFeatureGroupId(), filterValueFeature.getFgAlias(), condition.getValue());
        }
        return new Filter(features.get(this.makeFeatureLookupKey(condition.getFeatureGroup().getId(), condition.getFeature())), condition.getCondition(), filterValue);
    }

    private String makeFeatureLookupKey(Integer featureGroupId, String featureName) {
        return featureGroupId + "." + featureName;
    }

    private Map<Integer, String> getAliasLookupTable(List<TrainingDatasetJoin> tdJoins) {
        int i = 0;
        HashMap<Integer, String> fgAlias = new HashMap<Integer, String>();
        for (TrainingDatasetJoin tdJoin : tdJoins) {
            fgAlias.put(tdJoin.getId(), "fg" + i++);
        }
        return fgAlias;
    }

    private Map<Integer, String> getFsLookupTableJoins(List<TrainingDatasetJoin> tdJoins) {
        HashMap<Integer, String> fsLookup = new HashMap<Integer, String>();
        for (TrainingDatasetJoin join : tdJoins) {
            if (fsLookup.containsKey(join.getFeatureGroup().getFeaturestore().getId())) continue;
            fsLookup.put(join.getFeatureGroup().getFeaturestore().getId(), this.featurestoreFacade.getHiveDbName(join.getFeatureGroup().getFeaturestore().getHiveDbId()));
        }
        return fsLookup;
    }

    private Map<Integer, String> getFsLookupTableFeatures(List<TrainingDatasetFeature> tdFeatures) {
        HashMap<Integer, String> fsLookup = new HashMap<Integer, String>();
        for (TrainingDatasetFeature tdFeature : tdFeatures) {
            if (tdFeature.getFeatureGroup() == null || fsLookup.containsKey(tdFeature.getFeatureGroup().getFeaturestore().getId())) continue;
            fsLookup.put(tdFeature.getFeatureGroup().getFeaturestore().getId(), this.featurestoreFacade.getHiveDbName(tdFeature.getFeatureGroup().getFeaturestore().getHiveDbId()));
        }
        return fsLookup;
    }

    public List<TrainingDatasetFeature> getFeaturesSorted(TrainingDataset trainingDataset, boolean withLabel) {
        return trainingDataset.getFeatures().stream().sorted((t1, t2) -> {
            if (t1.getIndex() != null) {
                return t1.getIndex().compareTo(t2.getIndex());
            }
            return t1.getName().compareTo(t2.getName());
        }).filter(f -> !f.isLabel() || withLabel).collect(Collectors.toList());
    }

    public List<TrainingDatasetJoin> getJoinsSorted(TrainingDataset trainingDataset) {
        return trainingDataset.getJoins().stream().sorted(Comparator.comparing(TrainingDatasetJoin::getIndex)).collect(Collectors.toList());
    }

    private Join getQueryJoin(Query leftQuery, TrainingDatasetJoin rightTdJoin, Map<Integer, String> fgAliasLookup, Map<Integer, String> fsLookup, Map<Integer, List<Feature>> availableFeaturesLookup, Boolean isHiveEngine) throws FeaturestoreException {
        String rightAs = fgAliasLookup.get(rightTdJoin.getId());
        Query rightQuery = new Query(fsLookup.get(rightTdJoin.getFeatureGroup().getFeaturestore().getId()), this.onlineFeaturestoreController.getOnlineFeaturestoreDbName(rightTdJoin.getFeatureGroup().getFeaturestore().getProject()), rightTdJoin.getFeatureGroup(), rightAs, new ArrayList<Feature>(), availableFeaturesLookup.get(rightTdJoin.getFeatureGroup().getId()), isHiveEngine);
        List<Feature> leftOn = rightTdJoin.getConditions().stream().map(c -> new Feature(c.getLeftFeature())).collect(Collectors.toList());
        List<Feature> rightOn = rightTdJoin.getConditions().stream().map(c -> new Feature(c.getRightFeature())).collect(Collectors.toList());
        JoinType joinType = JoinType.values()[rightTdJoin.getType()];
        return this.constructorController.extractLeftRightOn(leftQuery, rightQuery, leftOn, rightOn, joinType, rightTdJoin.getPrefix());
    }

    private TransformationFunction getTransformationFunction(Feature feature, List<TrainingDatasetFeatureDTO> featureDTOs) throws FeaturestoreException {
        TrainingDatasetFeatureDTO featureDTO = featureDTOs.stream().filter(dto -> feature.getName().equals(dto.getFeatureGroupFeatureName())).findFirst().orElse(null);
        TransformationFunction transformationFunction = null;
        if (featureDTO != null && featureDTO.getTransformationFunction() != null) {
            transformationFunction = this.transformationFunctionFacade.findById(featureDTO.getTransformationFunction().getId()).orElseThrow(() -> new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.TRANSFORMATION_FUNCTION_DOES_NOT_EXIST, Level.FINE, "Could not find transformation function with ID" + featureDTO.getTransformationFunction().getId()));
        }
        return transformationFunction;
    }

    public String checkPrefix(TrainingDatasetFeature feature) {
        if (feature.getTrainingDatasetJoin() != null && feature.getTrainingDatasetJoin().getPrefix() != null) {
            return feature.getTrainingDatasetJoin().getPrefix() + feature.getName();
        }
        return feature.getName();
    }
}

