/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.transformationFunction;

import io.hops.hopsworks.common.featurestore.FeaturestoreConstants;
import io.hops.hopsworks.common.featurestore.storageconnectors.FeaturestoreConnectorFacade;
import io.hops.hopsworks.common.featurestore.transformationFunction.TransformationFunctionDTO;
import io.hops.hopsworks.common.featurestore.transformationFunction.TransformationFunctionFacade;
import io.hops.hopsworks.common.hdfs.DistributedFileSystemOps;
import io.hops.hopsworks.common.hdfs.DistributedFsService;
import io.hops.hopsworks.common.hdfs.HdfsUsersController;
import io.hops.hopsworks.common.hdfs.Utils;
import io.hops.hopsworks.common.hdfs.inode.InodeController;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.persistence.entity.dataset.Dataset;
import io.hops.hopsworks.persistence.entity.featurestore.Featurestore;
import io.hops.hopsworks.persistence.entity.featurestore.storageconnector.FeaturestoreConnector;
import io.hops.hopsworks.persistence.entity.featurestore.storageconnector.FeaturestoreConnectorType;
import io.hops.hopsworks.persistence.entity.featurestore.transformationFunction.TransformationFunction;
import io.hops.hopsworks.persistence.entity.hdfs.inode.Inode;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.Path;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class TransformationFunctionController {
    @EJB
    private TransformationFunctionFacade transformationFunctionFacade;
    @EJB
    private InodeController inodeController;
    @EJB
    private DistributedFsService dfs;
    @EJB
    private HdfsUsersController hdfsUsersController;
    @EJB
    private FeaturestoreConnectorFacade featurestoreConnectorFacade;
    private static final String TRANSFORMATIONFUNCTIONS_FOLDER = "transformation_functions";

    public TransformationFunction register(Users user, Project project, Featurestore featurestore, TransformationFunctionDTO transformationFunctionDTO) throws FeaturestoreException, IOException {
        this.verifyTransformationFunctionInput(transformationFunctionDTO);
        Inode inode = this.create(user, project, featurestore, transformationFunctionDTO);
        return this.transformationFunctionFacade.register(transformationFunctionDTO.getName(), transformationFunctionDTO.getOutputType(), transformationFunctionDTO.getVersion(), featurestore, new Date(), user, inode);
    }

    public String readContent(Users user, Project project, TransformationFunction transformationFunction) throws FeaturestoreException {
        String path = this.inodeController.getPath(transformationFunction.getInode());
        DistributedFileSystemOps udfso = null;
        try {
            udfso = this.dfs.getDfsOps(this.hdfsUsersController.getHdfsUserName(project, user));
            String string = udfso.cat(path);
            this.dfs.closeDfsClient(udfso);
            return string;
        }
        catch (IOException e) {
            try {
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.TRANSFORMATION_FUNCTION_READ_ERROR, Level.WARNING, e.getMessage(), e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.dfs.closeDfsClient(udfso);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Inode create(Users user, Project project, Featurestore featurestore, TransformationFunctionDTO transformationFunctionDTO) throws IOException, FeaturestoreException {
        if (transformationFunctionDTO.getVersion() == null) {
            List transformationFnPrevious = this.transformationFunctionFacade.findByNameAndFeaturestoreOrderedDescVersion(transformationFunctionDTO.getName(), featurestore, 0).getItems();
            if (transformationFnPrevious != null && !transformationFnPrevious.isEmpty()) {
                transformationFunctionDTO.setVersion(((TransformationFunction)transformationFnPrevious.get(0)).getVersion() + 1);
            } else {
                transformationFunctionDTO.setVersion(1);
            }
        }
        if (this.transformationFunctionFacade.findByNameVersionAndFeaturestore(transformationFunctionDTO.getName(), transformationFunctionDTO.getVersion(), featurestore).isPresent()) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.TRANSFORMATION_FUNCTION_ALREADY_EXISTS, Level.FINE, "Transformation function: " + transformationFunctionDTO.getName() + ", version: " + transformationFunctionDTO.getVersion());
        }
        DistributedFileSystemOps udfso = null;
        try {
            udfso = this.dfs.getDfsOps(this.hdfsUsersController.getHdfsUserName(project, user));
            Path dirPath = new Path(this.getOrCreatePath(featurestore, udfso), Utils.getFeatureStoreEntityName(transformationFunctionDTO.getName(), transformationFunctionDTO.getVersion()));
            if (!udfso.isDir(dirPath.toString())) {
                udfso.mkdir(dirPath.toString());
            }
            Path filePath = new Path(dirPath, transformationFunctionDTO.getName() + ".json");
            udfso.create(filePath, transformationFunctionDTO.getSourceCodeContent());
            Inode inode = this.inodeController.getInodeAtPath(filePath.toString());
            this.dfs.closeDfsClient(udfso);
            return inode;
        }
        catch (Throwable throwable) {
            this.dfs.closeDfsClient(udfso);
            throw throwable;
        }
    }

    public void delete(Project project, Featurestore featurestore, Users user, Integer transformationFunctionId) throws FeaturestoreException {
        TransformationFunction transformationFunction = this.transformationFunctionFacade.findById(transformationFunctionId).orElseThrow(() -> new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.TRANSFORMATION_FUNCTION_DOES_NOT_EXIST, Level.FINE, "Could not find transformation function with ID" + transformationFunctionId));
        DistributedFileSystemOps udfso = null;
        try {
            udfso = this.dfs.getDfsOps(this.hdfsUsersController.getHdfsUserName(project, user));
            String dirName = Utils.getFeatureStoreEntityName(transformationFunction.getName(), transformationFunction.getVersion());
            Path dirPath = new Path(this.getOrCreatePath(featurestore, udfso), dirName);
            udfso.rm(dirPath, true);
            this.dfs.closeDfsClient(udfso);
        }
        catch (IOException e) {
            try {
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ERROR_DELETING_TRANSFORMERFUNCTION, Level.WARNING, "", e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.dfs.closeDfsClient(udfso);
                throw throwable;
            }
        }
    }

    private String getOrCreatePath(Featurestore featurestore, DistributedFileSystemOps udfso) throws IOException, FeaturestoreException {
        String connectorName = featurestore.getProject().getName() + "_" + Settings.ServiceDataset.TRAININGDATASETS.getName();
        FeaturestoreConnector featurestoreConnector = this.featurestoreConnectorFacade.findByFeaturestoreName(featurestore, connectorName).orElseThrow(() -> new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.HOPSFS_CONNECTOR_NOT_FOUND, Level.FINE, "HOPSFS Connector: " + FeaturestoreConnectorType.HOPSFS.name()));
        Dataset trainingDatasetsFolder = featurestoreConnector.getHopsfsConnector().getHopsfsDataset();
        String transformationFunctionDatasetPath = this.inodeController.getPath(trainingDatasetsFolder.getInode()) + "/" + TRANSFORMATIONFUNCTIONS_FOLDER;
        if (!udfso.exists(transformationFunctionDatasetPath)) {
            udfso.mkdir(transformationFunctionDatasetPath);
        }
        return transformationFunctionDatasetPath;
    }

    private void verifyTransformationFunctionInput(TransformationFunctionDTO transformationFunctionDTO) throws FeaturestoreException {
        this.verifyVersion(transformationFunctionDTO.getVersion());
        this.verifyOutputType(transformationFunctionDTO.getOutputType());
    }

    private void verifyVersion(Integer version) throws FeaturestoreException {
        if (version <= 0) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.TRANSFORMATION_FUNCTION_VERSION, Level.FINE, " version cannot be negative or zero");
        }
    }

    private void verifyOutputType(String outputType) throws FeaturestoreException {
        if (!FeaturestoreConstants.TRANSFORMATION_FUNCTION_OUTPUT_TYPES.contains(outputType)) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_TRANSFORMATION_FUNCTION_OUTPUT_TYPE, Level.FINE, ", the recognized transformation function output types are: " + StringUtils.join((Object[])new List[]{FeaturestoreConstants.TRANSFORMATION_FUNCTION_OUTPUT_TYPES}) + ". The provided output type:" + outputType + " was not recognized.");
        }
    }
}

