/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.online;

import com.logicalclocks.servicediscoverclient.exceptions.ServiceDiscoveryException;
import io.hops.hopsworks.common.dao.project.team.ProjectTeamFacade;
import io.hops.hopsworks.common.dao.user.UserFacade;
import io.hops.hopsworks.common.dao.user.security.secrets.SecretsFacade;
import io.hops.hopsworks.common.featurestore.featuregroup.cached.CachedFeaturegroupController;
import io.hops.hopsworks.common.featurestore.featuregroup.cached.FeaturegroupPreview;
import io.hops.hopsworks.common.featurestore.online.OnlineFeaturestoreFacade;
import io.hops.hopsworks.common.featurestore.storageconnectors.FeaturestoreConnectorFacade;
import io.hops.hopsworks.common.hosts.ServiceDiscoveryController;
import io.hops.hopsworks.common.security.secrets.SecretsController;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.exceptions.UserException;
import io.hops.hopsworks.persistence.entity.featurestore.Featurestore;
import io.hops.hopsworks.persistence.entity.featurestore.storageconnector.FeaturestoreConnector;
import io.hops.hopsworks.persistence.entity.featurestore.storageconnector.FeaturestoreConnectorType;
import io.hops.hopsworks.persistence.entity.featurestore.storageconnector.jdbc.FeaturestoreJdbcConnector;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.project.team.ProjectRoleTypes;
import io.hops.hopsworks.persistence.entity.project.team.ProjectTeam;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.persistence.entity.user.security.secrets.SecretId;
import io.hops.hopsworks.persistence.entity.user.security.secrets.VisibilityType;
import io.hops.hopsworks.restutils.RESTCodes;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.commons.lang3.RandomStringUtils;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class OnlineFeaturestoreController {
    private static final Logger LOGGER = Logger.getLogger(OnlineFeaturestoreController.class.getName());
    private static final String MYSQL_DRIVER = "com.mysql.cj.jdbc.Driver";
    private static final String MYSQL_JDBC = "jdbc:mysql://";
    private static final String MYSQL_PROPERTIES = "?useSSL=false&allowPublicKeyRetrieval=true";
    public static final String ONLINEFS_USERNAME = "onlinefs";
    @EJB
    private SecretsFacade secretsFacade;
    @EJB
    private Settings settings;
    @EJB
    private SecretsController secretsController;
    @EJB
    private OnlineFeaturestoreFacade onlineFeaturestoreFacade;
    @EJB
    private CachedFeaturegroupController cachedFeaturegroupController;
    @EJB
    private ProjectTeamFacade projectTeamFacade;
    @EJB
    private UserFacade userFacade;
    @EJB
    private ServiceDiscoveryController serviceDiscoveryController;
    @EJB
    private FeaturestoreConnectorFacade featurestoreConnectorFacade;

    @PostConstruct
    public void init() {
        try {
            Class.forName(MYSQL_DRIVER);
        }
        catch (ClassNotFoundException e) {
            LOGGER.log(Level.SEVERE, "Could not load the MySQL JDBC driver: com.mysql.cj.jdbc.Driver", e);
        }
    }

    private Connection initConnection(String databaseName, Project project, Users user) throws FeaturestoreException {
        String jdbcString = "";
        String dbUsername = this.onlineDbUsername(project, user);
        String password = "";
        try {
            password = this.secretsController.get(user, dbUsername).getPlaintext();
        }
        catch (UserException e) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FEATURESTORE_ONLINE_SECRETS_ERROR, Level.SEVERE, "Problem getting secrets for the JDBC connection to the online FS");
        }
        try {
            return DriverManager.getConnection(this.getJdbcURL(databaseName), dbUsername, password);
        }
        catch (ServiceDiscoveryException | SQLException e) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.COULD_NOT_INITIATE_MYSQL_CONNECTION_TO_ONLINE_FEATURESTORE, Level.SEVERE, "project: " + project.getName() + ", database: " + databaseName + ", db user:" + dbUsername + ", jdbcString: " + jdbcString, e.getMessage(), e);
        }
    }

    public void executeUpdateJDBCQuery(String query, String databaseName, Project project, Users user) throws FeaturestoreException, SQLException {
        Statement stmt = null;
        Connection conn = null;
        try {
            conn = this.initConnection(databaseName, project, user);
            stmt = conn.createStatement();
            stmt.executeUpdate(query);
        }
        catch (SQLException e) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.MYSQL_JDBC_UPDATE_STATEMENT_ERROR, Level.SEVERE, "project: " + project.getName() + ", Online featurestore database: " + databaseName + " jdbc query: " + query, e.getMessage(), (Throwable)e);
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            this.closeConnection(conn);
        }
    }

    public FeaturegroupPreview executeReadJDBCQuery(String query, String databaseName, Project project, Users user) throws SQLException, FeaturestoreException {
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = this.initConnection(databaseName, project, user);
            stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(query);
            FeaturegroupPreview featuregroupPreview = this.cachedFeaturegroupController.parseResultset(rs);
            return featuregroupPreview;
        }
        catch (SQLException e) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.MYSQL_JDBC_READ_QUERY_ERROR, Level.SEVERE, "project: " + project.getName() + ", mysql database: " + databaseName + " jdbc query: " + query, e.getMessage(), (Throwable)e);
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            this.closeConnection(conn);
        }
    }

    private void closeConnection(Connection conn) {
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, "Error closing MySQL JDBC connection: " + e);
        }
    }

    public void setupOnlineFeaturestore(Users user, Featurestore featurestore) throws FeaturestoreException {
        if (!this.settings.isOnlineFeaturestore().booleanValue()) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FEATURESTORE_ONLINE_NOT_ENABLED, Level.FINE, "Online feature store service is not enabled for this Hopsworks instance");
        }
        this.addOnlineFeatureStoreDB(this.getOnlineFeaturestoreDbName(featurestore.getProject()));
        this.createDatabaseUser(user, featurestore, ProjectRoleTypes.DATA_OWNER.getRole());
    }

    public void createDatabaseUser(Users user, Featurestore featurestore, String projectRole) throws FeaturestoreException {
        String db = this.getOnlineFeaturestoreDbName(featurestore.getProject());
        if (!this.checkIfDatabaseExists(db).booleanValue()) {
            return;
        }
        String dbUser = this.onlineDbUsername(featurestore.getProject(), user);
        String onlineFsPw = this.createOnlineFeaturestoreUserSecret(dbUser, user, featurestore.getProject());
        this.onlineFeaturestoreFacade.createOnlineFeaturestoreUser(dbUser, onlineFsPw);
        this.updateUserOnlineFeatureStoreDB(user, featurestore, projectRole);
    }

    private String createOnlineFeaturestoreUserSecret(String dbuser, Users user, Project project) throws FeaturestoreException {
        String onlineFsPw = this.generateRandomUserPw();
        try {
            this.secretsController.delete(user, dbuser);
            this.secretsController.add(user, dbuser, onlineFsPw, VisibilityType.PRIVATE, project.getId());
        }
        catch (UserException e) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FEATURESTORE_ONLINE_SECRETS_ERROR, Level.SEVERE, "Problem adding online featurestore password to hopsworks secretsmgr");
        }
        return onlineFsPw;
    }

    public String onlineDbUsername(Project project, Users user) {
        return this.onlineDbUsername(project.getName(), user.getUsername());
    }

    public String getOnlineFeaturestoreDbName(Project project) {
        return project.getName().toLowerCase();
    }

    private String onlineDbUsername(String project, String user) {
        String username = project + "_" + user;
        if (username.length() > 32) {
            username = username.substring(0, 31);
        }
        return username;
    }

    public void updateUserOnlineFeatureStoreDB(Users user, Featurestore featurestore, String projectRole) throws FeaturestoreException {
        String db = this.getOnlineFeaturestoreDbName(featurestore.getProject());
        if (!this.settings.isOnlineFeaturestore().booleanValue() || !this.checkIfDatabaseExists(db).booleanValue()) {
            return;
        }
        String dbuser = this.onlineDbUsername(featurestore.getProject(), user);
        this.onlineFeaturestoreFacade.revokeUserPrivileges(db, dbuser);
        if (projectRole.equals(ProjectRoleTypes.DATA_OWNER.getRole())) {
            this.onlineFeaturestoreFacade.grantDataOwnerPrivileges(db, dbuser);
        } else {
            this.onlineFeaturestoreFacade.grantDataScientistPrivileges(db, dbuser);
        }
        try {
            this.createJdbcConnectorForOnlineFeaturestore(dbuser, featurestore, db);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addOnlineFeatureStoreDB(String db) throws FeaturestoreException {
        if (!this.settings.isOnlineFeaturestore().booleanValue()) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FEATURESTORE_ONLINE_NOT_ENABLED, Level.FINE, "Online Feature Store is not enabled");
        }
        this.onlineFeaturestoreFacade.createOnlineFeaturestoreDatabase(db);
    }

    public void createJdbcConnectorForOnlineFeaturestore(String onlineDbUsername, Featurestore featurestore, String dbName) throws FeaturestoreException {
        String connectorName = onlineDbUsername + "_onlinefeaturestore";
        if (this.featurestoreConnectorFacade.findByFeaturestoreName(featurestore, connectorName).isPresent()) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STORAGE_CONNECTOR_NAME, Level.FINE, "a storage connector with that name already exists");
        }
        FeaturestoreConnector featurestoreConnector = new FeaturestoreConnector();
        featurestoreConnector.setName(connectorName);
        featurestoreConnector.setDescription("JDBC connection to Hopsworks Project Online Feature Store NDB Database for user: " + onlineDbUsername);
        featurestoreConnector.setFeaturestore(featurestore);
        featurestoreConnector.setConnectorType(FeaturestoreConnectorType.JDBC);
        FeaturestoreJdbcConnector featurestoreJdbcConnector = new FeaturestoreJdbcConnector();
        featurestoreJdbcConnector.setConnectionString(this.settings.getFeaturestoreJdbcUrl() + dbName + MYSQL_PROPERTIES);
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("password", "<SECRETPASSWORD>");
        arguments.put("user", onlineDbUsername);
        arguments.put("driver", MYSQL_DRIVER);
        arguments.put("isolationLevel", "NONE");
        arguments.put("batchsize", "500");
        featurestoreJdbcConnector.setArguments(arguments.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining(",")));
        featurestoreConnector.setJdbcConnector(featurestoreJdbcConnector);
        this.featurestoreConnectorFacade.update(featurestoreConnector);
    }

    public void removeOnlineFeatureStore(Project project) throws FeaturestoreException {
        if (!this.settings.isOnlineFeaturestore().booleanValue() || !this.checkIfDatabaseExists(this.getOnlineFeaturestoreDbName(project)).booleanValue()) {
            return;
        }
        for (ProjectTeam member : this.projectTeamFacade.findMembersByProject(project)) {
            String dbUser = this.onlineDbUsername(project, member.getUser());
            try {
                this.secretsController.delete(member.getUser(), dbUser);
            }
            catch (UserException e) {
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FEATURESTORE_ONLINE_SECRETS_ERROR, Level.SEVERE, "Problem removing user-secret to online featurestore");
            }
            this.onlineFeaturestoreFacade.removeOnlineFeaturestoreUser(dbUser);
        }
        String db = this.getOnlineFeaturestoreDbName(project);
        this.onlineFeaturestoreFacade.removeOnlineFeaturestoreDatabase(db);
    }

    public void removeOnlineFeaturestoreUser(Featurestore featurestore, Users user) throws FeaturestoreException {
        String db = this.getOnlineFeaturestoreDbName(featurestore.getProject());
        if (!this.checkIfDatabaseExists(db).booleanValue()) {
            return;
        }
        String dbUser = this.onlineDbUsername(featurestore.getProject().getName(), user.getUsername());
        SecretId id = new SecretId(user.getUid(), dbUser);
        this.secretsFacade.deleteSecret(id);
        this.onlineFeaturestoreFacade.removeOnlineFeaturestoreUser(dbUser);
        this.featurestoreConnectorFacade.deleteByFeaturestoreName(featurestore, dbUser + "_onlinefeaturestore");
    }

    public Double getDbSize(Featurestore featurestore) {
        String onlineName = this.getOnlineFeaturestoreDbName(featurestore.getProject());
        return this.onlineFeaturestoreFacade.getDbSize(onlineName);
    }

    private String generateRandomUserPw() {
        return RandomStringUtils.randomAlphabetic((int)32);
    }

    public Boolean checkIfDatabaseExists(String dbName) {
        return this.onlineFeaturestoreFacade.checkIfDatabaseExists(dbName);
    }

    public String getJdbcURL() throws ServiceDiscoveryException {
        return this.getJdbcURL("");
    }

    private String getJdbcURL(String dbName) throws ServiceDiscoveryException {
        return MYSQL_JDBC + this.serviceDiscoveryController.constructServiceAddressWithPort(ServiceDiscoveryController.HopsworksService.ONLINEFS_MYSQL) + "/" + dbName + MYSQL_PROPERTIES;
    }
}

