/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.code;

import io.hops.hopsworks.common.dao.jobs.description.JobFacade;
import io.hops.hopsworks.common.featurestore.code.CodeActions;
import io.hops.hopsworks.common.featurestore.code.CodeContentFormat;
import io.hops.hopsworks.common.featurestore.code.FeaturestoreCodeFacade;
import io.hops.hopsworks.common.featurestore.featuregroup.cached.FeatureGroupCommitController;
import io.hops.hopsworks.common.hdfs.DistributedFileSystemOps;
import io.hops.hopsworks.common.hdfs.DistributedFsService;
import io.hops.hopsworks.common.hdfs.HdfsUsersController;
import io.hops.hopsworks.common.hdfs.Utils;
import io.hops.hopsworks.common.hdfs.inode.InodeController;
import io.hops.hopsworks.common.jupyter.JupyterController;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.exceptions.ServiceException;
import io.hops.hopsworks.persistence.entity.featurestore.code.FeaturestoreCode;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.Featuregroup;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.FeaturegroupType;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.cached.FeatureGroupCommit;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.cached.TimeTravelFormat;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.TrainingDataset;
import io.hops.hopsworks.persistence.entity.hdfs.inode.Inode;
import io.hops.hopsworks.persistence.entity.jobs.configuration.JobType;
import io.hops.hopsworks.persistence.entity.jobs.configuration.spark.SparkJobConfiguration;
import io.hops.hopsworks.persistence.entity.jobs.description.Jobs;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Locale;
import java.util.UUID;
import java.util.logging.Level;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.commons.lang.NotImplementedException;
import org.apache.hadoop.fs.Path;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class CodeController {
    @EJB
    private Settings settings;
    @EJB
    private JobFacade jobFacade;
    @EJB
    private DistributedFsService dfs;
    @EJB
    private InodeController inodeController;
    @EJB
    private HdfsUsersController hdfsUsersController;
    @EJB
    private JupyterController jupyterController;
    @EJB
    private FeaturestoreCodeFacade featurestoreCodeFacade;
    @EJB
    private FeatureGroupCommitController featureGroupCommitCommitController;
    private static final String CODE = "code";

    public CodeContentFormat getContentFormat(String path) throws FeaturestoreException {
        try {
            return CodeContentFormat.valueOf(Utils.getExtension(path).orElse(CodeContentFormat.JAR.toString()).toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.CODE_READ_ERROR, Level.WARNING, e.getMessage(), e.getMessage(), (Throwable)e);
        }
    }

    public String readContent(Project project, Users user, String path, CodeContentFormat contentFormat, JupyterController.NotebookConversion format) throws FeaturestoreException, ServiceException {
        switch (contentFormat) {
            case JAR: {
                return null;
            }
            case IPYNB: {
                return this.readNotebookContent(project, user, path, format);
            }
            case PY: {
                return this.readPythonFileContent(project, user, path);
            }
            case DBC: {
                return this.readNotebookContent(project, user, path.replace("." + CodeContentFormat.DBC.toString().toLowerCase(), "." + CodeContentFormat.IPYNB.toString().toLowerCase(Locale.ROOT)), format);
            }
        }
        return null;
    }

    private String readNotebookContent(Project project, Users user, String path, JupyterController.NotebookConversion format) throws ServiceException {
        String hdfsUsername = this.hdfsUsersController.getHdfsUserName(project, user);
        if (format == JupyterController.NotebookConversion.HTML) {
            return this.jupyterController.convertIPythonNotebook(hdfsUsername, path, project, "", format);
        }
        return null;
    }

    private String readPythonFileContent(Project project, Users user, String path) throws FeaturestoreException {
        DistributedFileSystemOps udfso = this.dfs.getDfsOps(this.hdfsUsersController.getHdfsUserName(project, user));
        try {
            String string = udfso.cat(path);
            return string;
        }
        catch (IOException e) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.CODE_READ_ERROR, Level.WARNING, e.getMessage(), e.getMessage(), (Throwable)e);
        }
        finally {
            this.dfs.closeDfsClient(udfso);
        }
    }

    public FeaturestoreCode registerCode(Project project, Users user, Long codeCommitTimeStamp, Long fgCommitId, String applicationId, Featuregroup featuregroup, String entityId, String databricksNotebook, byte[] databricksArchive, CodeActions.RunType type) throws ServiceException, FeaturestoreException {
        Inode codeInode = this.saveCode(project, user, applicationId, featuregroup, entityId, databricksNotebook, databricksArchive, type);
        Timestamp commitTime = new Timestamp(codeCommitTimeStamp);
        FeaturestoreCode featurestoreCode = new FeaturestoreCode((Date)commitTime, codeInode, featuregroup, applicationId);
        if (featuregroup.getFeaturegroupType() == FeaturegroupType.CACHED_FEATURE_GROUP && featuregroup.getCachedFeaturegroup().getTimeTravelFormat() == TimeTravelFormat.HUDI) {
            FeatureGroupCommit featureGroupCommit = this.featureGroupCommitCommitController.findCommitByDate(featuregroup, fgCommitId);
            featurestoreCode.setFeatureGroupCommit(featureGroupCommit);
        }
        return this.featurestoreCodeFacade.update(featurestoreCode);
    }

    public FeaturestoreCode registerCode(Project project, Users user, Long codeCommitTimeStamp, String applicationId, TrainingDataset trainingDataset, String entityId, String databricksNotebook, byte[] databricksArchive, CodeActions.RunType type) throws ServiceException, FeaturestoreException {
        Inode codeInode = this.saveCode(project, user, applicationId, trainingDataset, entityId, databricksNotebook, databricksArchive, type);
        Timestamp commitTime = new Timestamp(codeCommitTimeStamp);
        FeaturestoreCode featurestoreCode = new FeaturestoreCode((Date)commitTime, codeInode, trainingDataset, applicationId);
        return this.featurestoreCodeFacade.update(featurestoreCode);
    }

    private Inode saveCode(Project project, Users user, String applicationId, Featuregroup featureGroup, String entityId, String databricksNotebook, byte[] databricksArchive, CodeActions.RunType type) throws ServiceException, FeaturestoreException {
        Path datasetDir = new Path(Utils.getFeaturestorePath(project, this.settings));
        String datasetName = Utils.getFeaturegroupName(featureGroup);
        return this.saveCode(project, user, applicationId, entityId, datasetDir, datasetName, databricksNotebook, databricksArchive, type);
    }

    private Inode saveCode(Project project, Users user, String applicationId, TrainingDataset trainingDataset, String entityId, String databricksNotebook, byte[] databricksArchive, CodeActions.RunType type) throws ServiceException, FeaturestoreException {
        Path datasetDir = new Path(Utils.getProjectPath(project.getName()), project.getName() + "_" + Settings.ServiceDataset.TRAININGDATASETS.getName());
        String datasetName = Utils.getTrainingDatasetName(trainingDataset);
        return this.saveCode(project, user, applicationId, entityId, datasetDir, datasetName, databricksNotebook, databricksArchive, type);
    }

    private Inode saveCode(Project project, Users user, String applicationId, String entityId, Path datasetDir, String datasetName, String databricksNotebook, byte[] databricksArchive, CodeActions.RunType type) throws ServiceException, FeaturestoreException {
        Path filePath;
        Path codeDir = new Path(datasetDir, CODE);
        Path dirPath = new Path(codeDir, datasetName);
        switch (type) {
            case JUPYTER: {
                filePath = new Path(dirPath, applicationId + ".ipynb");
                this.jupyterController.versionProgram(project, user, entityId, filePath);
                break;
            }
            case JOB: {
                filePath = this.saveJob(project, user, entityId, dirPath, applicationId);
                break;
            }
            case DATABRICKS: {
                filePath = this.saveDatabricks(project, user, dirPath, databricksNotebook, databricksArchive);
                break;
            }
            default: {
                throw new NotImplementedException();
            }
        }
        return this.inodeController.getInodeAtPath(filePath.toString());
    }

    private Path saveJob(Project project, Users user, String entityId, Path dirPath, String applicationId) throws FeaturestoreException {
        Jobs job = this.jobFacade.findByProjectAndName(project, entityId);
        String appPath = null;
        if (job.getJobType() == JobType.SPARK || job.getJobType() == JobType.PYSPARK) {
            appPath = ((SparkJobConfiguration)job.getJobConfig()).getAppPath();
        }
        String extension = Utils.getExtension(appPath).orElse("");
        Path path = new Path(dirPath, applicationId + "." + extension);
        String projectUsername = this.hdfsUsersController.getHdfsUserName(project, user);
        DistributedFileSystemOps udfso = null;
        try {
            udfso = this.dfs.getDfsOps(projectUsername);
            String notebookString = udfso.cat(appPath);
            udfso.create(path, notebookString);
        }
        catch (IOException e) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.CODE_READ_ERROR, Level.WARNING, e.getMessage(), e.getMessage(), (Throwable)e);
        }
        finally {
            this.dfs.closeDfsClient(udfso);
        }
        return path;
    }

    public Path saveDatabricks(Project project, Users user, Path dirPath, String databricksNotebook, byte[] databricksArchive) throws FeaturestoreException {
        String uuid = UUID.randomUUID().toString();
        Path notebookPath = new Path(dirPath, uuid + "." + CodeContentFormat.IPYNB.toString().toLowerCase());
        Path archivePath = new Path(dirPath, uuid + "." + CodeContentFormat.DBC.toString().toLowerCase());
        String projectUsername = this.hdfsUsersController.getHdfsUserName(project, user);
        DistributedFileSystemOps udfso = null;
        try {
            udfso = this.dfs.getDfsOps(projectUsername);
            udfso.create(notebookPath, databricksNotebook);
            udfso.create(archivePath, databricksArchive);
        }
        catch (IOException e) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ERROR_SAVING_CODE, Level.WARNING, e.getMessage(), e.getMessage(), (Throwable)e);
        }
        finally {
            this.dfs.closeDfsClient(udfso);
        }
        return notebookPath;
    }
}

