/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.datavalidation;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.persistence.entity.featurestore.Featurestore;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.datavalidation.FeatureStoreExpectation;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.datavalidation.ValidationRule;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;

@Stateless
public class FeatureStoreExpectationFacade
extends AbstractFacade<FeatureStoreExpectation> {
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    public FeatureStoreExpectationFacade() {
        super(FeatureStoreExpectation.class);
    }

    @Override
    protected EntityManager getEntityManager() {
        return this.em;
    }

    public FeatureStoreExpectation merge(FeatureStoreExpectation featureStoreExpectation) {
        featureStoreExpectation = (FeatureStoreExpectation)this.em.merge((Object)featureStoreExpectation);
        this.em.flush();
        return featureStoreExpectation;
    }

    public FeatureStoreExpectation findById(int id) {
        return (FeatureStoreExpectation)this.em.find(FeatureStoreExpectation.class, (Object)id);
    }

    public List<FeatureStoreExpectation> findByFeaturestoreAndRule(Featurestore featureStore, ValidationRule validationRule) {
        return this.em.createNamedQuery("FeatureStoreExpectation.findByFeaturestoreAndRule", FeatureStoreExpectation.class).setParameter("featureStore", (Object)featureStore).setParameter("validationRules", (Object)validationRule).getResultList();
    }

    public Optional<FeatureStoreExpectation> findByFeaturestoreAndName(Featurestore featureStore, String name) {
        try {
            TypedQuery query = this.em.createNamedQuery("FeatureStoreExpectation.findByFeaturestoreAndName", FeatureStoreExpectation.class).setParameter("featureStore", (Object)featureStore).setParameter("name", (Object)name);
            return Optional.of(query.getSingleResult());
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }

    public AbstractFacade.CollectionInfo findByFeaturestore(Integer offset, Integer limit, Set<? extends AbstractFacade.FilterBy> filters, Set<? extends AbstractFacade.SortBy> sort, Featurestore featurestore) {
        String queryStr = this.buildQuery("SELECT fse FROM FeatureStoreExpectation fse ", filters, sort, "fse.featureStore = :featureStore ");
        String queryCountStr = this.buildQuery("SELECT COUNT(fse.id) FROM FeatureStoreExpectation fse ", filters, sort, "fse.featureStore = :featureStore ");
        TypedQuery query = this.em.createQuery(queryStr, FeatureStoreExpectation.class).setParameter("featureStore", (Object)featurestore);
        TypedQuery queryCount = this.em.createQuery(queryCountStr, FeatureStoreExpectation.class).setParameter("featureStore", (Object)featurestore);
        this.setFilter(filters, (Query)query);
        this.setFilter(filters, (Query)queryCount);
        this.setOffsetAndLim(offset, limit, (Query)query);
        return this.findAll(offset, limit, filters, (Query)query, (Query)queryCount);
    }

    private void setFilter(Set<? extends AbstractFacade.FilterBy> filters, Query q) {
        if (filters == null || filters.isEmpty()) {
            return;
        }
        for (AbstractFacade.FilterBy filterBy : filters) {
            this.setFilterQuery(filterBy, q);
        }
    }

    private void setFilterQuery(AbstractFacade.FilterBy filterBy, Query q) {
        switch (Filters.valueOf(filterBy.getValue())) {
            case NAME: {
                q.setParameter(filterBy.getField(), (Object)filterBy.getParam());
                break;
            }
        }
    }

    private AbstractFacade.CollectionInfo findAll(Integer offset, Integer limit, Set<? extends AbstractFacade.FilterBy> filter, Query query, Query queryCount) {
        this.setOffsetAndLim(offset, limit, query);
        return new AbstractFacade.CollectionInfo((Long)queryCount.getSingleResult(), query.getResultList());
    }

    public static enum Filters {
        NAME("NAME", "fse.name = :name ", "name", "");

        private final String value;
        private final String sql;
        private final String field;
        private final String defaultParam;

        private Filters(String value, String sql, String field, String defaultParam) {
            this.value = value;
            this.sql = sql;
            this.field = field;
            this.defaultParam = defaultParam;
        }

        public String getValue() {
            return this.value;
        }

        public String getDefaultParam() {
            return this.defaultParam;
        }

        public String getSql() {
            return this.sql;
        }

        public String getField() {
            return this.field;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Sorts {
        NAME("NAME", "fse.name ", "ASC");

        private final String value;
        private final String sql;
        private final String defaultParam;

        private Sorts(String value, String sql, String defaultParam) {
            this.value = value;
            this.sql = sql;
            this.defaultParam = defaultParam;
        }

        public String getValue() {
            return this.value;
        }

        public String getDefaultParam() {
            return this.defaultParam;
        }

        public String getSql() {
            return this.sql;
        }

        public String toString() {
            return this.value;
        }
    }
}

