/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.git;

import com.google.common.base.Strings;
import io.hops.hopsworks.common.dao.git.GitCommitsFacade;
import io.hops.hopsworks.common.dao.git.GitRepositoryFacade;
import io.hops.hopsworks.common.dao.git.GitRepositoryRemotesFacade;
import io.hops.hopsworks.common.dataset.DatasetController;
import io.hops.hopsworks.common.git.BranchCommits;
import io.hops.hopsworks.common.git.CloneCommandConfiguration;
import io.hops.hopsworks.common.git.CommitCommandConfiguration;
import io.hops.hopsworks.common.git.GitBranchAction;
import io.hops.hopsworks.common.git.GitCommandConfigurationBuilder;
import io.hops.hopsworks.common.git.GitExecutionController;
import io.hops.hopsworks.common.git.GitRemotesAction;
import io.hops.hopsworks.common.git.GitRepositoryAction;
import io.hops.hopsworks.common.git.PullCommandConfiguration;
import io.hops.hopsworks.common.git.PushCommandConfiguration;
import io.hops.hopsworks.common.git.RepositoryActionCommandConfiguration;
import io.hops.hopsworks.common.git.util.GitCommandConfigurationValidator;
import io.hops.hopsworks.common.hdfs.DistributedFileSystemOps;
import io.hops.hopsworks.common.hdfs.DistributedFsService;
import io.hops.hopsworks.common.hdfs.HdfsUsersController;
import io.hops.hopsworks.common.hdfs.inode.InodeController;
import io.hops.hopsworks.exceptions.DatasetException;
import io.hops.hopsworks.exceptions.GitOpException;
import io.hops.hopsworks.exceptions.HopsSecurityException;
import io.hops.hopsworks.persistence.entity.git.CommitterSignature;
import io.hops.hopsworks.persistence.entity.git.GitCommit;
import io.hops.hopsworks.persistence.entity.git.GitOpExecution;
import io.hops.hopsworks.persistence.entity.git.GitRepository;
import io.hops.hopsworks.persistence.entity.git.GitRepositoryRemote;
import io.hops.hopsworks.persistence.entity.git.config.GitCommandConfiguration;
import io.hops.hopsworks.persistence.entity.git.config.GitCommandType;
import io.hops.hopsworks.persistence.entity.hdfs.inode.Inode;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.File;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.hadoop.fs.Path;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class GitController {
    private static final Logger LOGGER = Logger.getLogger(GitController.class.getName());
    @EJB
    private InodeController inodeController;
    @EJB
    private DistributedFsService dfsService;
    @EJB
    private GitRepositoryFacade gitRepositoryFacade;
    @EJB
    private DatasetController datasetController;
    @EJB
    private GitCommitsFacade gitCommitsFacade;
    @EJB
    private HdfsUsersController hdfsUsersController;
    @EJB
    private GitRepositoryRemotesFacade gitRepositoryRemotesFacade;
    @EJB
    private GitCommandConfigurationValidator commandConfigurationValidator;
    @EJB
    private GitExecutionController executionController;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GitOpExecution clone(CloneCommandConfiguration cloneConfigurationDTO, Project project, Users hopsworksUser) throws IllegalArgumentException, GitOpException, HopsSecurityException, DatasetException {
        this.commandConfigurationValidator.verifyCloneOptions(cloneConfigurationDTO);
        String fullRepoDirPath = cloneConfigurationDTO.getPath() + File.separator + this.commandConfigurationValidator.getRepositoryName(cloneConfigurationDTO.getUrl());
        DistributedFileSystemOps udfso = this.dfsService.getDfsOps(this.hdfsUsersController.getHdfsUserName(project, hopsworksUser));
        try {
            this.datasetController.createSubDirectory(project, new Path(fullRepoDirPath), udfso);
        }
        finally {
            this.dfsService.closeDfsClient(udfso);
        }
        Inode inode = this.inodeController.getInodeAtPath(fullRepoDirPath);
        GitRepository repository = this.gitRepositoryFacade.create(inode, project, cloneConfigurationDTO.getProvider(), hopsworksUser);
        this.gitRepositoryRemotesFacade.save(new GitRepositoryRemote(repository, "origin", cloneConfigurationDTO.getUrl()));
        GitCommandConfiguration configuration = new GitCommandConfigurationBuilder().setCommandType(GitCommandType.CLONE).setUrl(cloneConfigurationDTO.getUrl()).setProvider(cloneConfigurationDTO.getProvider()).setPath(fullRepoDirPath).setBranchName(cloneConfigurationDTO.getBranch()).build();
        return this.executionController.createExecution(configuration, project, hopsworksUser, repository);
    }

    public GitOpExecution executeRepositoryAction(RepositoryActionCommandConfiguration configurationDTO, Project project, Users hopsworksUser, GitRepositoryAction action, Integer repositoryId) throws GitOpException, HopsSecurityException {
        switch (action) {
            case PULL: {
                return this.pull((PullCommandConfiguration)configurationDTO, project, hopsworksUser, repositoryId);
            }
            case PUSH: {
                return this.push((PushCommandConfiguration)configurationDTO, project, hopsworksUser, repositoryId);
            }
            case STATUS: {
                return this.status(project, hopsworksUser, repositoryId);
            }
            case COMMIT: {
                return this.commit((CommitCommandConfiguration)configurationDTO, project, hopsworksUser, repositoryId);
            }
        }
        throw new IllegalArgumentException(RESTCodes.GitOpErrorCode.INVALID_REPOSITORY_ACTION.getMessage());
    }

    public GitOpExecution commit(CommitCommandConfiguration commitConfigurationDTO, Project project, Users hopsworksUser, Integer repositoryId) throws IllegalArgumentException, GitOpException, HopsSecurityException {
        this.commandConfigurationValidator.verifyCommitOptions(commitConfigurationDTO);
        String userFullName = hopsworksUser.getFname() + " " + hopsworksUser.getLname();
        GitRepository repository = this.commandConfigurationValidator.verifyRepository(project, repositoryId);
        String repositoryFullPath = this.inodeController.getPath(repository.getInode());
        GitCommandConfiguration commandConfiguration = new GitCommandConfigurationBuilder().setCommandType(GitCommandType.COMMIT).setMessage(commitConfigurationDTO.getMessage()).setFiles(commitConfigurationDTO.getFiles()).setAll(commitConfigurationDTO.isAll()).setCommitter(new CommitterSignature(userFullName, hopsworksUser.getEmail())).setPath(repositoryFullPath).build();
        return this.executionController.createExecution(commandConfiguration, project, hopsworksUser, repository);
    }

    public GitOpExecution executeBranchAction(GitBranchAction action, Project project, Users hopsworksUser, Integer repositoryId, String branchName, String commit) throws GitOpException, HopsSecurityException, IllegalArgumentException {
        GitRepository repository = this.commandConfigurationValidator.verifyRepository(project, repositoryId);
        String repositoryFullPath = this.inodeController.getPath(repository.getInode());
        GitCommandConfigurationBuilder builder = new GitCommandConfigurationBuilder();
        builder.setBranchName(branchName);
        builder.setPath(repositoryFullPath);
        switch (action) {
            case CREATE: 
            case CREATE_CHECKOUT: {
                if (Strings.isNullOrEmpty((String)branchName)) {
                    throw new GitOpException((RESTCodes.RESTErrorCode)RESTCodes.GitOpErrorCode.INVALID_BRANCH_NAME, Level.WARNING, "Branch name is empty.");
                }
                builder.setCommandType(GitCommandType.CREATE_BRANCH);
                builder.setCheckout(action == GitBranchAction.CREATE_CHECKOUT);
                return this.executionController.createExecution(builder.build(), project, hopsworksUser, repository);
            }
            case DELETE: {
                if (Strings.isNullOrEmpty((String)branchName)) {
                    throw new GitOpException((RESTCodes.RESTErrorCode)RESTCodes.GitOpErrorCode.INVALID_BRANCH_NAME, Level.WARNING, "Branch name is empty.");
                }
                builder.setCommandType(GitCommandType.DELETE_BRANCH);
                builder.setDeleteOnRemote(false);
                return this.executionController.createExecution(builder.build(), project, hopsworksUser, repository);
            }
            case CHECKOUT: 
            case CHECKOUT_FORCE: {
                if (Strings.isNullOrEmpty((String)branchName) && Strings.isNullOrEmpty((String)commit)) {
                    throw new GitOpException((RESTCodes.RESTErrorCode)RESTCodes.GitOpErrorCode.INVALID_BRANCH_AND_COMMIT_CHECKOUT_COMBINATION, Level.WARNING, "Please provide either branch or commit to checkout.");
                }
                if (!Strings.isNullOrEmpty((String)branchName) && !Strings.isNullOrEmpty((String)commit)) {
                    throw new GitOpException((RESTCodes.RESTErrorCode)RESTCodes.GitOpErrorCode.INVALID_BRANCH_AND_COMMIT_CHECKOUT_COMBINATION, Level.WARNING, "Checkout requires a commit or branch but not both.");
                }
                builder.setCommandType(GitCommandType.CHECKOUT);
                builder.setCommit(commit);
                builder.setForce(action == GitBranchAction.CHECKOUT_FORCE);
                return this.executionController.createExecution(builder.build(), project, hopsworksUser, repository);
            }
        }
        throw new IllegalArgumentException(RESTCodes.GitOpErrorCode.INVALID_BRANCH_ACTION.getMessage());
    }

    public GitOpExecution addOrDeleteRemote(GitRemotesAction action, Project project, Users hopsworksUser, Integer repositoryId, String remoteName, String remoteUrl) throws GitOpException, IllegalArgumentException, HopsSecurityException {
        if (Strings.isNullOrEmpty((String)remoteName)) {
            throw new IllegalArgumentException(RESTCodes.GitOpErrorCode.INVALID_REMOTE_NAME.getMessage());
        }
        GitRepository repository = this.commandConfigurationValidator.verifyRepository(project, repositoryId);
        String repositoryFullPath = this.inodeController.getPath(repository.getInode());
        GitCommandConfigurationBuilder builder = new GitCommandConfigurationBuilder().setPath(repositoryFullPath).setRemoteName(remoteName);
        switch (action) {
            case ADD: {
                if (Strings.isNullOrEmpty((String)remoteUrl)) {
                    throw new IllegalArgumentException(RESTCodes.GitOpErrorCode.INVALID_REMOTE_URL_PROVIDED.getMessage());
                }
                builder.setCommandType(GitCommandType.ADD_REMOTE);
                builder.setRemoteUrl(remoteUrl);
                return this.executionController.createExecution(builder.build(), project, hopsworksUser, repository);
            }
            case DELETE: {
                builder.setCommandType(GitCommandType.DELETE_REMOTE);
                return this.executionController.createExecution(builder.build(), project, hopsworksUser, repository);
            }
        }
        throw new IllegalArgumentException(RESTCodes.GitOpErrorCode.INVALID_REMOTES_ACTION.getMessage());
    }

    public GitOpExecution push(PushCommandConfiguration configurationDTO, Project project, Users hopsworksUser, Integer repositoryId) throws GitOpException, HopsSecurityException, IllegalArgumentException {
        this.commandConfigurationValidator.verifyRemoteNameAndBranch(configurationDTO.getRemoteName(), configurationDTO.getBranchName());
        GitRepository repository = this.commandConfigurationValidator.verifyRepository(project, repositoryId);
        String repositoryFullPath = this.inodeController.getPath(repository.getInode());
        GitCommandConfiguration pushCommandConfiguration = new GitCommandConfigurationBuilder().setCommandType(GitCommandType.PUSH).setRemoteName(configurationDTO.getRemoteName()).setBranchName(configurationDTO.getBranchName()).setForce(configurationDTO.isForce()).setPath(repositoryFullPath).build();
        return this.executionController.createExecution(pushCommandConfiguration, project, hopsworksUser, repository);
    }

    public GitOpExecution pull(PullCommandConfiguration configDTO, Project project, Users hopsworksUser, Integer repositoryId) throws GitOpException, HopsSecurityException, IllegalArgumentException {
        this.commandConfigurationValidator.verifyRemoteNameAndBranch(configDTO.getRemoteName(), configDTO.getBranchName());
        GitRepository repository = this.commandConfigurationValidator.verifyRepository(project, repositoryId);
        String repositoryFullPath = this.inodeController.getPath(repository.getInode());
        GitCommandConfiguration pullCommandConfiguration = new GitCommandConfigurationBuilder().setCommandType(GitCommandType.PULL).setRemoteName(configDTO.getRemoteName()).setForce(configDTO.isForce()).setBranchName(configDTO.getBranchName()).setPath(repositoryFullPath).build();
        return this.executionController.createExecution(pullCommandConfiguration, project, hopsworksUser, repository);
    }

    public GitOpExecution status(Project project, Users hopsworksUser, Integer repositoryId) throws GitOpException, HopsSecurityException {
        GitRepository repository = this.commandConfigurationValidator.verifyRepository(project, repositoryId);
        String repositoryFullPath = this.inodeController.getPath(repository.getInode());
        GitCommandConfiguration statusCommandConfig = new GitCommandConfigurationBuilder().setCommandType(GitCommandType.STATUS).setPath(repositoryFullPath).build();
        return this.executionController.createExecution(statusCommandConfig, project, hopsworksUser, repository);
    }

    public GitOpExecution fileCheckout(Project project, Users hopsworksUser, Integer repositoryId, List<String> filePaths) throws GitOpException, HopsSecurityException {
        if (filePaths.isEmpty()) {
            throw new IllegalArgumentException("File paths are empty.");
        }
        GitRepository repository = this.commandConfigurationValidator.verifyRepository(project, repositoryId);
        String repositoryFullPath = this.inodeController.getPath(repository.getInode());
        GitCommandConfiguration fileCheckoutConfiguration = new GitCommandConfigurationBuilder().setCommandType(GitCommandType.FILE_CHECKOUT).setPath(repositoryFullPath).setFiles(filePaths).build();
        return this.executionController.createExecution(fileCheckoutConfiguration, project, hopsworksUser, repository);
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void updateBranchCommits(Project project, BranchCommits commits, Integer repositoryId, String branchName) throws GitOpException {
        if (Strings.isNullOrEmpty((String)branchName)) {
            throw new IllegalArgumentException("Branch name cannot be null");
        }
        GitRepository repository = this.commandConfigurationValidator.verifyRepository(project, repositoryId);
        this.gitCommitsFacade.deleteAllInBranchAndRepository(branchName, repository);
        for (GitCommit commit : commits.getCommits()) {
            commit.setBranch(branchName);
            commit.setRepository(repository);
            this.gitCommitsFacade.create(commit);
        }
    }
}

