/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.git.util;

import io.hops.hopsworks.common.dao.git.GitPaths;
import io.hops.hopsworks.common.dao.git.GitRepositoryFacade;
import io.hops.hopsworks.common.git.BasicAuthSecrets;
import io.hops.hopsworks.common.hdfs.HdfsUsersController;
import io.hops.hopsworks.common.security.CertificateMaterializer;
import io.hops.hopsworks.common.security.secrets.SecretsController;
import io.hops.hopsworks.common.util.HopsUtils;
import io.hops.hopsworks.common.util.OSProcessExecutor;
import io.hops.hopsworks.common.util.ProcessDescriptor;
import io.hops.hopsworks.common.util.ProcessResult;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.GitOpException;
import io.hops.hopsworks.exceptions.UserException;
import io.hops.hopsworks.persistence.entity.git.GitOpExecution;
import io.hops.hopsworks.persistence.entity.git.GitRepository;
import io.hops.hopsworks.persistence.entity.git.GitRepositoryRemote;
import io.hops.hopsworks.persistence.entity.git.config.GitProvider;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.persistence.entity.user.security.secrets.VisibilityType;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.commons.io.FileUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class GitCommandOperationUtil {
    private static final Logger LOGGER = Logger.getLogger(GitCommandOperationUtil.class.getName());
    public static final String COMMAND_LOG_FILE_NAME = "command_output.log";
    public static final String HOPSFS_MOUNT_LOG_FILE_NAME = "hopsfs_mount.log";
    @EJB
    private GitRepositoryFacade gitRepositoryFacade;
    @EJB
    private CertificateMaterializer certificateMaterializer;
    @EJB
    private Settings settings;
    @EJB
    private OSProcessExecutor osProcessExecutor;
    @EJB
    private SecretsController secretsController;
    @EJB
    private HdfsUsersController hdfsUsersController;

    public void cleanUp(Project project, Users user, String configSecret) {
        String gitHomePath = this.getGitHome(configSecret);
        try {
            String certificatesDir = Paths.get(gitHomePath, "certificates").toString();
            HopsUtils.cleanupCertificatesForUserCustomDir(user.getUsername(), project.getName(), this.settings.getHdfsTmpCertDir(), this.certificateMaterializer, certificatesDir, this.settings);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to clean up git execution for user " + user.getUsername(), e);
        }
        FileUtils.deleteQuietly((File)new File(gitHomePath));
    }

    public String getLogFileFullPath(String logDirPath, String hdfsUsername, Integer executionId, String logFileName) {
        return logDirPath + File.separator + hdfsUsername + "-" + executionId + "-" + logFileName;
    }

    public void generatePaths(GitPaths gitPaths) throws GitOpException {
        try {
            File baseDir = new File(gitPaths.getGitPath());
            baseDir.mkdirs();
            HashSet<PosixFilePermission> xOnly = new HashSet<PosixFilePermission>();
            xOnly.add(PosixFilePermission.OWNER_WRITE);
            xOnly.add(PosixFilePermission.OWNER_READ);
            xOnly.add(PosixFilePermission.OWNER_EXECUTE);
            xOnly.add(PosixFilePermission.GROUP_WRITE);
            xOnly.add(PosixFilePermission.GROUP_EXECUTE);
            HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
            perms.add(PosixFilePermission.OWNER_READ);
            perms.add(PosixFilePermission.OWNER_WRITE);
            perms.add(PosixFilePermission.OWNER_EXECUTE);
            perms.add(PosixFilePermission.GROUP_READ);
            perms.add(PosixFilePermission.GROUP_WRITE);
            perms.add(PosixFilePermission.GROUP_EXECUTE);
            perms.add(PosixFilePermission.OTHERS_READ);
            perms.add(PosixFilePermission.OTHERS_EXECUTE);
            Files.setPosixFilePermissions(Paths.get(gitPaths.getGitPath(), new String[0]), perms);
            new File(gitPaths.getLogDirPath()).mkdirs();
            new File(gitPaths.getCertificatesDirPath()).mkdirs();
            new File(gitPaths.getRunDirPath()).mkdirs();
            new File(gitPaths.getTokenPath()).mkdirs();
            new File(gitPaths.getConfDirPath()).mkdirs();
        }
        catch (IOException ex) {
            this.removeProjectUserDirRecursive(gitPaths);
            throw new GitOpException((RESTCodes.RESTErrorCode)RESTCodes.GitOpErrorCode.GIT_PATHS_CREATION_ERROR, Level.SEVERE, "Failed to create git paths", ex.getMessage(), (Throwable)ex);
        }
    }

    private void removeProjectUserDirRecursive(GitPaths gitPaths) {
        try {
            FileUtils.deleteDirectory((File)new File(gitPaths.getGitPath()));
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Could not delete Git directory: " + gitPaths.getGitPath(), e);
        }
    }

    public BasicAuthSecrets getAuthenticationSecrets(Users user, GitProvider gitProvider) throws IllegalArgumentException {
        String token = "";
        String username = "";
        try {
            switch (gitProvider) {
                case BITBUCKET: {
                    token = this.secretsController.get(user, "bitbucket_token").getPlaintext();
                    username = this.secretsController.get(user, "bitbucket_username").getPlaintext();
                    return new BasicAuthSecrets(username, token);
                }
                case GIT_HUB: {
                    token = this.secretsController.get(user, "github_token").getPlaintext();
                    username = this.secretsController.get(user, "github_username").getPlaintext();
                    return new BasicAuthSecrets(username, token);
                }
                case GIT_LAB: {
                    token = this.secretsController.get(user, "gitlab_token").getPlaintext();
                    username = this.secretsController.get(user, "gitlab_username").getPlaintext();
                    return new BasicAuthSecrets(username, token);
                }
            }
            throw new IllegalArgumentException("Unsupported git provider");
        }
        catch (UserException e) {
            return new BasicAuthSecrets(username, token);
        }
    }

    public void createAuthenticationSecret(Users user, String username, String token, GitProvider gitProvider) throws UserException {
        String usernameSecretName;
        String tokenSecretName;
        switch (gitProvider) {
            case BITBUCKET: {
                tokenSecretName = "bitbucket_token";
                usernameSecretName = "bitbucket_username";
                break;
            }
            case GIT_HUB: {
                tokenSecretName = "github_token";
                usernameSecretName = "github_username";
                break;
            }
            case GIT_LAB: {
                tokenSecretName = "gitlab_token";
                usernameSecretName = "gitlab_username";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported git provider");
            }
        }
        this.secretsController.add(user, usernameSecretName, username, VisibilityType.PRIVATE, null);
        this.secretsController.add(user, tokenSecretName, token, VisibilityType.PRIVATE, null);
    }

    public List<GitRepositoryRemote> convertToRemote(GitRepository repository, String remotesJson) {
        ArrayList<GitRepositoryRemote> remotes = new ArrayList<GitRepositoryRemote>();
        try {
            JSONArray array = new JSONArray(remotesJson);
            for (int i = 0; i < array.length(); ++i) {
                JSONObject object = array.getJSONObject(i);
                remotes.add(new GitRepositoryRemote(repository, object.getString("name"), object.getString("url")));
            }
        }
        catch (JSONException e) {
            LOGGER.log(Level.SEVERE, "Could not convert json string ", e);
        }
        return remotes;
    }

    public void shutdownCommandService(GitRepository repository, GitOpExecution execution) {
        String cid = repository.getCid();
        try {
            this.gitRepositoryFacade.updateRepositoryCid(repository, null);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to update repository pid", e);
        }
        String gitHomePath = this.getGitHome(execution.getConfigSecret());
        String hdfsUsername = this.hdfsUsersController.getHdfsUserName(repository.getProject(), execution.getUser());
        String prog = this.settings.getSudoersDir() + "/git.sh";
        int exitValue = 0;
        ProcessDescriptor.Builder pdBuilder = new ProcessDescriptor.Builder().addCommand("/usr/bin/sudo").addCommand(prog).addCommand("kill").addCommand(gitHomePath).addCommand(cid).addCommand(hdfsUsername).redirectErrorStream(true).setWaitTimeout(10L, TimeUnit.SECONDS);
        try {
            ProcessResult processResult = this.osProcessExecutor.execute(pdBuilder.build());
            LOGGER.log(Level.FINE, processResult.getStdout());
            exitValue = processResult.getExitCode();
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, "Failed to shutdown git container executing command for user " + hdfsUsername, ex);
        }
        if (exitValue != 0) {
            LOGGER.log(Level.SEVERE, "Exited with " + exitValue + "Failed to shutdown git container executing command for user " + hdfsUsername);
        }
        this.cleanUp(repository.getProject(), execution.getUser(), gitHomePath);
    }

    public String getGitHome(String secret) {
        return this.settings.getStagingDir() + "/private_dirs/" + secret;
    }
}

