/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.util;

import java.nio.file.Path;
import java.util.Hashtable;

public class RemoteCommand {
    private final String host;
    private final String user;
    private final int port;
    private final String command;
    private final Path identity;
    private final Hashtable<String, String> sshConfig;
    private final int connectTimeout;
    private final int executionTimeout;

    private RemoteCommand(Builder builder) {
        this.host = builder.host;
        this.user = builder.user;
        this.port = builder.port;
        this.command = builder.command;
        this.identity = builder.identity;
        this.sshConfig = builder.sshConfig;
        this.connectTimeout = builder.connectTimeoutMS;
        this.executionTimeout = builder.executionTimeoutS;
    }

    public String getHost() {
        return this.host;
    }

    public String getUser() {
        return this.user;
    }

    public int getPort() {
        return this.port;
    }

    public String getCommand() {
        return this.command;
    }

    public Path getIdentity() {
        return this.identity;
    }

    public Hashtable<String, String> getSSHConfig() {
        return this.sshConfig;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getExecutionTimeout() {
        return this.executionTimeout;
    }

    public String toString() {
        return this.user + "@" + this.host + ":" + this.port + "/" + this.command;
    }

    public static class Builder {
        private String host;
        private String user;
        private int port = 22;
        private String command;
        private Path identity;
        private Hashtable<String, String> sshConfig = new Hashtable();
        private int connectTimeoutMS = 10000;
        private int executionTimeoutS = 60;

        public Builder setHost(String host) {
            this.host = host;
            return this;
        }

        public Builder setUser(String user) {
            this.user = user;
            return this;
        }

        public Builder setPort(int port) {
            this.port = port;
            return this;
        }

        public Builder setCommand(String command) {
            this.command = command;
            return this;
        }

        public Builder setIdentity(Path identity) {
            this.identity = identity;
            return this;
        }

        public Builder addSSHConfig(String name, String value) {
            this.sshConfig.put(name, value);
            return this;
        }

        public Builder addSSHConfig(Hashtable<String, String> sshConfig) {
            this.sshConfig = sshConfig;
            return this;
        }

        public Builder setConnectTimeoutMS(int connectTimeoutMS) {
            this.connectTimeoutMS = connectTimeoutMS;
            return this;
        }

        public Builder setExecutionTimeoutS(int executionTimeoutS) {
            this.executionTimeoutS = executionTimeoutS;
            return this;
        }

        public RemoteCommand build() {
            this.checkForNullOrEmpty(this.host, "Host");
            this.checkForNullOrEmpty(this.user, "User");
            if (this.port < 1) {
                throw new IllegalArgumentException("Port cannot be less than 1");
            }
            this.checkForNullOrEmpty(this.command, "Command");
            this.checkForNull(this.identity, "Identity");
            this.checkForNull(this.sshConfig, "SSH config");
            if (this.connectTimeoutMS < 0) {
                throw new IllegalArgumentException("Connect timeout cannot be negative, use 0 to wait forever");
            }
            if (this.executionTimeoutS < 0) {
                throw new IllegalArgumentException("Execution timeout cannot be negative, use 0 to wait forever");
            }
            return new RemoteCommand(this);
        }

        private void checkForNullOrEmpty(String parameterValue, String parameterName) {
            this.checkForNull(parameterValue, parameterName);
            this.checkForEmpty(parameterValue, parameterName);
        }

        private <E> void checkForNull(E parameterValue, String parameterName) {
            if (parameterValue == null) {
                throw new IllegalArgumentException(parameterName + " cannot be null");
            }
        }

        private void checkForEmpty(String parameterValue, String parameterName) {
            if (parameterValue.isEmpty()) {
                throw new IllegalArgumentException(parameterName + " cannot be empty");
            }
        }
    }
}

