/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.provenance.core.opensearch;

import com.lambdista.util.Try;
import io.hops.hopsworks.common.provenance.core.opensearch.OpenSearchHits;
import org.opensearch.search.SearchHit;

public class OpenSearchHitsHandlerImpl<R, S>
implements OpenSearchHits.Handler<R, S> {
    private final OpenSearchHits.Parser<R> parser;
    private Try<S> state;
    private final OpenSearchHits.Merger<R, S> stateMerger;

    public OpenSearchHitsHandlerImpl(OpenSearchHits.Parser<R> parser, S state, OpenSearchHits.Merger<R, S> stateMerger) {
        this.parser = parser;
        this.state = Try.apply(() -> state);
        this.stateMerger = stateMerger;
    }

    @Override
    public Try<S> apply(SearchHit[] hits) {
        for (SearchHit hit : hits) {
            this.state = this.state.flatMap(s -> ((Try)this.parser.apply(hit)).flatMap(r -> (Try)this.stateMerger.apply(r, s)));
        }
        return this.state;
    }
}

