/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dataset;

import io.hops.hopsworks.common.util.ProjectUtils;
import io.hops.hopsworks.exceptions.DatasetException;
import io.hops.hopsworks.exceptions.ProjectException;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FolderNameValidator {
    private static String PLACE_HOLDER = "%%s%%";
    private static String PROJECT_NAME_REGEX = "^(?!^Projects$)" + PLACE_HOLDER + "(?!^[0-9]*$)[a-zA-Z0-9]((?!__)(?!_featurestore)[_a-zA-Z0-9]){0,22}[a-zA-Z0-9]$";
    private static String DATASET_NAME_REGEX = "^((?!__)(?!^Projects$|^download$|^upload$|^tags$)" + PLACE_HOLDER + "[-_a-zA-Z0-9\\.]){1,87}[-_a-zA-Z0-9]$";
    private static Pattern projectNameRegexValidator = Pattern.compile(PROJECT_NAME_REGEX.replace(PLACE_HOLDER, ""), 2);
    private static Pattern datasetNameRegex = Pattern.compile(DATASET_NAME_REGEX.replace(PLACE_HOLDER, ""), 2);

    public static void isValidName(String name) throws DatasetException {
        if (name == null) {
            throw new IllegalArgumentException("Dataset name is null");
        }
        Matcher m = datasetNameRegex.matcher(name);
        if (!m.find()) {
            throw new DatasetException(RESTCodes.DatasetErrorCode.DATASET_NAME_INVALID, Level.FINE);
        }
    }

    public static void isValidProjectName(ProjectUtils projectUtils, String name) throws ProjectException {
        if (name == null) {
            throw new IllegalArgumentException("Project name is null");
        }
        if (name.length() > 25) {
            throw new ProjectException(RESTCodes.ProjectErrorCode.PROJECT_NAME_TOO_LONG, Level.FINE);
        }
        if (projectUtils.isReservedProjectName(name)) {
            throw new ProjectException(RESTCodes.ProjectErrorCode.RESERVED_PROJECT_NAME, Level.FINE);
        }
        Matcher m = projectNameRegexValidator.matcher(name);
        if (!m.find()) {
            throw new ProjectException(RESTCodes.ProjectErrorCode.INVALID_PROJECT_NAME, Level.FINE);
        }
    }

    public static Pattern getProjectNameRegexValidator() {
        return projectNameRegexValidator;
    }

    public static Pattern getDatasetNameRegex() {
        return datasetNameRegex;
    }

    public static String getProjectNameRegexStr(Set<String> reservedProjectNames) {
        StringBuilder reservedProjectNamesStr = new StringBuilder();
        for (String word : reservedProjectNames) {
            reservedProjectNamesStr.append("(?!^" + word + "$)");
        }
        return PROJECT_NAME_REGEX.replace(PLACE_HOLDER, reservedProjectNamesStr.toString());
    }

    public static String getDatasetNameRegexStr() {
        return DATASET_NAME_REGEX.replace(PLACE_HOLDER, "");
    }
}

