/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.storageconnectors.redshift;

import com.google.common.base.Strings;
import io.hops.hopsworks.common.dao.user.security.secrets.SecretsFacade;
import io.hops.hopsworks.common.featurestore.storageconnectors.StorageConnectorUtil;
import io.hops.hopsworks.common.featurestore.storageconnectors.redshift.FeaturestoreRedshiftConnectorDTO;
import io.hops.hopsworks.common.security.secrets.SecretsController;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.exceptions.ProjectException;
import io.hops.hopsworks.exceptions.UserException;
import io.hops.hopsworks.persistence.entity.featurestore.Featurestore;
import io.hops.hopsworks.persistence.entity.featurestore.storageconnector.FeaturestoreConnector;
import io.hops.hopsworks.persistence.entity.featurestore.storageconnector.redshift.FeatureStoreRedshiftConnector;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.persistence.entity.user.security.secrets.Secret;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.transaction.Transactional;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class FeaturestoreRedshiftConnectorController {
    private static final Logger LOGGER = Logger.getLogger(FeaturestoreRedshiftConnectorController.class.getName());
    @EJB
    private SecretsController secretsController;
    @EJB
    private SecretsFacade secretsFacade;
    @EJB
    private Settings settings;
    @EJB
    private StorageConnectorUtil storageConnectorUtil;

    public FeaturestoreRedshiftConnectorDTO getRedshiftConnectorDTO(FeaturestoreConnector featurestoreConnector) throws FeaturestoreException {
        FeaturestoreRedshiftConnectorDTO featurestoreRedshiftConnectorDTO = new FeaturestoreRedshiftConnectorDTO(featurestoreConnector);
        featurestoreRedshiftConnectorDTO.setDatabasePassword(this.storageConnectorUtil.getSecret(featurestoreConnector.getRedshiftConnector().getSecret(), String.class));
        featurestoreRedshiftConnectorDTO.setArguments(this.storageConnectorUtil.toOptions(featurestoreConnector.getRedshiftConnector().getArguments()));
        return featurestoreRedshiftConnectorDTO;
    }

    public FeatureStoreRedshiftConnector createFeaturestoreRedshiftConnector(Users user, Featurestore featurestore, FeaturestoreRedshiftConnectorDTO featurestoreRedshiftConnectorDTO) throws FeaturestoreException, UserException, ProjectException {
        this.verifyCreateDTO(featurestoreRedshiftConnectorDTO);
        FeatureStoreRedshiftConnector featurestoreRedshiftConnector = new FeatureStoreRedshiftConnector();
        this.setConnector(featurestoreRedshiftConnector, featurestoreRedshiftConnectorDTO);
        this.setPassword(user, featurestoreRedshiftConnectorDTO, featurestore, featurestoreRedshiftConnector);
        return featurestoreRedshiftConnector;
    }

    private void setConnector(FeatureStoreRedshiftConnector featurestoreRedshiftConnector, FeaturestoreRedshiftConnectorDTO featurestoreRedshiftConnectorDTO) {
        featurestoreRedshiftConnector.setClusterIdentifier(this.storageConnectorUtil.getValueOrNull(featurestoreRedshiftConnectorDTO.getClusterIdentifier()));
        featurestoreRedshiftConnector.setDatabaseDriver(this.storageConnectorUtil.getValueOrNull(featurestoreRedshiftConnectorDTO.getDatabaseDriver()));
        featurestoreRedshiftConnector.setDatabaseEndpoint(this.storageConnectorUtil.getValueOrNull(featurestoreRedshiftConnectorDTO.getDatabaseEndpoint()));
        featurestoreRedshiftConnector.setDatabaseName(this.storageConnectorUtil.getValueOrNull(featurestoreRedshiftConnectorDTO.getDatabaseName()));
        featurestoreRedshiftConnector.setDatabasePort(featurestoreRedshiftConnectorDTO.getDatabasePort().intValue());
        featurestoreRedshiftConnector.setTableName(this.storageConnectorUtil.getValueOrNull(featurestoreRedshiftConnectorDTO.getTableName()));
        featurestoreRedshiftConnector.setDatabaseUserName(this.storageConnectorUtil.getValueOrNull(featurestoreRedshiftConnectorDTO.getDatabaseUserName()));
        featurestoreRedshiftConnector.setIamRole(this.storageConnectorUtil.getValueOrNull(featurestoreRedshiftConnectorDTO.getIamRole()));
        featurestoreRedshiftConnector.setAutoCreate(featurestoreRedshiftConnectorDTO.getAutoCreate());
        featurestoreRedshiftConnector.setDatabaseGroup(this.storageConnectorUtil.getValueOrNull(featurestoreRedshiftConnectorDTO.getDatabaseGroup()));
        featurestoreRedshiftConnector.setArguments(this.storageConnectorUtil.getValueOrNull(this.storageConnectorUtil.fromOptions(featurestoreRedshiftConnectorDTO.getArguments())));
    }

    private void setPassword(Users user, FeaturestoreRedshiftConnectorDTO featurestoreRedshiftConnectorDTO, Featurestore featurestore, FeatureStoreRedshiftConnector featurestoreRedshiftConnector) throws UserException, ProjectException {
        if (!Strings.isNullOrEmpty((String)featurestoreRedshiftConnectorDTO.getDatabasePassword())) {
            Secret secret = this.secretsController.createSecretForProject(user, this.storageConnectorUtil.createSecretName(featurestore.getId(), featurestoreRedshiftConnectorDTO.getName(), featurestoreRedshiftConnectorDTO.getStorageConnectorType()), featurestoreRedshiftConnectorDTO.getDatabasePassword(), featurestore.getProject().getId());
            featurestoreRedshiftConnector.setSecret(secret);
        }
    }

    private void verifyCreateDTO(FeaturestoreRedshiftConnectorDTO featurestoreRedshiftConnectorDTO) throws FeaturestoreException {
        if (featurestoreRedshiftConnectorDTO == null) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STORAGE_CONNECTOR_ARG, Level.FINE, "Null input data");
        }
        if (this.storageConnectorUtil.isNullOrWhitespace(featurestoreRedshiftConnectorDTO.getClusterIdentifier())) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STORAGE_CONNECTOR_ARG, Level.FINE, "Cluster identifier can not be empty.");
        }
        if (this.storageConnectorUtil.isNullOrWhitespace(featurestoreRedshiftConnectorDTO.getDatabaseDriver())) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STORAGE_CONNECTOR_ARG, Level.FINE, "Database driver can not be empty.");
        }
        if (this.storageConnectorUtil.isNullOrWhitespace(featurestoreRedshiftConnectorDTO.getDatabaseEndpoint())) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STORAGE_CONNECTOR_ARG, Level.FINE, "Database endpoint can not be empty.");
        }
        if (this.storageConnectorUtil.isNullOrWhitespace(featurestoreRedshiftConnectorDTO.getDatabaseName())) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STORAGE_CONNECTOR_ARG, Level.FINE, "Database name can not be empty.");
        }
        if (featurestoreRedshiftConnectorDTO.getDatabasePort() == null || featurestoreRedshiftConnectorDTO.getDatabasePort() < 1150 || featurestoreRedshiftConnectorDTO.getDatabasePort() > 65535) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STORAGE_CONNECTOR_ARG, Level.FINE, "Database port should be between 1150 and 65535.");
        }
        if ((featurestoreRedshiftConnectorDTO.getAutoCreate() == null || !featurestoreRedshiftConnectorDTO.getAutoCreate().booleanValue()) && this.storageConnectorUtil.isNullOrWhitespace(featurestoreRedshiftConnectorDTO.getDatabaseUserName())) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STORAGE_CONNECTOR_ARG, Level.FINE, "Database username can not be empty.");
        }
        String arguments = this.storageConnectorUtil.fromOptions(featurestoreRedshiftConnectorDTO.getArguments());
        if (!Strings.isNullOrEmpty((String)arguments) && arguments.length() > 2000) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STORAGE_CONNECTOR_ARG, Level.FINE, "Redshift connection arguments should not exceed: 2000 characters");
        }
        this.verifyPassword(featurestoreRedshiftConnectorDTO);
    }

    private void verifyPassword(FeaturestoreRedshiftConnectorDTO featurestoreRedshiftConnectorDTO) throws FeaturestoreException {
        this.verifyPassword(featurestoreRedshiftConnectorDTO.getIamRole(), featurestoreRedshiftConnectorDTO.getDatabasePassword());
    }

    private void verifyPassword(String iamRole, String password) throws FeaturestoreException {
        if (!Strings.isNullOrEmpty((String)iamRole) && !Strings.isNullOrEmpty((String)password)) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STORAGE_CONNECTOR_ARG, Level.FINE, "Database password is not allowed.");
        }
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    @Transactional(rollbackOn={FeaturestoreException.class})
    public FeatureStoreRedshiftConnector updateFeaturestoreRedshiftConnector(Users user, Featurestore featurestore, FeaturestoreRedshiftConnectorDTO featurestoreRedshiftConnectorDTO, FeatureStoreRedshiftConnector featureStoreRedshiftConnector) throws FeaturestoreException, UserException, ProjectException {
        this.verifyCreateDTO(featurestoreRedshiftConnectorDTO);
        this.setConnector(featureStoreRedshiftConnector, featurestoreRedshiftConnectorDTO);
        Secret secret = null;
        if (this.storageConnectorUtil.shouldUpdate(this.storageConnectorUtil.getSecret(featureStoreRedshiftConnector.getSecret(), String.class), featurestoreRedshiftConnectorDTO.getDatabasePassword())) {
            secret = this.updatePassword(user, featurestoreRedshiftConnectorDTO, featurestore, featureStoreRedshiftConnector);
        }
        featureStoreRedshiftConnector.setArguments(this.storageConnectorUtil.fromOptions(featurestoreRedshiftConnectorDTO.getArguments()));
        if (featureStoreRedshiftConnector.getSecret() == null && secret != null) {
            this.secretsFacade.deleteSecret(secret.getId());
        }
        return featureStoreRedshiftConnector;
    }

    private Secret updatePassword(Users user, FeaturestoreRedshiftConnectorDTO featurestoreRedshiftConnectorDTO, Featurestore featurestore, FeatureStoreRedshiftConnector featureStoreRedshiftConnector) throws UserException, ProjectException {
        Secret secret = featureStoreRedshiftConnector.getSecret();
        if (secret != null) {
            this.secretsController.checkCanAccessSecret(secret, user);
        }
        if (secret == null && !Strings.isNullOrEmpty((String)featurestoreRedshiftConnectorDTO.getDatabasePassword())) {
            this.setPassword(user, featurestoreRedshiftConnectorDTO, featurestore, featureStoreRedshiftConnector);
        } else if (!Strings.isNullOrEmpty((String)featurestoreRedshiftConnectorDTO.getDatabasePassword())) {
            try {
                secret.setSecret(this.secretsController.encryptSecret(featurestoreRedshiftConnectorDTO.getDatabasePassword()));
            }
            catch (IOException | GeneralSecurityException e) {
                throw new UserException(RESTCodes.UserErrorCode.SECRET_ENCRYPTION_ERROR, Level.SEVERE, "Error encrypting secret", "Could not encrypt Secret " + secret.getId().getName(), (Throwable)e);
            }
        } else {
            featureStoreRedshiftConnector.setSecret(null);
        }
        return secret;
    }
}

